/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.command;

import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportMessage;

class RRDatagram {
    private TransportMessage packet;
    public static final int SEQID_FIRST = 1;
    public static final byte VERSION = 1;
    public static final int HEADER_SIZE = 9;
    public static final int CONTENT_OFFSET = 30;
    public static final int MAX_OFFSET = 1399;
    public static final byte FLAG_REQUEST = 1;
    public static final byte FLAG_REPLY = 2;
    public static final byte FLAG_LAST_PACKET = 4;
    public static final byte FLAG_STATUS = 8;

    RRDatagram(RoxAddress destination, int interactionId, int seqId, byte flags) {
        this.packet = TransportMessage.createMessage(destination);
        this.setVersion((byte)1);
        this.setInteractionId(interactionId);
        this.setSequenceId(seqId);
        this.setFlags(flags);
    }

    RRDatagram(TransportMessage msg) {
        this.packet = msg;
    }

    RRDatagram(RoxAddress destination) {
        this.packet = TransportMessage.createMessage(destination);
        this.setVersion((byte)1);
    }

    void setVersion(byte b) {
        this.packet.body[21] = (byte)(this.packet.body[21] | 0xF0 & b << 4);
    }

    void setFlags(byte b) {
        this.packet.body[21] = (byte)(this.packet.body[21] | 0xF & b);
    }

    void setInteractionId(int interId) {
        int offset = 21 + 1;
        this.packet.body[offset++] = (byte)(0xFF & interId >> 24);
        this.packet.body[offset++] = (byte)(0xFF & interId >> 16);
        this.packet.body[offset++] = (byte)(0xFF & interId >> 8);
        this.packet.body[offset] = (byte)(0xFF & interId);
    }

    void setSequenceId(int seqId) {
        int offset = 21 + 1 + 4;
        this.packet.body[offset++] = (byte)(0xFF & seqId >> 24);
        this.packet.body[offset++] = (byte)(0xFF & seqId >> 16);
        this.packet.body[offset++] = (byte)(0xFF & seqId >> 8);
        this.packet.body[offset++] = (byte)(0xFF & seqId);
    }

    byte getVersion() {
        return (byte)((this.packet.body[21] & 0xF0) >> 4);
    }

    byte getFlags() {
        return (byte)(this.packet.body[21] & 0xF);
    }

    int getInteractionId() {
        int offset = 21 + 1;
        int interId = (this.packet.body[offset++] & 0xFF) << 24 | (this.packet.body[offset++] & 0xFF) << 16 | (this.packet.body[offset++] & 0xFF) << 8 | this.packet.body[offset] & 0xFF;
        return interId;
    }

    int getSequenceId() {
        int offset = 21 + 1 + 4;
        int seqId = (this.packet.body[offset++] & 0xFF) << 24 | (this.packet.body[offset++] & 0xFF) << 16 | (this.packet.body[offset++] & 0xFF) << 8 | this.packet.body[offset] & 0xFF;
        return seqId;
    }

    int getBodyLength() {
        return this.packet.getLength() - 9;
    }

    void setBodyLength(int length) {
        this.packet.setLength(length + 9);
    }

    byte[] getBody() {
        return this.packet.body;
    }

    boolean isRequest() {
        return (this.getFlags() & 1) > 0;
    }

    boolean isReply() {
        return (this.getFlags() & 2) > 0;
    }

    boolean isLast() {
        return (this.getFlags() & 4) > 0;
    }

    boolean isStatus() {
        return (this.getFlags() & 8) > 0;
    }

    TransportMessage getPacket() {
        return this.packet;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("RRDatagram:version=");
        sb.append(this.getVersion()).append(":flags(").append(this.getFlags());
        sb.append(")=").append(this.getFlagString());
        sb.append(":interactionId=").append(this.getInteractionId());
        sb.append(":sequenceId=").append(this.getSequenceId());
        sb.append(":packet=").append(this.packet);
        return sb.toString();
    }

    String getFlagString() {
        return (this.isRequest() ? "request|" : "") + (this.isReply() ? "reply|" : "") + (this.isLast() ? "last|" : "") + (this.isStatus() ? "status" : "");
    }
}

