/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.command;

import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.command.IllegalProtocolState;
import com.raplix.rolloutexpress.net.command.RRDatagram;
import com.raplix.rolloutexpress.net.command.RequestReply;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.util.logger.Logger;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Vector;

class DatagramOutputStream
extends OutputStream {
    private Vector packets = new Vector();
    private int interactionId;
    private boolean request;
    private int curSeqId;
    private RRDatagram curPacket;
    private int curOffset;
    private RoxAddress destId;
    private byte flags;
    private boolean isClosed;
    private RequestReply requestReply;

    DatagramOutputStream(RequestReply rr, RoxAddress destination, int interactionId, boolean request) {
        this.requestReply = rr;
        this.destId = destination;
        this.interactionId = interactionId;
        this.request = request;
        this.isClosed = false;
        this.flags = request ? (byte)1 : (byte)2;
        this.curSeqId = 1;
        this.curPacket = new RRDatagram(this.destId, interactionId, this.curSeqId, this.flags);
        this.curOffset = 30;
    }

    public int getInteractionId() {
        return this.interactionId;
    }

    public void write(int b) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream already closed");
        }
        if (this.curOffset <= 1399) {
            this.curPacket.getBody()[this.curOffset++] = (byte)b;
        } else {
            this.allocateNewPacket();
            this.curPacket.getBody()[this.curOffset++] = (byte)b;
        }
    }

    public RoxAddress getDestId() {
        return this.destId;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream already closed");
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("write:b:" + b.length + ":off:" + off + ":len:" + len, this);
        }
        while (len > 0) {
            int spaceLeft;
            int copyLen;
            if (this.curOffset > 1399) {
                this.allocateNewPacket();
            }
            int n = copyLen = len > (spaceLeft = 1399 - this.curOffset + 1) ? spaceLeft : len;
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("curOffset:" + this.curOffset + ":copyLen:" + copyLen + ":length:" + this.curPacket.getBody().length, this);
            }
            System.arraycopy(b, off, this.curPacket.getBody(), this.curOffset, copyLen);
            len -= copyLen;
            off += copyLen;
            this.curOffset += copyLen;
            if (!Logger.isDebugEnabled(this)) continue;
            Logger.debug("copied:" + copyLen, this);
        }
    }

    public void close() throws IOException {
        this.curPacket.setBodyLength(this.curOffset - 30);
        this.curPacket.setFlags((byte)(this.curPacket.getFlags() | 4));
        this.packets.add(this.curPacket);
        this.isClosed = true;
        try {
            this.requestReply.outputClosed(this);
        }
        catch (TransportException e) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Error sending data", e, this);
            }
            throw new IOException("Error sending data:" + e);
        }
        catch (IllegalProtocolState ips) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Error sending data", ips, this);
            }
            throw new IOException("Error sending data:" + ips);
        }
    }

    private void allocateNewPacket() {
        this.curPacket.setBodyLength(this.curOffset - 30);
        this.packets.add(this.curPacket);
        this.curPacket = new RRDatagram(this.destId, this.interactionId, ++this.curSeqId, this.flags);
        this.curOffset = 30;
    }

    public Iterator getIterator() throws IllegalProtocolState {
        if (this.isClosed) {
            return this.packets.iterator();
        }
        throw new IllegalProtocolState(NetMessageCode.COM_NO_ITER_STREAM_NOT_CLOSED);
    }

    boolean isDone() {
        return this.isClosed;
    }

    public String toString() {
        return this.getClass().getName() + ":Dest:" + this.destId + ":Interaction:" + this.interactionId + ":request:" + this.request + ":flag:" + this.flags;
    }
}

