/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.command;

import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.command.DatagramDeliveryException;
import com.raplix.rolloutexpress.net.command.IllegalProtocolState;
import com.raplix.rolloutexpress.net.command.InvalidDatagram;
import com.raplix.rolloutexpress.net.command.RRDatagram;
import com.raplix.rolloutexpress.net.command.RequestReply;
import com.raplix.rolloutexpress.net.command.TimedOut;
import com.raplix.rolloutexpress.net.transport.ErrorDetails;
import com.raplix.rolloutexpress.net.transport.MessageNotExpected;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.util.logger.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

class DatagramAccumulator {
    private Vector packets = new Vector();
    private int interactionId;
    private RequestReply requestReply;
    private boolean request;
    private boolean receivedLast = false;
    private boolean statusUpdated = false;
    private int curSeqId;
    private RoxAddress sourceId;
    private RoxAddress destId;
    private InputStream inputStream = null;
    private boolean closed = false;
    private DatagramDeliveryException deliveryException = null;

    DatagramAccumulator(RequestReply rr, boolean isRequest, int interactionId) {
        this.requestReply = rr;
        this.request = isRequest;
        this.interactionId = interactionId;
        this.curSeqId = 1;
    }

    DatagramAccumulator(RequestReply rr, RRDatagram packet) throws InvalidDatagram {
        this.requestReply = rr;
        this.sourceId = packet.getPacket().getSourceId();
        this.destId = packet.getPacket().getDestinationId();
        this.interactionId = packet.getInteractionId();
        if (packet.isRequest()) {
            this.request = true;
        } else if (packet.isReply()) {
            this.request = false;
        } else {
            throw new InvalidDatagram(NetMessageCode.COM_PACKET_NEITHER_REQ_NOT_REPLY, packet);
        }
        this.curSeqId = 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    void append(RRDatagram packet) throws MessageNotExpected {
        if (this.request && packet.isRequest() || !this.request && packet.isReply()) {
            if (this.interactionId == packet.getInteractionId()) {
                if (packet.isStatus()) {
                    this.setStatusUpdated();
                    if (!Logger.isDebugEnabled(this)) return;
                    Logger.debug("StatusUpdated:" + packet, this);
                    return;
                }
                if (this.curSeqId == packet.getSequenceId()) {
                    if (this.receivedLast) {
                        if (Logger.isErrorEnabled(this)) {
                            Logger.error("Last packet already seen:InvalidPacket:" + packet, this);
                        }
                        throw new MessageNotExpected(NetMessageCode.COM_LAST_PACKET_SEEN_ALREADY, (Object[])new String[]{packet.toString()});
                    }
                    this.packets.add(packet);
                    ++this.curSeqId;
                    if (packet.isLast()) {
                        this.setReceivedLast();
                    }
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("append:" + packet, this);
                    }
                    if (!this.receivedLast) return;
                    this.requestReply.doneAccumulating(this);
                    return;
                }
                if (Logger.isErrorEnabled(this)) {
                    Logger.error("Sequence Id mismatch:current:" + this.curSeqId + ":packet:" + packet.getSequenceId() + ":packet" + packet, this);
                }
                throw new MessageNotExpected(NetMessageCode.COM_PACKET_SEQUENCE_MISMATCH, (Object[])new String[]{String.valueOf(this.curSeqId), packet.toString()});
            }
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Interaction Id mismatch:current:" + this.interactionId + ":packet:" + packet.getInteractionId() + ":packet" + packet, this);
            }
            throw new MessageNotExpected(NetMessageCode.COM_PACKET_INTERACTION_MISMATCH, (Object[])new String[]{String.valueOf(this.interactionId), packet.toString()});
        }
        if (Logger.isErrorEnabled(this)) {
            Logger.error("Request - reply mismatch:request:" + this.request + ":packet:" + packet, this);
        }
        throw new MessageNotExpected(NetMessageCode.COM_REQ_REPLY_MISMATCH, (Object[])new String[]{String.valueOf(this.request), packet.toString()});
    }

    synchronized void waitForResponse() throws TimedOut, DatagramDeliveryException {
        try {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("wait:" + this, this);
            }
            if (!this.receivedLast) {
                do {
                    this.statusUpdated = false;
                    this.wait(this.requestReply.COMMAND_TIMEOUT);
                    if (!Logger.isDebugEnabled(this)) continue;
                    Logger.debug("After wait:statusUpdated:" + this.statusUpdated, this);
                } while (!this.receivedLast && this.statusUpdated);
            }
        }
        catch (InterruptedException e) {
            throw new TimedOut(NetMessageCode.COM_WAIT_FOR_RESPONSE_INTERRUPTED, (Throwable)e);
        }
        if (!this.receivedLast) {
            throw new TimedOut(NetMessageCode.COM_WAIT_FOR_RESPONSE_TIMEOUT, (Object[])new String[]{String.valueOf(this.requestReply.COMMAND_TIMEOUT)});
        }
        if (this.deliveryException != null) {
            throw (DatagramDeliveryException)this.deliveryException.fillInStackTrace();
        }
    }

    synchronized void notifyWaiters() throws IllegalProtocolState {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("notify:" + this, this);
        }
        if (!this.receivedLast) {
            throw new IllegalProtocolState(NetMessageCode.COM_WAITERS_NOTIFIED_LAST_PACKET_PENDING);
        }
        this.notify();
    }

    void notifyError(ErrorDetails err) throws IllegalProtocolState {
        this.deliveryException = new DatagramDeliveryException(err);
        this.setReceivedLast();
        this.notifyWaiters();
    }

    public boolean isRequest() {
        return this.request;
    }

    public int getInteractionId() {
        return this.interactionId;
    }

    public InputStream getInputStream() throws IllegalProtocolState {
        if (this.receivedLast) {
            if (this.inputStream == null) {
                this.inputStream = new DatagramInputStream();
            }
            return this.inputStream;
        }
        throw new IllegalProtocolState(NetMessageCode.COM_LAST_PACKET_NOT_RECIEVED);
    }

    RoxAddress getSourceId() {
        return this.sourceId;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("DatagramAccumulator:");
        sb.append("sourceId=").append(this.sourceId);
        sb.append("sourceId=").append(this.sourceId);
        sb.append("packets=").append(this.packets);
        sb.append("receivedLast=").append(this.receivedLast);
        return sb.toString();
    }

    boolean isClosed() {
        return this.closed;
    }

    private synchronized void setReceivedLast() {
        this.receivedLast = true;
    }

    private synchronized void setStatusUpdated() {
        this.statusUpdated = true;
    }

    private class DatagramInputStream
    extends InputStream {
        private int curPacketIdx = 0;
        private int curOffset;
        private int maxOffset;
        private boolean eof = false;
        private RRDatagram curPacket;

        DatagramInputStream() {
            if (DatagramAccumulator.this.packets.size() > 0) {
                this.curPacket = (RRDatagram)DatagramAccumulator.this.packets.elementAt(this.curPacketIdx);
                this.curOffset = 30;
                this.maxOffset = this.curPacket.getBodyLength() + this.curOffset - 1;
                this.eof = false;
            } else {
                this.eof = true;
            }
        }

        public int read() throws IOException {
            if (this.eof) {
                return -1;
            }
            if (this.curOffset <= this.maxOffset) {
                return this.curPacket.getBody()[this.curOffset++];
            }
            if (this.getNextPacket() && this.curOffset <= this.maxOffset) {
                return this.curPacket.getBody()[this.curOffset++];
            }
            return -1;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("read:b" + b.length + ":off:" + off + ":len:" + len, this);
            }
            if (off < 0 || len < 0 || b.length < off + len) {
                throw new IndexOutOfBoundsException("array Length:" + b.length + ":offset:" + off + ":length:" + len);
            }
            if (this.eof) {
                return -1;
            }
            int copiedBytes = 0;
            while (len > 0) {
                int copyBytes;
                if (this.curOffset > this.maxOffset && !this.getNextPacket()) {
                    if (copiedBytes > 0) {
                        return copiedBytes;
                    }
                    return -1;
                }
                int availableBytes = this.maxOffset - this.curOffset + 1;
                int n = copyBytes = len > availableBytes ? availableBytes : len;
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("copying:curOffset:" + this.curOffset + ":off:" + off + ":copyBytes:" + copyBytes, this);
                }
                System.arraycopy(this.curPacket.getBody(), this.curOffset, b, off, copyBytes);
                len -= copyBytes;
                off += copyBytes;
                this.curOffset += copyBytes;
                copiedBytes += copyBytes;
            }
            return copiedBytes;
        }

        public long skip(long l) throws IOException {
            if (this.eof) {
                return 0L;
            }
            long skippedBytes = 0L;
            while (l > 0L) {
                if (this.curOffset >= this.maxOffset && !this.getNextPacket()) {
                    return skippedBytes;
                }
                int availableBytes = this.maxOffset - this.curOffset;
                availableBytes = (long)availableBytes < l ? availableBytes : (int)l;
                this.curOffset += availableBytes;
                skippedBytes += (long)availableBytes;
                l -= (long)availableBytes;
            }
            return skippedBytes;
        }

        public int available() throws IOException {
            int length = this.maxOffset - this.curOffset;
            for (int i = this.curPacketIdx + 1; i < DatagramAccumulator.this.packets.size(); ++i) {
                RRDatagram tmp = (RRDatagram)DatagramAccumulator.this.packets.elementAt(i);
                length += tmp.getBodyLength();
            }
            return length;
        }

        public void close() throws IOException {
            this.curPacketIdx = 0;
            this.curOffset = 30;
            DatagramAccumulator.this.closed = true;
        }

        private boolean getNextPacket() {
            ++this.curPacketIdx;
            if (this.curPacketIdx < DatagramAccumulator.this.packets.size()) {
                this.curPacket = (RRDatagram)DatagramAccumulator.this.packets.elementAt(this.curPacketIdx);
                this.curOffset = 30;
                this.maxOffset = this.curPacket.getBodyLength() + this.curOffset - 1;
                return true;
            }
            this.eof = true;
            return false;
        }
    }
}

