/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.command;

import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.command.DatagramAccumulator;
import com.raplix.rolloutexpress.net.command.DatagramOutputStream;
import com.raplix.rolloutexpress.net.command.IllegalProtocolState;
import com.raplix.rolloutexpress.net.command.RequestReply;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import java.io.InputStream;
import java.io.OutputStream;

public class ClientRequest {
    private DatagramOutputStream dos;
    private DatagramAccumulator replyAccumulator;

    ClientRequest(RequestReply rr, RoxAddress dest, int interactionId) {
        this.dos = new DatagramOutputStream(rr, dest, interactionId, true);
        this.replyAccumulator = new DatagramAccumulator(rr, false, interactionId);
    }

    public RoxAddress getDestination() {
        return this.dos.getDestId();
    }

    public OutputStream getOutputStream() {
        return this.dos;
    }

    int getInteractionId() {
        return this.dos.getInteractionId();
    }

    InputStream getInputStream() throws IllegalProtocolState {
        return this.getReplyAccumulator().getInputStream();
    }

    DatagramAccumulator getReplyAccumulator() throws IllegalProtocolState {
        if (!this.dos.isDone()) {
            throw new IllegalProtocolState(NetMessageCode.COM_REQ_OUTPUT_NOT_CLOSED);
        }
        return this.replyAccumulator;
    }

    public String toString() {
        return this.getClass().getName() + ":Destination:" + this.getDestination() + ":InteractionId:" + this.getInteractionId() + ":request:" + this.dos + ":reply:" + this.replyAccumulator;
    }
}

