/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net;

import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.util.logger.Logger;
import com.raplix.util.threadpool.NoMoreThreads;
import com.raplix.util.threads.SafeThread;
import java.util.Iterator;
import java.util.LinkedList;

public final class Scheduler
extends SafeThread {
    public final int LEAST_COUNT;
    private LinkedList tasks = new LinkedList();
    private NetSubsystem netSubsystem;
    private boolean isShutdown = false;

    Scheduler(NetSubsystem nss) throws ConfigurationException {
        super("Scheduler");
        this.setDaemon(true);
        this.netSubsystem = nss;
        this.LEAST_COUNT = nss.getConfigSchedulerLeastCount();
    }

    public void scheduleTask(Runnable task, int freq) throws IllegalArgumentException {
        this.addTask(task, freq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTask(Runnable task, int leastCountMultiple) throws IllegalArgumentException {
        if (leastCountMultiple < 1) {
            throw new IllegalArgumentException("Illegal frequency:" + leastCountMultiple);
        }
        if (task == null) {
            throw new IllegalArgumentException("Null task");
        }
        Task t = new Task(task, leastCountMultiple);
        LinkedList linkedList = this.tasks;
        synchronized (linkedList) {
            this.tasks.add(t);
        }
    }

    public String toString() {
        return this.getClass().getName() + ":tasks" + this.tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.isShutdown) {
            try {
                Thread.sleep(this.LEAST_COUNT);
                LinkedList linkedList = this.tasks;
                synchronized (linkedList) {
                    Iterator iter = this.tasks.iterator();
                    while (iter.hasNext()) {
                        Task task = (Task)iter.next();
                        if (--task.currentCount >= 1) continue;
                        task.currentCount = task.frequency;
                        this.runTask(task.task);
                    }
                }
            }
            catch (InterruptedException ie) {
                if (this.isShutdown) {
                    return;
                }
                if (!Logger.isWarnEnabled(this)) continue;
                Logger.warn("Unexpected exception when sleeping", ie, this);
            }
        }
    }

    public void shutdown() {
        this.isShutdown = true;
        this.interruptSafe();
    }

    private void runTask(Runnable task) {
        block3: {
            try {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Running task:" + task, this);
                }
                this.netSubsystem.getThreadPool().start(task);
            }
            catch (NoMoreThreads nmt) {
                if (!Logger.isWarnEnabled(this)) break block3;
                Logger.warn("Error executing scheduled task:" + task, nmt, this);
            }
        }
    }

    private static class Task {
        final Runnable task;
        final int frequency;
        private int currentCount;

        Task(Runnable task, int freq) {
            this.task = task;
            this.currentCount = this.frequency = freq;
        }

        public String toString() {
            return this.getClass().getName() + ":task:" + this.task + ":freq:" + this.frequency + ":curr:" + this.currentCount;
        }
    }
}

