/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.DefaultConfiguration;
import com.raplix.rolloutexpress.RaplixShutdownException;
import com.raplix.rolloutexpress.SshAgent;
import com.raplix.rolloutexpress.SshDistributor;
import com.raplix.rolloutexpress.SshProxy;
import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.Scheduler;
import com.raplix.rolloutexpress.net.ft.FileTransferManager;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.net.transport.ConnectionSetupAttribute;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.SequentialSshPortAllocator;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.net.transport.TransportManager;
import com.raplix.rolloutexpress.systemmodel.hostdbx.ConnectionType;
import com.raplix.util.platform.common.PlatformUtil;
import com.raplix.util.string.PasswordEscape;
import com.raplix.util.threadpool.ThreadPool;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;

public class NetSubsystem
extends Subsystem {
    private TransportManager tManager;
    private RPCManager rpcManager;
    private FileTransferManager ftManager;
    private ThreadPool threadPool;
    private Scheduler scheduler;
    private boolean postInitDone = false;
    private static final String numClient = "client.nconn";
    private static final String clientType = "client.type.";
    private static final String clientIp = "client.ip.";
    private static final String clientPort = "client.port.";
    private static final String clientParms = "client.parms.";
    private static final String numServer = "server.nconn";
    private static final String serverType = "server.type.";
    private static final String serverIp = "server.ip.";
    private static final String serverPort = "server.port.";
    private static final String serverParms = "server.parms.";
    private static final String numRoute = "route.num";
    private static final String routeDestIp = "route.dest.ip.";
    private static final String routeDestPort = "route.dest.port.";
    private static final String routeNextIp = "route.next.ip.";
    private static final String routeNextPort = "route.next.port.";
    private static final String sshPath = "ssh.path";
    private static final String sshArgs = "ssh.args";
    private static final String javaArgs = "ssh.java.args";
    private static final String remoteAppTestMainClass = "ssh.testmainclass";
    private static final String remoteAppRaMainClass = "ssh.ramainclass";
    private static final String remoteAppLdMainClass = "ssh.ldmainclass";
    private static final String remoteAppProxyMainClass = "ssh.proxymainclass";
    private static final String remoteAppClasspath = "ssh.classpath";
    private static final String remoteAppClasspathPrefix = "ssh.classpath.prefix";
    private static final String remoteAppArgs = "ssh.app.args";
    private static final String rpcSendContext = "rpc.sendcontext";
    private static final String rpcAcceptContextOnServerEndpoint = "rpc.acceptcontextonserverendpoint";
    public static final String commandTimeout = "command.timeout";
    private static final String javaPath = "ssh.javapath";
    private static final String sshPortAllocator = "ssh.portallocator";
    public static final String localIp = "local.ip";
    public static final String localPort = "local.port";
    public static final String remoteIp = "remote.ip";
    public static final String remotePort = "remote.port";
    public static final String transportConfig = "transport.config";
    public static final String msIp = "ms.ip";
    public static final String msPort = "ms.port";
    public static final String rrInboundRequestTimeoutTaskInterval = "command.inboundrequest.timeout.task.interval";
    public static final String rrInboundRequestTimeoutTaskRange = "command.inboundrequest.timeout.task.range";
    public static final String rrStatusMsgTaskInterval = "command.statusmsg.task.interval";
    public static final String rrStatusMsgTaskRange = "command.statusmsg.task.range";
    public static final String schedulerLeastCount = "scheduler.leastCount";
    public static final String ftStaleRequestTimeoutTaskInterval = "ft.staleRequest.timeout.task.interval";
    public static final String ftStaleRequestTimeoutTaskRange = "ft.staleRequest.timeout.task.range";
    public static final String ftResponseWaitTimeout = "ft.request.wait.timeout";
    public static final String connectionHandshakeTimeout = "connection.handshake.timeout";
    public static final String connectionTimeoutTaskRange = "connection.timeout.task.range";
    public static final String connectionTimeoutTaskInterval = "connection.timeout.task.interval";
    public static final String connectionServerBacklog = "connection.server.backlog";
    public static final String transportControlInteractionTimeout = "transport.control.interaction.timeout";
    public static final String threadPoolSize = "threadpool.size";
    public static final String sslProtocol = "ssl.protocol";
    public static final String sslPrivateMgrAlg = "ssl.private.mgr.alg";
    public static final String sslTrustMgrAlg = "ssl.trust.mgr.alg";
    public static final String sslPrivateStoreType = "ssl.private.store.type";
    public static final String sslTrustStoreType = "ssl.trust.store.type";
    public static final String sslCipherSuites = "ssl.cipher.suites";
    public static final String sslClientAuth = "ssl.client.auth";
    public static final String sslTrustStorePath = "ssl.trust.store.path";
    public static final String sslPrivateStorePath = "ssl.private.store.path";
    public static final String sslKeyStorePass = "ssl.key.store.pass";
    public static final String sslInitValidateCerts = "ssl.init.validate.certs";
    public static final String propertyPrefix = "net.";

    public static NetSubsystem createNetSubsystemForMS(Application app) throws ConfigurationException {
        try {
            NetSubsystem nss = new NetSubsystem(app);
            nss.rpcManager = RPCManager.createRPCForMS(nss);
            nss.tManager = TransportManager.createTransportForMS(nss);
            nss.registerProtocols();
            nss.tManager.registerRemoteInterfaces(nss.rpcManager);
            return nss;
        }
        catch (TransportException te) {
            throw new ConfigurationException(NetMessageCode.SYS_CONFIG_TRANSPORT.getCode(), (Throwable)te);
        }
        catch (RPCException rpce) {
            throw new ConfigurationException(NetMessageCode.SYS_CONFIG_SERVICES_TRANSPORT.getCode(), (Throwable)rpce);
        }
    }

    public static NetSubsystem createNetSubsystemForLocal(Application app) throws ConfigurationException {
        try {
            NetSubsystem nss = new NetSubsystem(app);
            nss.rpcManager = RPCManager.createRPCForNode(nss);
            nss.tManager = TransportManager.createTransportForLocal(nss);
            nss.registerProtocols();
            return nss;
        }
        catch (TransportException te) {
            throw new ConfigurationException(NetMessageCode.SYS_CONFIG_TRANSPORT.getCode(), (Throwable)te);
        }
    }

    public static NetSubsystem createNetSubsystemForClient(Application app) throws ConfigurationException {
        try {
            NetSubsystem nss = new NetSubsystem(app);
            nss.rpcManager = RPCManager.createRPCForClient(nss);
            nss.tManager = TransportManager.createTransportForClient(nss);
            nss.registerProtocols();
            nss.postInit();
            return nss;
        }
        catch (TransportException te) {
            throw new ConfigurationException(NetMessageCode.SYS_CONFIG_TRANSPORT.getCode(), (Throwable)te);
        }
    }

    public static NetSubsystem createNetSubsystemForProxy(Application app, InputStream is, OutputStream os) throws ConfigurationException {
        try {
            NetSubsystem nss = new NetSubsystem(app);
            nss.rpcManager = RPCManager.createRPCForClient(nss);
            nss.tManager = TransportManager.createTransportForProxy(nss, is, os);
            return nss;
        }
        catch (TransportException te) {
            throw new ConfigurationException(NetMessageCode.SYS_CONFIG_TRANSPORT.getCode(), (Throwable)te);
        }
    }

    public static NetSubsystem createNetSubsystemForNode(Application app) throws ConfigurationException {
        try {
            NetSubsystem nss = new NetSubsystem(app);
            nss.rpcManager = RPCManager.createRPCForNode(nss);
            nss.tManager = TransportManager.createTransportForNode(nss);
            nss.registerProtocols();
            nss.tManager.registerRemoteInterfaces(nss.rpcManager);
            return nss;
        }
        catch (TransportException te) {
            throw new ConfigurationException(NetMessageCode.SYS_CONFIG_TRANSPORT.getCode(), (Throwable)te);
        }
        catch (RPCException rpce) {
            throw new ConfigurationException(NetMessageCode.SYS_CONFIG_SERVICES.getCode(), (Throwable)rpce);
        }
    }

    public static NetSubsystem createNetSubsystemForNode(Application app, InputStream is, OutputStream os) throws ConfigurationException {
        try {
            NetSubsystem nss = new NetSubsystem(app);
            nss.rpcManager = RPCManager.createRPCForNode(nss);
            nss.tManager = TransportManager.createTransportForNode(nss, is, os);
            nss.registerProtocols();
            nss.tManager.registerRemoteInterfaces(nss.rpcManager);
            return nss;
        }
        catch (TransportException te) {
            throw new ConfigurationException(NetMessageCode.SYS_CONFIG_TRANSPORT.getCode(), (Throwable)te);
        }
        catch (RPCException rpce) {
            throw new ConfigurationException(NetMessageCode.SYS_CONFIG_SERVICES.getCode(), (Throwable)rpce);
        }
    }

    public static NetSubsystem createNetSubsystemForTest(Application app, InputStream is, OutputStream os) throws ConfigurationException {
        try {
            NetSubsystem nss = new NetSubsystem(app);
            nss.rpcManager = RPCManager.createRPCForTest(nss);
            nss.tManager = TransportManager.createTransportForTest(nss, is, os);
            nss.registerProtocols();
            return nss;
        }
        catch (TransportException te) {
            throw new ConfigurationException(NetMessageCode.SYS_CONFIG_TRANSPORT.getCode(), (Throwable)te);
        }
    }

    public static NetSubsystem createNetSubsystemForTest(Application app) throws ConfigurationException {
        try {
            NetSubsystem nss = new NetSubsystem(app);
            nss.rpcManager = RPCManager.createRPCForTest(nss);
            nss.tManager = TransportManager.createTransportForTest(nss);
            nss.registerProtocols();
            nss.postInit();
            return nss;
        }
        catch (TransportException te) {
            throw new ConfigurationException(NetMessageCode.SYS_CONFIG_TRANSPORT.getCode(), (Throwable)te);
        }
    }

    private NetSubsystem() {
    }

    private NetSubsystem(Application app) throws ConfigurationException {
        super(app);
        this.threadPool = new ThreadPool("NetPool", 0, this.getConfigThreadPoolSize());
        this.scheduler = new Scheduler(this);
        this.ftManager = new FileTransferManager(this);
        this.validateTimeoutValues();
    }

    private void validateTimeoutValues() throws ConfigurationException {
        int val;
        int cmdTimeout = this.getCommandTimeout();
        if (cmdTimeout < (val = this.getConfigSchedulerLeastCount() * this.getConfigRRStatusMsgTaskInterval() * this.getConfigRRStatusMsgTaskRange())) {
            throw new ConfigurationException(NetMessageCode.SYS_CONFIG_INVALID_CMD_TIMEOUT.getCode());
        }
    }

    private void registerProtocols() throws TransportException {
        this.tManager.registerProtocolManager(this.rpcManager);
        this.tManager.registerProtocolManager(this.ftManager);
    }

    public void prepareForShutdown() throws RaplixShutdownException {
        super.prepareForShutdown();
    }

    public void shutdown() throws RaplixShutdownException {
        super.shutdown();
        this.tManager.shutdown();
        this.scheduler.shutdown();
    }

    protected DefaultConfiguration[] getDefaultConfiguration() {
        String transportConfigRoot = this.mApplication == null ? "" : this.mApplication.getDataDirAbsPath() + File.separator;
        String transportConfigDefault = transportConfigRoot + transportConfig;
        String homeDirAbsPath = this.mApplication == null ? "" : this.mApplication.getHomeDirAbsPath();
        String trustStorePath = transportConfigRoot + "trust.store";
        String privateStorePath = transportConfigRoot + "private.store";
        String keyMgrAlg = PlatformUtil.isAix() ? "IbmX509" : "SunX509";
        DefaultConfiguration[] defaultConfiguration = new DefaultConfiguration[]{new DefaultConfiguration(numClient, "0", "Number of client connection records"), new DefaultConfiguration(numServer, "0", "Number of server connection records"), new DefaultConfiguration(numRoute, "0", "Number of route records"), new DefaultConfiguration(transportConfig, transportConfigDefault, "Transport config location"), new DefaultConfiguration(sshPath, "ssh", "Path to the ssh executable"), new DefaultConfiguration(rpcSendContext, "false", "Whether RPC should send contexts to connected application instances."), new DefaultConfiguration(rpcAcceptContextOnServerEndpoint, "false", "Whether RPC should accept contexts from message received on server endpoints"), new DefaultConfiguration(remoteAppTestMainClass, "com.raplix.rolloutexpress.net.rpc.test.TestSshServer", "Main class name of the test remote App"), new DefaultConfiguration(remoteAppRaMainClass, SshAgent.class.getName(), "Main class name of the remote App for remote agent"), new DefaultConfiguration(remoteAppLdMainClass, SshDistributor.class.getName(), "Main class name of the remote App for local distributor"), new DefaultConfiguration(remoteAppProxyMainClass, SshProxy.class.getName(), "Main class name of the proxy App for CLUI"), new DefaultConfiguration(remoteAppClasspath, "../common/lib/cr_bs.jar", "Classpath for the remote process"), new DefaultConfiguration(javaPath, "java", "Path to the java executable for the remote process"), new DefaultConfiguration(sshPortAllocator, SequentialSshPortAllocator.class.getName(), "The class used to allocate ssh client-side ports"), new DefaultConfiguration(sshArgs, "-o|BatchMode yes", "Ssh options"), new DefaultConfiguration(javaArgs, "-Xmx128m", "Java options"), new DefaultConfiguration(remoteAppClasspathPrefix, homeDirAbsPath, "Classpath prefix for the remote process"), new DefaultConfiguration(remoteAppArgs, null, "Remote application arguments"), new DefaultConfiguration(commandTimeout, "600000", "Command timeout in milliseconds for RPC commands"), new DefaultConfiguration(ftResponseWaitTimeout, "600000", "File transfer response wait time out (in milliseconds)"), new DefaultConfiguration(transportControlInteractionTimeout, "90000", "Transport control interaction (ping/traceroute) wait timeout (in milliseconds)"), new DefaultConfiguration(connectionHandshakeTimeout, "120000", "Connection handshake completion wait timeout(in milliseconds)"), new DefaultConfiguration(schedulerLeastCount, "60000", "Scheduler's least count (in milliseconds) Scheduler task frequency is expressed as a multiple of this"), new DefaultConfiguration(rrInboundRequestTimeoutTaskInterval, "10", "Request reply inbound request timeout task run interval (multiple of Scheduler least count)"), new DefaultConfiguration(rrInboundRequestTimeoutTaskRange, "6", "Request reply inbound request timeout task range"), new DefaultConfiguration(rrStatusMsgTaskInterval, "1", "Request reply status update message task run interval (multiple of scheduler least count"), new DefaultConfiguration(rrStatusMsgTaskRange, "3", "Request reply status update message task range"), new DefaultConfiguration(ftStaleRequestTimeoutTaskInterval, "3", "File transfer inbound request timeout task run interval (multiple of scheduler least count)"), new DefaultConfiguration(ftStaleRequestTimeoutTaskRange, "10", "File transfer inbound request timeout task range"), new DefaultConfiguration(connectionTimeoutTaskRange, "10", "Connection idle timeout task range"), new DefaultConfiguration(connectionTimeoutTaskInterval, "1", "Connection idle timeout task run interval (multiple of scheduler least count"), new DefaultConfiguration(connectionServerBacklog, "10", "TCP/IP server socket maximum queue length for incoming connection requests"), new DefaultConfiguration(sslProtocol, "SSLv3", "The SSL protocol to use. Valid values are SSL, SSLv2, SSLv3, TLS, TLSv1"), new DefaultConfiguration(sslPrivateMgrAlg, keyMgrAlg, "Private Key Manager algorithm name"), new DefaultConfiguration(sslTrustMgrAlg, keyMgrAlg, "Trust Key Manager algorithm name"), new DefaultConfiguration(sslPrivateStoreType, "JKS", "Private key store type"), new DefaultConfiguration(sslTrustStoreType, "JKS", "Trust key store type"), new DefaultConfiguration(sslCipherSuites, "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "Comma separated list of Enabled SSL Cipher suites"), new DefaultConfiguration(sslClientAuth, "false", "If this node should authenticate SSL clients"), new DefaultConfiguration(sslTrustStorePath, trustStorePath, "The path to the trust key store"), new DefaultConfiguration(sslPrivateStorePath, privateStorePath, "The path to the private key store"), new DefaultConfiguration(sslKeyStorePass, "", "The encoded key store password"), new DefaultConfiguration(sslInitValidateCerts, "true", "If the application should validate the certificates in the keystore on startup"), new DefaultConfiguration(threadPoolSize, "100", "NetSubsystem Thread pool size")};
        return defaultConfiguration;
    }

    public ConnectionSetupAttribute[] getClientConnAttributes() throws ConfigurationException {
        int nConn = this.getConfigurationAsInt(numClient);
        ConnectionSetupAttribute csa = null;
        Vector<ConnectionSetupAttribute> attributes = new Vector<ConnectionSetupAttribute>();
        for (int i = 1; i <= nConn; ++i) {
            csa = new ConnectionSetupAttribute(this.getConfigurationAsString(clientIp + i), this.getConfigurationAsInt(clientPort + i), ConnectionType.FACTORY.get(this.getConfigurationAsString(clientType + i)), this.getConfigurationAsString(clientParms + i));
            attributes.add(csa);
        }
        ConnectionSetupAttribute[] csas = new ConnectionSetupAttribute[attributes.size()];
        return attributes.toArray(csas);
    }

    public ConnectionSetupAttribute[] getServerConnAttributes() throws ConfigurationException {
        ConnectionSetupAttribute csa = null;
        Vector<ConnectionSetupAttribute> attributes = new Vector<ConnectionSetupAttribute>();
        int nConn = this.getConfigurationAsInt(numServer);
        for (int i = 1; i <= nConn; ++i) {
            csa = new ConnectionSetupAttribute(this.getConfigurationAsString(serverIp + i), this.getConfigurationAsInt(serverPort + i), ConnectionType.FACTORY.get(this.getConfigurationAsString(serverType + i)), this.getConfigurationAsString(serverParms + i));
            attributes.add(csa);
        }
        ConnectionSetupAttribute[] csas = new ConnectionSetupAttribute[attributes.size()];
        return attributes.toArray(csas);
    }

    public Hashtable getRoutes() throws ConfigurationException {
        int nRoutes = this.getConfigurationAsInt(numRoute);
        Hashtable<RoxAddress, RoxAddress> routes = new Hashtable<RoxAddress, RoxAddress>();
        try {
            for (int i = 1; i <= nRoutes; ++i) {
                RoxAddress dest = new RoxAddress(this.getConfigurationAsString(routeDestIp + i), this.getConfigurationAsInt(routeDestPort + i));
                RoxAddress next = new RoxAddress(this.getConfigurationAsString(routeNextIp + i), this.getConfigurationAsInt(routeNextPort + i));
                routes.put(dest, next);
            }
        }
        catch (TransportException te) {
            throw new ConfigurationException(NetMessageCode.SYS_CONFIG_ADDRESS.getCode(), (Throwable)te);
        }
        return routes;
    }

    public RoxAddress getLocalAddress() throws TransportException, ConfigurationException {
        String ip = this.getConfigurationAsString(localIp);
        int port = this.getConfigurationAsInt(localPort);
        if (port < 65536 || port > 131071) {
            throw new ConfigurationException(NetMessageCode.SYS_CONFIG_LOCAL_ADDRESS.getCode(), new String[]{String.valueOf(port)});
        }
        return new RoxAddress(ip, port);
    }

    public RoxAddress getRemoteAddress() throws TransportException, ConfigurationException {
        String ip = this.getConfigurationAsString(remoteIp);
        int port = this.getConfigurationAsInt(remotePort);
        if (port < 65536 || port > 131071) {
            throw new ConfigurationException(NetMessageCode.SYS_CONFIG_REMOTE_ADDRESS.getCode(), new String[]{String.valueOf(port)});
        }
        return new RoxAddress(ip, port);
    }

    public String getSSHPath() throws ConfigurationException {
        return this.getConfigurationAsString(sshPath);
    }

    public String getSSHArgs() throws ConfigurationException {
        return this.getConfigurationAsString(sshArgs);
    }

    public String getJavaArgs() throws ConfigurationException {
        return this.getConfigurationAsString(javaArgs);
    }

    public String getAppArgs() throws ConfigurationException {
        return this.getConfigurationAsString(remoteAppArgs);
    }

    public String getRemoteAppTestMainClass() throws ConfigurationException {
        return this.getConfigurationAsString(remoteAppTestMainClass);
    }

    public String getRemoteAppRaMainClass() throws ConfigurationException {
        return this.getConfigurationAsString(remoteAppRaMainClass);
    }

    public String getRemoteAppLdMainClass() throws ConfigurationException {
        return this.getConfigurationAsString(remoteAppLdMainClass);
    }

    public String getRemoteAppProxyMainClass() throws ConfigurationException {
        return this.getConfigurationAsString(remoteAppProxyMainClass);
    }

    public String getRemoteAppClasspath() throws ConfigurationException {
        return this.getConfigurationAsString(remoteAppClasspath);
    }

    public String getRemoteAppClasspathPrefix() throws ConfigurationException {
        return this.getConfigurationAsString(remoteAppClasspathPrefix);
    }

    public String getJavaPath() throws ConfigurationException {
        return this.getConfigurationAsString(javaPath);
    }

    public boolean getRPCSendContext() throws ConfigurationException {
        return this.getConfigurationAsBoolean(rpcSendContext);
    }

    public boolean getRPCAcceptContextOnServerEndpoint() throws ConfigurationException {
        return this.getConfigurationAsBoolean(rpcAcceptContextOnServerEndpoint);
    }

    public String getTransportConfigLocation() throws ConfigurationException {
        return this.getConfigurationAsString(transportConfig);
    }

    public String getSshClientPortAllocator() throws ConfigurationException {
        return this.getConfigurationAsString(sshPortAllocator);
    }

    public int getConfigFTResponseWaitTimeout() throws ConfigurationException {
        return this.getConfigurationAsInt(ftResponseWaitTimeout);
    }

    public int getConfigConnectionHandshakeTimeout() throws ConfigurationException {
        return this.getConfigurationAsInt(connectionHandshakeTimeout);
    }

    public int getConfigTransportControlInteractionTimeout() throws ConfigurationException {
        return this.getConfigurationAsInt(transportControlInteractionTimeout);
    }

    public int getConfigSchedulerLeastCount() throws ConfigurationException {
        return this.getConfigurationAsInt(schedulerLeastCount);
    }

    public int getConfigRRInboundRequestTimeoutTaskInterval() throws ConfigurationException {
        return this.getConfigurationAsInt(rrInboundRequestTimeoutTaskInterval);
    }

    public int getConfigRRInboundRequestTimeoutTaskRange() throws ConfigurationException {
        return this.getConfigurationAsInt(rrInboundRequestTimeoutTaskRange);
    }

    public int getConfigRRStatusMsgTaskInterval() throws ConfigurationException {
        return this.getConfigurationAsInt(rrStatusMsgTaskInterval);
    }

    public int getConfigRRStatusMsgTaskRange() throws ConfigurationException {
        return this.getConfigurationAsInt(rrStatusMsgTaskRange);
    }

    public int getConfigFTStaleRequestTimeoutTaskInterval() throws ConfigurationException {
        return this.getConfigurationAsInt(ftStaleRequestTimeoutTaskInterval);
    }

    public int getConfigFTStaleRequestTimeoutTaskRange() throws ConfigurationException {
        return this.getConfigurationAsInt(ftStaleRequestTimeoutTaskRange);
    }

    public int getConfigConnectionTimeoutTaskRange() throws ConfigurationException {
        return this.getConfigurationAsInt(connectionTimeoutTaskRange);
    }

    public int getConfigConnectionTimeoutTaskInterval() throws ConfigurationException {
        return this.getConfigurationAsInt(connectionTimeoutTaskInterval);
    }

    public int getConfigConnectionServerBacklog() throws ConfigurationException {
        return this.getConfigurationAsInt(connectionServerBacklog);
    }

    public int getConfigThreadPoolSize() throws ConfigurationException {
        return this.getConfigurationAsInt(threadPoolSize);
    }

    public String getConfigSSLProtocol() throws ConfigurationException {
        return this.getConfigurationAsString(sslProtocol);
    }

    public String getConfigSSLPrivateMgrAlg() throws ConfigurationException {
        return this.getConfigurationAsString(sslPrivateMgrAlg);
    }

    public String getConfigSSLTrustMgrAlg() throws ConfigurationException {
        return this.getConfigurationAsString(sslTrustMgrAlg);
    }

    public String getConfigSSLPrivateStoreType() throws ConfigurationException {
        return this.getConfigurationAsString(sslPrivateStoreType);
    }

    public String getConfigSSLTrustStoreType() throws ConfigurationException {
        return this.getConfigurationAsString(sslTrustStoreType);
    }

    public String getConfigSSLCipherSuites() throws ConfigurationException {
        return this.getConfigurationAsString(sslCipherSuites);
    }

    public boolean getConfigSSLClientAuth() throws ConfigurationException {
        return this.getConfigurationAsBoolean(sslClientAuth);
    }

    public String getConfigSSLTrustStorePath() throws ConfigurationException {
        return this.getConfigurationAsString(sslTrustStorePath);
    }

    public String getConfigSSLPrivateStorePath() throws ConfigurationException {
        return this.getConfigurationAsString(sslPrivateStorePath);
    }

    public String getConfigSSLKeyStorePass() throws ConfigurationException {
        try {
            return PasswordEscape.decodePassword(this.getConfigurationAsString(sslKeyStorePass));
        }
        catch (IOException io) {
            throw new ConfigurationException(io);
        }
    }

    public boolean getConfigSSLInitValidateCerts() throws ConfigurationException {
        return this.getConfigurationAsBoolean(sslInitValidateCerts);
    }

    protected String getConfigurationPropertyPrefix() {
        return propertyPrefix;
    }

    public RoxAddress getMSAddress() throws ConfigurationException, TransportException {
        RoxAddress rox = this.getTransport().getMSAddress();
        if (rox == null) {
            rox = new RoxAddress(this.getConfigurationAsString(msIp), this.getConfigurationAsInt(msPort));
        }
        return rox;
    }

    public int getCommandTimeout() throws ConfigurationException {
        return this.getConfigurationAsInt(commandTimeout);
    }

    public TransportManager getTransport() {
        if (this.tManager == null) {
            throw new IllegalStateException("TransportManager not initialized");
        }
        return this.tManager;
    }

    public RPCManager getRPC() {
        if (this.rpcManager == null) {
            throw new IllegalStateException("RPCManager not initialized");
        }
        return this.rpcManager;
    }

    public FileTransferManager getFTManager() {
        return this.ftManager;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public Application getApplication() {
        return this.mApplication;
    }

    public void postInit() throws ConfigurationException {
        if (!this.postInitDone) {
            this.scheduler.start();
            this.tManager.postInit();
            this.postInitDone = true;
        }
    }
}

