/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.node;

import com.raplix.rolloutexpress.migrate.node.NodeUpgradeContext;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeStep;
import com.raplix.rolloutexpress.migrate.node.StepConstraint;
import com.raplix.rolloutexpress.node.NodeUtils;
import java.io.File;

public abstract class UpgradeTransformStep
extends NodeUpgradeStep {
    private String mSourceFileName;
    private String mDestinationFileName;
    private FileResolver mSourceFileResolver;
    private FileResolver mDestinationFileResolver;

    protected File getSourceFile(NodeUpgradeContext ctx) {
        return this.mSourceFileResolver.resolveFile(ctx, this.mSourceFileName);
    }

    protected File getDestinationFile(NodeUpgradeContext ctx) {
        return this.mDestinationFileResolver.resolveFile(ctx, this.mDestinationFileName);
    }

    protected UpgradeTransformStep(StepConstraint inConstraint, String inSourceFileName, String inDestinationFileName) {
        this(inConstraint, inSourceFileName, inDestinationFileName, null, null);
    }

    protected UpgradeTransformStep(StepConstraint inConstraint, String inSourceFileName, String inDestinationFileName, FileResolver inSourceFileResolver, FileResolver inDestinationFileResolver) {
        super(inConstraint);
        this.mSourceFileName = inSourceFileName;
        this.mDestinationFileName = inDestinationFileName;
        this.mSourceFileResolver = inSourceFileResolver == null ? FileResolver.UpgradeTemp : inSourceFileResolver;
        this.mDestinationFileResolver = inDestinationFileResolver == null ? FileResolver.ApplicationHome : inDestinationFileResolver;
    }

    protected String getSourceFileName() {
        return this.mSourceFileName;
    }

    protected String getDestinationFileName() {
        return this.mDestinationFileName;
    }

    public static abstract class FileResolver {
        public static final FileResolver UpgradeTemp = new FileResolver(){

            public File resolveFile(NodeUpgradeContext ctx, String fileName) {
                return new File(ctx.getUpgradeTempFilesDir(), fileName);
            }
        };
        public static final FileResolver UpgradeBackupBase = new FileResolver(){

            public File resolveFile(NodeUpgradeContext ctx, String fileName) {
                return new File(ctx.getUpgradeBackupBaseDir(), fileName);
            }
        };
        public static final FileResolver PlatformUpgradeTemp = new FileResolver(){

            public File resolveFile(NodeUpgradeContext ctx, String fileName) {
                File file = new File(new File(ctx.getUpgradeTempFilesDir(), NodeUtils.getNativeSubDir()), fileName);
                return file.exists() ? file : UpgradeTemp.resolveFile(ctx, fileName);
            }
        };
        public static final FileResolver PlatformAndArchUpgradeTemp = new FileResolver(){

            public File resolveFile(NodeUpgradeContext ctx, String fileName) {
                File file = new File(new File(ctx.getUpgradeTempFilesDir(), NodeUtils.getNativeArchSubDir()), fileName);
                return file.exists() ? file : UpgradeTemp.resolveFile(ctx, fileName);
            }
        };
        public static final FileResolver ApplicationHome = new FileResolver(){

            public File resolveFile(NodeUpgradeContext ctx, String fileName) {
                return new File(ctx.getApplicationHomeDir(), fileName);
            }
        };

        public abstract File resolveFile(NodeUpgradeContext var1, String var2);
    }
}

