/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.node;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeContext;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeStep;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeStepFailureException;
import com.raplix.rolloutexpress.migrate.node.StepConstraint;
import com.raplix.rolloutexpress.migrate.node.UpgradeTransformStep;
import com.raplix.rolloutexpress.node.NodeUtils;
import java.io.File;

public class RemoveFileStep
extends NodeUpgradeStep {
    private String mFileName;
    private UpgradeTransformStep.FileResolver mFileResolver;

    public void executeStep(NodeUpgradeContext ctx) throws NodeUpgradeStepFailureException {
        File file = this.getRemoveFile(ctx);
        String fileName = file.getAbsolutePath();
        ctx.logMessage(new ROXMessage("node.upgrade.app.REMOVE_FILE_START", fileName));
        if (file.isDirectory()) {
            NodeUtils.deleteAllFiles(file);
        }
        file.delete();
        ctx.logMessage(new ROXMessage("node.upgrade.app.REMOVE_FILE_END", fileName));
    }

    protected File getRemoveFile(NodeUpgradeContext ctx) {
        return this.mFileResolver.resolveFile(ctx, this.mFileName);
    }

    public RemoveFileStep(StepConstraint inConstraint, String inFileName) {
        this(inConstraint, inFileName, null);
    }

    public RemoveFileStep(StepConstraint inConstraint, String inFileName, UpgradeTransformStep.FileResolver inFileResolver) {
        super(inConstraint);
        this.mFileName = inFileName;
        this.mFileResolver = inFileResolver == null ? UpgradeTransformStep.FileResolver.ApplicationHome : inFileResolver;
    }

    public ROXMessage getStepDescription() {
        return new ROXMessage("node.upgrade.app.REMOVE_FILE_STEP", this.mFileName);
    }
}

