/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.node;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeContext;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeStep;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeStepFailureException;
import com.raplix.rolloutexpress.migrate.node.StepConstraint;
import com.raplix.rolloutexpress.migrate.node.UpgradeTransformStep;
import com.raplix.util.file.Perl5Transform;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;

public class PropertiesFileTransformStep
extends NodeUpgradeStep {
    private UpgradeTransformStep.FileResolver mSrcFileResolver;
    private UpgradeTransformStep.FileResolver mDestFileResolver;
    private String mSrcFileName;
    private String mDestFileName;
    private String mProperty;
    private Transform mTransform;

    public PropertiesFileTransformStep(StepConstraint constraint, String property, Transform transform, String sourceFileName, String destFileName) {
        this(constraint, property, transform, sourceFileName, destFileName, null, null);
    }

    public PropertiesFileTransformStep(StepConstraint constraint, String property, Transform transform, String sourceFileName, String destFileName, UpgradeTransformStep.FileResolver sourceFileResolver, UpgradeTransformStep.FileResolver destFileResolver) {
        super(constraint);
        if (property == null) {
            throw new IllegalArgumentException("property argument cannot be null");
        }
        if (transform == null) {
            throw new IllegalArgumentException("transform argument cannot be null");
        }
        this.mProperty = property;
        this.mTransform = transform;
        this.mDestFileName = destFileName;
        this.mSrcFileName = sourceFileName;
        this.mSrcFileResolver = sourceFileResolver == null ? UpgradeTransformStep.FileResolver.ApplicationHome : sourceFileResolver;
        this.mDestFileResolver = destFileResolver == null ? UpgradeTransformStep.FileResolver.ApplicationHome : destFileResolver;
    }

    /*
     * Unable to fully structure code
     */
    public void executeStep(NodeUpgradeContext ctx) throws NodeUpgradeStepFailureException {
        srcFile = this.mSrcFileResolver.resolveFile(ctx, this.mSrcFileName);
        destFile = this.mDestFileResolver.resolveFile(ctx, this.mDestFileName);
        ctx.logMessage(new ROXMessage("node.upgrade.app.PROPERTIES_FILE_START", srcFile.toString(), destFile.toString(), this.mProperty));
        propValue = null;
        try {
            props = new Properties();
            in = new FileInputStream(srcFile);
            props.load(in);
            propValue = (String)props.get(this.mProperty);
            in.close();
            if (propValue == null) {
                return;
            }
        }
        catch (IOException e) {
            throw new NodeUpgradeStepFailureException(new ROXMessage("node.upgrade.app.PROPERTIES_FILE_FAIL_LOAD", srcFile.toString()), (Throwable)e);
        }
        reader = null;
        writer = null;
        transformedValue = this.mTransform.transform(propValue);
        transform = new Perl5Transform();
        transform.addSub(new Perl5Transform.Sub("^" + this.mProperty + "=.*", this.mProperty + "=" + transformedValue));
        reader = new FileReader(srcFile);
        writer = new FileWriter(destFile);
        transform.apply(reader, writer);
        var10_11 = null;
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (writer == null) ** GOTO lbl59
            writer.close();
        }
        catch (IOException e) {
            throw new NodeUpgradeStepFailureException(new ROXMessage("node.upgrade.app.PROPERTIES_FILE_FAIL_TRANSFORM", destFile.toString(), this.mProperty), (Throwable)e);
        }
        {
            catch (IOException e) {
                throw new NodeUpgradeStepFailureException(new ROXMessage("node.upgrade.app.PROPERTIES_FILE_FAIL_TRANSFORM", destFile.toString(), this.mProperty), (Throwable)e);
            }
        }
        catch (Throwable var9_15) {
            var10_12 = null;
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                throw new NodeUpgradeStepFailureException(new ROXMessage("node.upgrade.app.PROPERTIES_FILE_FAIL_TRANSFORM", destFile.toString(), this.mProperty), (Throwable)e);
            }
            throw var9_15;
        }
lbl59:
        // 2 sources

        ctx.logMessage(new ROXMessage("node.upgrade.app.PROPERTIES_FILE_END", srcFile.toString(), destFile.toString(), this.mProperty));
    }

    public ROXMessage getStepDescription() {
        return new ROXMessage("node.upgrade.app.PROPERTIES_FILE_STEP", this.mSrcFileName, this.mDestFileName, this.mProperty);
    }

    public static interface Transform {
        public String transform(String var1) throws IOException;
    }
}

