/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.node;

import com.raplix.rolloutexpress.migrate.node.StepConstraint;
import com.raplix.util.platform.common.PlatformUtil;

public abstract class PlatformStepConstraint
implements StepConstraint {
    private boolean mMatchCurrentPlatform = false;

    public PlatformStepConstraint addSolaris() {
        this.updateCurrentPlatform(PlatformUtil.isSolaris());
        return this;
    }

    public PlatformStepConstraint addSolarisX86() {
        this.updateCurrentPlatform(PlatformUtil.isSolarisX86());
        return this;
    }

    public PlatformStepConstraint addSolarisSparc() {
        this.updateCurrentPlatform(PlatformUtil.isSolarisSparc());
        return this;
    }

    public PlatformStepConstraint addAix() {
        this.updateCurrentPlatform(PlatformUtil.isAix());
        return this;
    }

    public PlatformStepConstraint addLinux() {
        this.updateCurrentPlatform(PlatformUtil.isLinux());
        return this;
    }

    public PlatformStepConstraint addLinuxSles() {
        this.updateCurrentPlatform(PlatformUtil.isLinuxSles());
        return this;
    }

    public PlatformStepConstraint addHpux() {
        this.updateCurrentPlatform(PlatformUtil.isHpux());
        return this;
    }

    public PlatformStepConstraint addLinuxRedHat() {
        this.updateCurrentPlatform(PlatformUtil.isLinuxRedHat());
        return this;
    }

    public PlatformStepConstraint addLinux32() {
        this.updateCurrentPlatform(PlatformUtil.isLinux32());
        return this;
    }

    public PlatformStepConstraint addLinux64() {
        this.updateCurrentPlatform(PlatformUtil.isLinux64());
        return this;
    }

    public PlatformStepConstraint addCygwin() {
        this.updateCurrentPlatform(PlatformUtil.isCygwin());
        return this;
    }

    public PlatformStepConstraint addUnix() {
        this.updateCurrentPlatform(PlatformUtil.isUnix());
        return this;
    }

    public PlatformStepConstraint addPosix() {
        this.updateCurrentPlatform(PlatformUtil.isPOSIX());
        return this;
    }

    public PlatformStepConstraint addWin2k() {
        this.updateCurrentPlatform(PlatformUtil.isWin2k());
        return this;
    }

    public PlatformStepConstraint addWin2k3() {
        this.updateCurrentPlatform(PlatformUtil.isWin2k3());
        return this;
    }

    public PlatformStepConstraint addWinXP() {
        this.updateCurrentPlatform(PlatformUtil.isWinXP());
        return this;
    }

    public PlatformStepConstraint addWin32() {
        this.updateCurrentPlatform(PlatformUtil.isWin32());
        return this;
    }

    public PlatformStepConstraint addPureWin32() {
        this.updateCurrentPlatform(PlatformUtil.isPureWin32());
        return this;
    }

    protected boolean currentPlatform() {
        return this.mMatchCurrentPlatform;
    }

    private void updateCurrentPlatform(boolean isCurrentPlatform) {
        this.mMatchCurrentPlatform = this.mMatchCurrentPlatform || isCurrentPlatform;
    }
}

