/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.node;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeContext;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeStepFailureException;
import com.raplix.rolloutexpress.migrate.node.StepConstraint;
import com.raplix.rolloutexpress.migrate.node.UpgradeTransformStep;
import com.raplix.util.file.Perl5Transform;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class Perl5TransformFileStep
extends UpgradeTransformStep {
    private Perl5Transform.Sub[] mSubstitutions;

    public Perl5TransformFileStep(StepConstraint inConstraint, Perl5Transform.Sub[] inSubs, String inSourceFileName, String inDestinationFileName) {
        super(inConstraint, inSourceFileName, inDestinationFileName);
        this.mSubstitutions = inSubs;
    }

    public Perl5TransformFileStep(StepConstraint inConstraint, Perl5Transform.Sub[] inSubs, String inSourceFileName, String inDestinationFileName, UpgradeTransformStep.FileResolver inSourceFileResolver, UpgradeTransformStep.FileResolver inDestinationFileResolver) {
        super(inConstraint, inSourceFileName, inDestinationFileName, inSourceFileResolver, inDestinationFileResolver);
        this.mSubstitutions = inSubs;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeStep(NodeUpgradeContext ctx) throws NodeUpgradeStepFailureException {
        Perl5Transform transform = new Perl5Transform();
        for (int i = 0; i < this.mSubstitutions.length; ++i) {
            transform.addSub(this.mSubstitutions[i]);
        }
        String sourceFile = this.getSourceFile(ctx).getAbsolutePath();
        String destinationFile = this.getDestinationFile(ctx).getAbsolutePath();
        ctx.logMessage(new ROXMessage("node.upgrade.app.PERL5_TRANSFORM_START", sourceFile, destinationFile));
        FileReader reader = null;
        FileWriter writer = null;
        reader = new FileReader(sourceFile);
        writer = new FileWriter(destinationFile);
        transform.apply(reader, writer);
        ctx.logMessage(new ROXMessage("node.upgrade.app.PERL5_TRANSFORM_END", sourceFile, destinationFile));
        Object var9_8 = null;
        try {
            if (reader != null) {
                ((Reader)reader).close();
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            if (writer == null) return;
            ((Writer)writer).close();
            return;
        }
        catch (IOException e) {
            throw new NodeUpgradeStepFailureException(new ROXMessage("node.upgrade.app.PERL5_TRANSFORM_FAIL", sourceFile, destinationFile), (Throwable)e);
        }
        {
            catch (IOException e) {
                throw new NodeUpgradeStepFailureException(new ROXMessage("node.upgrade.app.PERL5_TRANSFORM_FAIL", sourceFile, destinationFile), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                if (reader != null) {
                    ((Reader)reader).close();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            try {
                if (writer == null) throw throwable;
                ((Writer)writer).close();
                throw throwable;
            }
            catch (IOException e) {
                throw new NodeUpgradeStepFailureException(new ROXMessage("node.upgrade.app.PERL5_TRANSFORM_FAIL", sourceFile, destinationFile), (Throwable)e);
            }
        }
    }

    public ROXMessage getStepDescription() {
        return new ROXMessage("node.upgrade.app.PERL5_TRANSFORM_STEP", this.getSourceFileName(), this.getDestinationFileName());
    }
}

