/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.node;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeContext;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeStep;
import com.raplix.rolloutexpress.node.NodeUtils;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OptionalDataException;
import java.util.Properties;

public abstract class NodeUpgradeApp
implements NodeUpgradeContext {
    private File mHomeDir;
    private Properties mProperties;
    public static final String PROPERTY_IS_RA = "rox_is_ra";
    public static final String PROPERTY_IS_LD = "rox_is_ld";
    public static final String PROPERTY_TARGET_VERSION = "rox_upgrade_target_version";
    public static final String PROPERTY_SOURCE_VERSION = "rox_upgrade_source_version";

    protected NodeUpgradeApp() throws IllegalArgumentException {
        Logger.initializeLoggingSystem();
    }

    public File getApplicationHomeDir() {
        return this.mHomeDir;
    }

    public boolean isAppRA() {
        return Boolean.getBoolean(PROPERTY_IS_RA);
    }

    public boolean isAppLD() {
        return Boolean.getBoolean(PROPERTY_IS_LD);
    }

    public String getTargetVersion() {
        return System.getProperty(PROPERTY_TARGET_VERSION);
    }

    public String getSourceVersion() {
        return System.getProperty(PROPERTY_SOURCE_VERSION);
    }

    public File getUpgradeTempFilesDir() {
        return NodeUtils.getUpgradeJarTmpDir(NodeUtils.getUpgradeWorkDir(new File(this.getNodeProperty("rox_data_dir")).getAbsolutePath()));
    }

    public File getUpgradeBackupBaseDir() {
        return new File(NodeUtils.getUpgradeBackupBaseDir(new File(this.getNodeProperty("rox_data_dir")).getAbsolutePath()), this.getSourceVersion());
    }

    public String getNodeProperty(String inName) {
        return this.mProperties.getProperty(inName);
    }

    public void logMessage(ROXMessage message) {
        System.out.println(message.toString());
    }

    public void logError(Exception exception) {
        exception.printStackTrace(System.out);
    }

    protected void run() {
        try {
            this.init();
            NodeUpgradeStep[] steps = this.getUpgradeSteps();
            for (int i = 0; i < steps.length; ++i) {
                NodeUpgradeStep step = steps[i];
                ROXMessage stepDescription = step.getStepDescription();
                if (step.shouldRunStep(this)) {
                    this.logMessage(new ROXMessage("node.upgrade.app.START_STEP", stepDescription.toString()));
                    step.executeStep(this);
                    this.logMessage(new ROXMessage("node.upgrade.app.DONE_STEP", stepDescription.toString()));
                    continue;
                }
                this.logMessage(new ROXMessage("node.upgrade.app.SKIP_STEP", stepDescription.toString()));
            }
            this.exitSucceeded();
        }
        catch (Exception e) {
            this.logError(e);
            this.exitFailed();
        }
    }

    private void init() throws IOException, ClassNotFoundException {
        String homeDir = System.getProperty("rox_home_dir");
        if (homeDir == null) {
            throw new IllegalArgumentException(new ROXMessage("node.upgrade.app.NO_HOME_DIR", "rox_home_dir").toString());
        }
        this.mHomeDir = new File(homeDir);
        if (!this.mHomeDir.isDirectory()) {
            throw new IllegalArgumentException(new ROXMessage("node.upgrade.app.INVALID_HOME_DIR", homeDir).toString());
        }
        this.initProperties();
        this.initBackupBaseDir();
    }

    private void initBackupBaseDir() {
        File backupBaseDir = this.getUpgradeBackupBaseDir();
        NodeUtils.deleteAllFiles(backupBaseDir);
        backupBaseDir.mkdirs();
    }

    protected void initProperties() throws IOException, ClassNotFoundException, OptionalDataException {
        this.mProperties = NodeUtils.streamToProperties(this.getPropertyStream());
    }

    protected InputStream getPropertyStream() {
        return System.in;
    }

    protected void exitFailed() {
        System.exit(1);
    }

    protected void exitSucceeded() {
        System.exit(0);
    }

    public abstract NodeUpgradeStep[] getUpgradeSteps();
}

