/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.node;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeContext;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeStepFailureException;
import com.raplix.rolloutexpress.migrate.node.StepConstraint;
import com.raplix.rolloutexpress.migrate.node.UpgradeTransformStep;
import java.io.File;

public class MoveFileStep
extends UpgradeTransformStep {
    public MoveFileStep(StepConstraint inConstraint, String inSourceFileName, String inDestinationFileName) {
        super(inConstraint, inSourceFileName, inDestinationFileName);
    }

    public MoveFileStep(StepConstraint inConstraint, String inSourceFileName, String inDestinationFileName, UpgradeTransformStep.FileResolver inSourceFileResolver, UpgradeTransformStep.FileResolver inDestinationFileResolver) {
        super(inConstraint, inSourceFileName, inDestinationFileName, inSourceFileResolver, inDestinationFileResolver);
    }

    public void executeStep(NodeUpgradeContext ctx) throws NodeUpgradeStepFailureException {
        File source = this.getSourceFile(ctx);
        File destination = this.getDestinationFile(ctx);
        String sourceFile = source.getAbsolutePath();
        String destinationFile = destination.getAbsolutePath();
        ctx.logMessage(new ROXMessage("node.upgrade.app.MOVE_FILE_START", sourceFile, destinationFile));
        if (!source.renameTo(destination)) {
            throw new NodeUpgradeStepFailureException(new ROXMessage("node.upgrade.app.MOVE_FILE_FAIL", sourceFile, destinationFile));
        }
        ctx.logMessage(new ROXMessage("node.upgrade.app.MOVE_FILE_END", sourceFile, destinationFile));
    }

    public ROXMessage getStepDescription() {
        return new ROXMessage("node.upgrade.app.MOVE_FILE_STEP", this.getSourceFileName(), this.getDestinationFileName());
    }
}

