/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.node;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeContext;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeStep;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeStepFailureException;
import com.raplix.rolloutexpress.migrate.node.StepConstraint;
import com.raplix.rolloutexpress.migrate.node.UpgradeTransformStep;
import java.io.File;

public class MkdirStep
extends NodeUpgradeStep {
    private String mDirName;
    private UpgradeTransformStep.FileResolver mFileResolver;

    public void executeStep(NodeUpgradeContext ctx) throws NodeUpgradeStepFailureException {
        File dir = this.getTargetDir(ctx);
        String dirName = dir.getAbsolutePath();
        ctx.logMessage(new ROXMessage("node.upgrade.app.MKDIR_START", dirName));
        if (!dir.mkdirs() && !dir.isDirectory()) {
            throw new NodeUpgradeStepFailureException(new ROXMessage("node.upgrade.app.MKDIR_FAIL", dirName));
        }
        ctx.logMessage(new ROXMessage("node.upgrade.app.MKDIR_END", dirName));
    }

    protected File getTargetDir(NodeUpgradeContext ctx) {
        return this.mFileResolver.resolveFile(ctx, this.mDirName);
    }

    public MkdirStep(StepConstraint constraint, String dirName) {
        this(constraint, dirName, null);
    }

    public MkdirStep(StepConstraint constraint, String dirName, UpgradeTransformStep.FileResolver fileResolver) {
        super(constraint);
        this.mDirName = dirName;
        this.mFileResolver = fileResolver == null ? UpgradeTransformStep.FileResolver.ApplicationHome : fileResolver;
    }

    public ROXMessage getStepDescription() {
        return new ROXMessage("node.upgrade.app.MKDIR_STEP", this.mDirName);
    }
}

