/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.node;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeContext;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeStep;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeStepFailureException;
import com.raplix.rolloutexpress.migrate.node.StepConstraint;
import com.raplix.util.Util;
import com.raplix.util.executor.Exec;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public abstract class ExecCommandUpgradeStep
extends NodeUpgradeStep {
    private long mTimeout;

    public void executeStep(NodeUpgradeContext ctx) throws NodeUpgradeStepFailureException {
        Object[] cmdArray = this.getCmdArray(ctx);
        String command = Util.getStringFromArray(cmdArray, " ");
        ctx.logMessage(new ROXMessage("node.upgrade.app.EXEC_START", command));
        try {
            long streamTimeout = this.mTimeout == -1L ? -1L : -3L;
            Exec exec = new Exec(this.createProcess(ctx), new ByteArrayInputStream(new byte[0]), System.out, System.err, false, this.mTimeout, streamTimeout);
            if (exec.isTimedOut()) {
                throw new NodeUpgradeStepFailureException(new ROXMessage(exec.getExecutionThread().isTimedOut() ? "node.upgrade.app.EXEC_TIMEOUT" : "node.upgrade.app.EXEC_STREAM_TIMEOUT", command, String.valueOf(this.mTimeout / 1000L)));
            }
            int exitCode = exec.getExitCode();
            this.processExitCode(exitCode, command);
            ctx.logMessage(new ROXMessage("node.upgrade.app.EXEC_END", command, String.valueOf(exitCode)));
        }
        catch (InterruptedException e) {
            throw new NodeUpgradeStepFailureException(new ROXMessage("node.upgrade.app.EXEC_FAIL", command), (Throwable)e);
        }
        catch (IOException e) {
            throw new NodeUpgradeStepFailureException(new ROXMessage("node.upgrade.app.EXEC_FAIL", command), (Throwable)e);
        }
    }

    protected Process createProcess(NodeUpgradeContext ctx) throws IOException {
        return Runtime.getRuntime().exec(this.getCmdArray(ctx), this.getEnvVars(ctx), ctx.getApplicationHomeDir());
    }

    protected void processExitCode(int inExitCode, String commandString) throws NodeUpgradeStepFailureException {
        if (inExitCode != 0) {
            throw new NodeUpgradeStepFailureException(new ROXMessage("node.upgrade.app.EXEC_EXIT_FAIL", commandString, String.valueOf(inExitCode)));
        }
    }

    protected abstract String[] getCmdArray(NodeUpgradeContext var1);

    protected String[] getEnvVars(NodeUpgradeContext ctx) {
        return null;
    }

    public ExecCommandUpgradeStep(StepConstraint inConstraint, long inTimeout) {
        super(inConstraint);
        this.mTimeout = inTimeout;
    }

    public ExecCommandUpgradeStep(StepConstraint inConstraint) {
        this(inConstraint, -1L);
    }

    public ROXMessage getStepDescription() {
        return new ROXMessage("node.upgrade.app.EXEC_STEP");
    }
}

