/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.node;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeContext;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeStep;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeStepFailureException;
import com.raplix.rolloutexpress.migrate.node.StepConstraint;
import com.raplix.rolloutexpress.migrate.node.UpgradeTransformStep;
import com.raplix.util.file.CopyUtil;
import java.io.File;
import java.io.IOException;

public class CreateFileStep
extends NodeUpgradeStep {
    private String mFileName;
    private UpgradeTransformStep.FileResolver mFileResolver;
    private String mContent;
    private ConcatType mConcatType;
    private TextGenerator mTextGenerator;

    public void executeStep(NodeUpgradeContext ctx) throws NodeUpgradeStepFailureException {
        File file = this.getTargetFile(ctx);
        if (this.mTextGenerator != null) {
            this.mContent = this.mTextGenerator.generateText(ctx);
        }
        ctx.logMessage(new ROXMessage("node.upgrade.app.CREATE_FILE_START", file.getAbsolutePath()));
        try {
            String content;
            if (this.mConcatType == ConcatType.APPEND) {
                char[] text = CopyUtil.readText(file.getAbsolutePath());
                String existingText = new String(text);
                content = existingText + this.mContent;
            } else if (this.mConcatType == ConcatType.PREPEND) {
                char[] text = CopyUtil.readText(file.getAbsolutePath());
                String existingText = new String(text);
                content = this.mContent + existingText;
            } else {
                content = this.mContent;
            }
            CopyUtil.writeText(content.toCharArray(), file.getAbsolutePath());
            ctx.logMessage(new ROXMessage("node.upgrade.app.CREATE_FILE_END", file.getAbsolutePath()));
        }
        catch (IOException ioe) {
            ctx.logMessage(new ROXMessage("node.upgrade.app.CREATE_FILE_FAIL", file.getAbsolutePath()));
            throw new NodeUpgradeStepFailureException(ioe);
        }
    }

    protected File getTargetFile(NodeUpgradeContext ctx) {
        return this.mFileResolver.resolveFile(ctx, this.mFileName);
    }

    public CreateFileStep(StepConstraint constraint, String fileName, String fileContents, ConcatType type) {
        this(constraint, fileName, fileContents, type, null);
    }

    public CreateFileStep(StepConstraint constraint, String fileName, String fileContents, ConcatType type, UpgradeTransformStep.FileResolver fileResolver) {
        super(constraint);
        this.mFileName = fileName;
        this.mContent = fileContents;
        this.mFileResolver = fileResolver == null ? UpgradeTransformStep.FileResolver.ApplicationHome : fileResolver;
        this.mConcatType = type;
    }

    public CreateFileStep(StepConstraint constraint, String fileName, TextGenerator fileContents, ConcatType type, UpgradeTransformStep.FileResolver fileResolver) {
        super(constraint);
        this.mFileName = fileName;
        this.mTextGenerator = fileContents;
        this.mFileResolver = fileResolver == null ? UpgradeTransformStep.FileResolver.ApplicationHome : fileResolver;
        this.mConcatType = type;
    }

    public ROXMessage getStepDescription() {
        return new ROXMessage("node.upgrade.app.CREATE_FILE_STEP", this.mFileName);
    }

    public static interface TextGenerator {
        public String generateText(NodeUpgradeContext var1);
    }

    public static class ConcatType {
        public static final ConcatType PREPEND = new ConcatType();
        public static final ConcatType APPEND = new ConcatType();
        public static final ConcatType OVERWRITE = new ConcatType();

        private ConcatType() {
        }
    }
}

