/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.node;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeContext;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeStepFailureException;
import com.raplix.rolloutexpress.migrate.node.StepConstraint;
import com.raplix.rolloutexpress.migrate.node.UpgradeTransformStep;
import com.raplix.util.file.CopyUtil;
import java.io.File;
import java.io.IOException;

public class CopyFileStep
extends UpgradeTransformStep {
    private boolean mCreateDestinationDir;

    public CopyFileStep(StepConstraint inConstraint, String inSourceFileName, String inDestinationFileName) {
        this(inConstraint, inSourceFileName, inDestinationFileName, false);
    }

    public CopyFileStep(StepConstraint inConstraint, String inSourceFileName, String inDestinationFileName, boolean inCreateDestinationDir) {
        super(inConstraint, inSourceFileName, inDestinationFileName);
        this.mCreateDestinationDir = inCreateDestinationDir;
    }

    public CopyFileStep(StepConstraint inConstraint, String inSourceFileName, String inDestinationFileName, UpgradeTransformStep.FileResolver inSourceFileResolver, UpgradeTransformStep.FileResolver inDestinationFileResolver) {
        this(inConstraint, inSourceFileName, inDestinationFileName, inSourceFileResolver, inDestinationFileResolver, false);
    }

    public CopyFileStep(StepConstraint inConstraint, String inSourceFileName, String inDestinationFileName, UpgradeTransformStep.FileResolver inSourceFileResolver, UpgradeTransformStep.FileResolver inDestinationFileResolver, boolean inCreateDestinationDir) {
        super(inConstraint, inSourceFileName, inDestinationFileName, inSourceFileResolver, inDestinationFileResolver);
        this.mCreateDestinationDir = inCreateDestinationDir;
    }

    public void executeStep(NodeUpgradeContext ctx) throws NodeUpgradeStepFailureException {
        String sourceFile = this.getSourceFile(ctx).getAbsolutePath();
        File destination = this.getDestinationFile(ctx);
        if (this.mCreateDestinationDir) {
            destination.getParentFile().mkdirs();
        }
        String destinationFile = destination.getAbsolutePath();
        ctx.logMessage(new ROXMessage("node.upgrade.app.COPY_FILE_START", sourceFile, destinationFile));
        try {
            CopyUtil.copyBinary(sourceFile, destinationFile);
            ctx.logMessage(new ROXMessage("node.upgrade.app.COPY_FILE_END", sourceFile, destinationFile));
        }
        catch (IOException e) {
            throw new NodeUpgradeStepFailureException(new ROXMessage("node.upgrade.app.COPY_FILE_FAIL", sourceFile, destinationFile), (Throwable)e);
        }
    }

    public ROXMessage getStepDescription() {
        return new ROXMessage("node.upgrade.app.COPY_FILE_STEP", this.getSourceFileName(), this.getDestinationFileName());
    }
}

