/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.node;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.migrate.node.IncludePlatformStepConstraint;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeContext;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeStep;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeStepFailureException;
import com.raplix.rolloutexpress.migrate.node.StepConstraint;
import com.raplix.rolloutexpress.migrate.node.UpgradeTransformStep;
import com.raplix.util.file.RecursiveChmod;
import java.io.File;

public class ChmodFileStep
extends NodeUpgradeStep {
    private static final StepConstraint DEFAULT_CONSTRAINT = new IncludePlatformStepConstraint().addUnix();
    private String mFileName;
    private long mMode;
    private boolean mRecursive;
    private UpgradeTransformStep.FileResolver mFileResolver;

    public void executeStep(NodeUpgradeContext ctx) throws NodeUpgradeStepFailureException {
        File file = this.getChmodFile(ctx);
        String fileName = file.getAbsolutePath();
        ctx.logMessage(new ROXMessage("node.upgrade.app.CHMOD_FILE_START", this.getDisplayArgs(fileName)));
        try {
            RecursiveChmod.change(fileName, this.mMode, this.mRecursive, true);
        }
        catch (IllegalArgumentException e) {
            throw new NodeUpgradeStepFailureException(new ROXMessage("node.upgrade.app.CHMOD_FILE_FAIL", this.getDisplayArgs(fileName)), (Throwable)e);
        }
        ctx.logMessage(new ROXMessage("node.upgrade.app.CHMOD_FILE_END", this.getDisplayArgs(fileName)));
    }

    protected File getChmodFile(NodeUpgradeContext ctx) {
        return this.mFileResolver.resolveFile(ctx, this.mFileName);
    }

    public ChmodFileStep(String fileName, long mode, boolean recursive) {
        this(DEFAULT_CONSTRAINT, fileName, mode, recursive, null);
    }

    public ChmodFileStep(StepConstraint constraint, String fileName, long mode, boolean recursive, UpgradeTransformStep.FileResolver fileResolver) {
        super(constraint);
        this.mFileName = fileName;
        this.mMode = mode;
        this.mRecursive = recursive;
        this.mFileResolver = fileResolver == null ? UpgradeTransformStep.FileResolver.ApplicationHome : fileResolver;
    }

    public ROXMessage getStepDescription() {
        return new ROXMessage("node.upgrade.app.CHMOD_FILE_STEP", this.getDisplayArgs(this.mFileName));
    }

    private Object[] getDisplayArgs(String filename) {
        return new Object[]{filename, Long.toOctalString(this.mMode), new Boolean(this.mRecursive)};
    }
}

