/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m51to52;

import com.raplix.rolloutexpress.migrate.node.ChmodFileStep;
import com.raplix.rolloutexpress.migrate.node.CopyFileStep;
import com.raplix.rolloutexpress.migrate.node.ExecCommandUpgradeStep;
import com.raplix.rolloutexpress.migrate.node.IncludePlatformStepConstraint;
import com.raplix.rolloutexpress.migrate.node.LDStepConstraint;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeApp;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeContext;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeStep;
import com.raplix.rolloutexpress.migrate.node.Perl5TransformFileStep;
import com.raplix.rolloutexpress.migrate.node.RAStepConstraint;
import com.raplix.rolloutexpress.migrate.node.StepConstraint;
import com.raplix.rolloutexpress.migrate.node.StepConstraintBuilder;
import com.raplix.rolloutexpress.migrate.node.UpgradeTransformStep;
import com.raplix.util.file.Perl5Transform;
import com.raplix.util.platform.common.PlatformUtil;
import com.raplix.util.platform.posix.Stat;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NodeUpgrade
extends NodeUpgradeApp {
    private static final UpgradeTransformStep.FileResolver UPGRADE_TMP_RESOLVER = UpgradeTransformStep.FileResolver.UpgradeTemp;
    private static final UpgradeTransformStep.FileResolver APP_HOME_RESOLVER = UpgradeTransformStep.FileResolver.ApplicationHome;
    private static final UpgradeTransformStep.FileResolver BACKUP_RESOLVER = UpgradeTransformStep.FileResolver.UpgradeBackupBase;
    private static final UpgradeTransformStep.FileResolver PLATFORM_TMP_RESOLVER = UpgradeTransformStep.FileResolver.PlatformAndArchUpgradeTemp;
    private static final StepConstraint UNIX_RA_CONSTRAINT = new StepConstraintBuilder().add(RAStepConstraint.INSTANCE).add(new IncludePlatformStepConstraint().addUnix());
    private static final StepConstraint WIN32_CONSTRAINT = new IncludePlatformStepConstraint().addWin32();
    private static final StepConstraint WIN32_LD_CONSTRAINT = new StepConstraintBuilder().add(LDStepConstraint.INSTANCE).add(new IncludePlatformStepConstraint().addWin32());
    private static final StepConstraint WIN32_RA_CONSTRAINT = new StepConstraintBuilder().add(RAStepConstraint.INSTANCE).add(new IncludePlatformStepConstraint().addWin32());
    private static final String SEP = File.separator;
    private static final String RESTART_FILE = "bin" + SEP + "restart.cmd";
    private static final String EXECBKG_FILE = "bin" + SEP + "execbkg";
    private static final String EXECUSER_FILE = "bin" + SEP + "execuser";
    private static final String OLD_VERSION_NAME = "N1 Service Provisioning System 5.1";
    private static final String NEW_VERSION_NAME = "N1 Service Provisioning System 5.2";

    public static void main(String[] args) {
        NodeUpgrade upgradeApp = new NodeUpgrade();
        try {
            upgradeApp.run();
        }
        catch (Exception e) {
            upgradeApp.logError(e);
            upgradeApp.exitFailed();
        }
    }

    public NodeUpgradeStep[] getUpgradeSteps() {
        ArrayList stepList = new ArrayList();
        stepList.addAll(this.getBackupSteps());
        stepList.addAll(this.getUnixUtilSteps());
        stepList.addAll(this.getNameAndVersionUpdateSteps());
        stepList.addAll(this.getExecCommandUpgradeSteps());
        return stepList.toArray(new NodeUpgradeStep[0]);
    }

    private List getBackupSteps() {
        ArrayList<CopyFileStep> stepList = new ArrayList<CopyFileStep>();
        stepList.add(new CopyFileStep(WIN32_CONSTRAINT, RESTART_FILE, RESTART_FILE, APP_HOME_RESOLVER, BACKUP_RESOLVER, true));
        stepList.add(new CopyFileStep(UNIX_RA_CONSTRAINT, EXECBKG_FILE, EXECBKG_FILE, APP_HOME_RESOLVER, BACKUP_RESOLVER, true));
        stepList.add(new CopyFileStep(UNIX_RA_CONSTRAINT, EXECUSER_FILE, EXECUSER_FILE, APP_HOME_RESOLVER, BACKUP_RESOLVER, true));
        return stepList;
    }

    private List getUnixUtilSteps() {
        ArrayList<NodeUpgradeStep> stepList = new ArrayList<NodeUpgradeStep>();
        stepList.add(new CopyFileStep(UNIX_RA_CONSTRAINT, "execbkg", EXECBKG_FILE, PLATFORM_TMP_RESOLVER, APP_HOME_RESOLVER, true));
        stepList.add(new CopyFileStep(UNIX_RA_CONSTRAINT, "execuser", EXECUSER_FILE, PLATFORM_TMP_RESOLVER, APP_HOME_RESOLVER, true));
        if (PlatformUtil.isUnix()) {
            long mode = Stat.RWXU | Stat.RGRP | Stat.XGRP | Stat.ROTH | Stat.XOTH;
            stepList.add(new ChmodFileStep(EXECBKG_FILE, mode, true));
            stepList.add(new ChmodFileStep(EXECUSER_FILE, mode, true));
        }
        return stepList;
    }

    private List getExecCommandUpgradeSteps() {
        return Arrays.asList(new VBScriptExecCommandStep(WIN32_RA_CONSTRAINT, -1L, "-ra"), new VBScriptExecCommandStep(WIN32_LD_CONSTRAINT, -1L, "-ld"));
    }

    private List getNameAndVersionUpdateSteps() {
        ArrayList<Perl5TransformFileStep> stepList = new ArrayList<Perl5TransformFileStep>();
        Perl5Transform.Sub n1restartSub = new Perl5Transform.Sub(OLD_VERSION_NAME, NEW_VERSION_NAME);
        stepList.add(new Perl5TransformFileStep(WIN32_CONSTRAINT, new Perl5Transform.Sub[]{n1restartSub}, RESTART_FILE, RESTART_FILE, BACKUP_RESOLVER, APP_HOME_RESOLVER));
        return stepList;
    }

    private static class VBScriptExecCommandStep
    extends ExecCommandUpgradeStep {
        private String mTarget;

        public VBScriptExecCommandStep(StepConstraint constraint, long timeout, String target) {
            super(constraint, timeout);
            this.mTarget = target;
        }

        protected String[] getCmdArray(NodeUpgradeContext ctx) {
            return new String[]{"cscript", UPGRADE_TMP_RESOLVER.resolveFile(ctx, "migrate.vbs").getPath(), this.mTarget};
        }
    }
}

