/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m50to51;

import com.raplix.rolloutexpress.config.GeneratedVariableSettings;
import com.raplix.rolloutexpress.config.PersistentVariableSettingsTable;
import com.raplix.rolloutexpress.config.VariableSettingsHolder;
import com.raplix.rolloutexpress.migrate.Migratable;
import com.raplix.rolloutexpress.migrate.TableMigrator;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.attribute.StringAttributeMap;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstalledComponentTable;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SysVarCompMigrator
extends TableMigrator {
    private static PersistentInstalledComponentTable TABLE = PersistentInstalledComponentTable.DEFAULT;
    private static final char KEY_SEP = ':';
    private static final String ROOT_EXTENDS_TYPE_NAME = "$root$";

    protected Table getTable() {
        return TABLE;
    }

    protected SelectList getSelectList() {
        return SysVarCompMigrator.sList(SysVarCompMigrator.TABLE.ID);
    }

    protected ColumnNode getOrderColumn() {
        return SysVarCompMigrator.TABLE.ID;
    }

    protected Migratable processRow(ResultSet rs) throws PersistenceManagerException, SQLException {
        final ObjectID id = SysVarCompMigrator.TABLE.ID.retrieveValue(rs);
        return new Migratable(){

            public void migrate() throws PersistenceManagerException {
                SysVarCompMigrator.this.migrate(id);
            }

            public String toString() {
                return "ID:" + id;
            }
        };
    }

    private void migrate(ObjectID id) throws PersistenceManagerException {
        try {
            PersistentInstalledComponent ic = new PersistentInstalledComponent();
            ic.setObjectID(id);
            ic.retrieve();
            ComponentID compId = ic.getComponentID();
            GeneratedVariableSettings vars = ic.getVariableSettingsID().getByIDQuery().select();
            VariableSettingsHolder newVars = new VariableSettingsHolder(vars);
            Component comp = compId.getByIDQuery().select();
            this.addVar(newVars, comp, "sys.version", comp.getVersionNumber().getAsString());
            String encodedVarStr = StringAttributeMap.arrayToSQLString(newVars.getVarSettings());
            PersistentVariableSettingsTable t = PersistentVariableSettingsTable.DEFAULT;
            SysVarCompMigrator.execute(t.update(SysVarCompMigrator.uList(SysVarCompMigrator.set(t.VarSettings, encodedVarStr)), SysVarCompMigrator.where(SysVarCompMigrator.equals(t.ID, vars.getID()))));
        }
        catch (RPCException e) {
            throw new PersistenceManagerException(e);
        }
    }

    private void addVar(VariableSettingsHolder vars, Component comp, String varName, String varValue) {
        if (comp == null) {
            return;
        }
        this.addLocalVar(vars, comp, varName, varValue);
        this.addVar(vars, comp.getExtendsType().getComponent(), varName, varValue);
    }

    private void addLocalVar(VariableSettingsHolder vars, Component comp, String varName, String varValue) {
        vars.setVarValue(this.getKeyPrefix(comp) + varName, varValue);
    }

    private String getKeyPrefix(Component comp) {
        String extendsTypeName = comp.getExtendsTypeName();
        if (extendsTypeName == null) {
            extendsTypeName = ROOT_EXTENDS_TYPE_NAME;
        }
        return extendsTypeName + ':';
    }
}

