/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m50to51;

import com.raplix.rolloutexpress.migrate.EntityMigrator;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.ObjectFilter;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.InExpr;
import com.raplix.rolloutexpress.resource.MultiRsrcInfoQuery;
import com.raplix.rolloutexpress.resource.Resource;
import com.raplix.rolloutexpress.resource.ResourceSpec;
import com.raplix.rolloutexpress.resource.ResourceSubsysImpl;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.resource.ResourceTable;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.resource.RsrcInfoOrder;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.packageformat.ResourceEntry;
import com.raplix.rolloutexpress.resource.packageformat.ResourceEntryIterator;
import com.raplix.rolloutexpress.resource.packageformat.ResourceManifest;
import com.raplix.rolloutexpress.resource.packageformat.RsrcManifest;
import com.raplix.rolloutexpress.resource.packageformat.RsrcPacker;
import com.raplix.rolloutexpress.resource.packageformat.SubnodeType;
import com.raplix.rolloutexpress.resource.repopaths.PathLogicIdx;
import com.raplix.rolloutexpress.resource.util.MiscUtils;
import com.raplix.rolloutexpress.resource.util.ResourceFileUtils;
import com.raplix.rolloutexpress.resource.util.ResourceStringUtils;
import com.raplix.rolloutexpress.resource.util.Sequence;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class ResourceMigrator
implements EntityMigrator {
    static final VersionNumber[] sZeroVersions = new VersionNumber[0];
    private ResourceSubsysImpl mRsrcCtx;
    private boolean mDeleteResources = true;
    private int mNumErrs = 0;
    private int mNumFormatted = 0;
    private static final int PAGE_SIZE = 100;
    private CompressedSizeTable mCompressedSizeTable = new CompressedSizeTable();

    public ResourceMigrator(ResourceSubsystem inResourceSubsystem) {
        this.mRsrcCtx = inResourceSubsystem.getImpl(this);
        Logger.initializeLoggingSystem();
    }

    public int migrate() throws PersistenceManagerException {
        block2: {
            this.mNumErrs = 0;
            this.mNumFormatted = 0;
            try {
                this.transform(PathLogicIdx.CLASSIC, false);
                this.transform(PathLogicIdx.CLASSIC, true);
                this.transform(PathLogicIdx.REDMOND, false);
                this.transform(PathLogicIdx.REDMOND, true);
            }
            catch (Throwable t) {
                ++this.mNumErrs;
                if (!Logger.isErrorEnabled(this)) break block2;
                Logger.error("Error transforming resources", t, this);
            }
        }
        return this.mNumErrs;
    }

    public void setDeleteResources(boolean inDeleteResources) {
        this.mDeleteResources = inDeleteResources;
    }

    public void transform(PathLogicIdx inPathLogic, boolean inCustom) throws RPCException, PersistenceManagerException {
        MultiRsrcInfoQuery mriq = this.filter(inPathLogic, inCustom);
        int totalRows = mriq.selectCount().getTotalItemCount();
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Starting transform of " + totalRows + " of type " + inPathLogic.toString(), this);
        }
        int pageNumber = 1;
        while (totalRows > 0) {
            mriq.setPageNum(pageNumber++);
            RsrcInfo[] ris = mriq.select();
            for (int x = 0; x < ris.length; ++x) {
                RsrcInfo theRsrcInfo = ris[x];
                try {
                    this.transformResource(theRsrcInfo, inPathLogic);
                    ++this.mNumFormatted;
                    continue;
                }
                catch (Throwable t) {
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error("Unable to transform resource:" + theRsrcInfo.getName(), t, this);
                    }
                    ++this.mNumErrs;
                }
            }
            totalRows -= 100;
        }
    }

    private void verifyOrder(TreeMap inSortedEntries) {
        Iterator i = inSortedEntries.keySet().iterator();
        String thePreviousEntry = (String)i.next();
        while (i.hasNext()) {
            String theCurrentEntry = (String)i.next();
            if (RsrcManifest.compare(theCurrentEntry, thePreviousEntry) < 0) {
                Logger.error("Error while verifying sorted entries, current entry:" + theCurrentEntry + ", previous entry:" + thePreviousEntry, this);
            }
            thePreviousEntry = theCurrentEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transformResource(RsrcInfo inRsrcInfo, PathLogicIdx inPathLogic) throws Exception {
        File thePreSuvaRsrcFile = Resource.getInternalRepoFile(this.mRsrcCtx, inPathLogic, inRsrcInfo.getResourceSpec(), inRsrcInfo.getVersionNumber());
        File theSuvaRsrcDir = Resource.getInternalRepoFile(inRsrcInfo.getResourceID(), this.mRsrcCtx);
        ResourceManifest resourceManifest = ResourceManifest.getFileManifest(thePreSuvaRsrcFile);
        try {
            ResourceManifestWrapper theManifestWrapper = new ResourceManifestWrapper(resourceManifest);
            this.transformManifestToSuvaRsrcDir(inRsrcInfo.getResourceSpec(), inRsrcInfo.getVersionNumber(), theManifestWrapper, theSuvaRsrcDir);
        }
        finally {
            resourceManifest.setInvalid();
        }
        if (this.mDeleteResources) {
            thePreSuvaRsrcFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transformManifestToSuvaRsrcDir(ResourceSpec inSpec, VersionNumber inVers, ManifestInterface inManifest, File inSuvaRsrcDir) throws Exception {
        TreeMap theSortedEntries = this.makeKeySortedTreeMap();
        RsrcPacker theRsrcPacker = null;
        ResourceEntryIterator rei = inManifest.getEntryIterator();
        while (rei.hasNext()) {
            ResourceEntry re = rei.next();
            String theRelPath = re.getRelPathWFwdSlashes();
            if (re.getType().equals(SubnodeType.DIRECTORY)) {
                if (!ResourceStringUtils.endsInSeparator(theRelPath)) {
                    theRelPath = theRelPath + "/";
                }
            } else {
                while (ResourceStringUtils.endsInSeparator(theRelPath)) {
                    theRelPath = theRelPath.substring(0, theRelPath.length() - 1);
                }
            }
            theSortedEntries.put(theRelPath, re);
        }
        this.verifyOrder(theSortedEntries);
        theRsrcPacker = new RsrcPacker(inSuvaRsrcDir, null);
        String theOSName = inManifest.getCheckinOSName();
        boolean wasPosix = theOSName == null || theOSName.toLowerCase().indexOf("window") == -1;
        theRsrcPacker.setOSInfo(wasPosix, theOSName);
        VersionNumber theEarliestBackRef = inVers;
        Iterator entries = theSortedEntries.entrySet().iterator();
        while (entries.hasNext()) {
            VersionNumber theBackRef;
            ResourceEntry theEntry;
            String theFormattedRelPath;
            byte[] theMD5Digest;
            long theCompressedSize;
            long theUncompressedSize;
            block14: {
                theUncompressedSize = 0L;
                theCompressedSize = 0L;
                theMD5Digest = null;
                Map.Entry theMapEntry = entries.next();
                theFormattedRelPath = (String)theMapEntry.getKey();
                theEntry = (ResourceEntry)theMapEntry.getValue();
                theBackRef = theEntry.getBackRef();
                if (theEntry.getType().equals(SubnodeType.FILE)) {
                    theUncompressedSize = theEntry.getSize();
                    if (theBackRef == null) {
                        File theFinalTmpFile;
                        FileInputStream theFinalCompressedStream;
                        InputStream theFinalEntryStream;
                        Object var26_24;
                        InputStream theEntryStream = null;
                        File theTmpFile = null;
                        FileInputStream theCompressedStream = null;
                        boolean success = false;
                        try {
                            theTmpFile = File.createTempFile("Patched_", null);
                            theEntryStream = inManifest.getInputStream(theEntry);
                            theMD5Digest = MiscUtils.compressAndGetMD5(theEntryStream, theTmpFile);
                            theCompressedSize = theTmpFile.length();
                            if (theEntry.getMD5Digest() != null && Arrays.equals(theEntry.getMD5Digest(), theMD5Digest) && Logger.isDebugEnabled(this)) {
                                Logger.debug("Non-matching md5 calculated for  resource= " + inSpec + " version= " + inVers + " entry=" + theEntry.getRelPathWFwdSlashes(), this);
                            }
                            this.mCompressedSizeTable.store(inSpec, inVers, theEntry.getRelPathWFwdSlashes(), theCompressedSize, theMD5Digest);
                            theCompressedStream = new FileInputStream(theTmpFile);
                            theRsrcPacker.packThenCloseDataStream(theCompressedStream, theCompressedSize);
                            success = true;
                            var26_24 = null;
                            theFinalEntryStream = theEntryStream;
                            theFinalCompressedStream = theCompressedStream;
                            theFinalTmpFile = theTmpFile;
                        }
                        catch (Throwable throwable) {
                            var26_24 = null;
                            theFinalEntryStream = theEntryStream;
                            theFinalCompressedStream = theCompressedStream;
                            theFinalTmpFile = theTmpFile;
                            new Sequence(success, theFinalEntryStream, theFinalCompressedStream, theFinalTmpFile){
                                private final /* synthetic */ InputStream val$theFinalEntryStream;
                                private final /* synthetic */ InputStream val$theFinalCompressedStream;
                                private final /* synthetic */ File val$theFinalTmpFile;
                                {
                                    this.val$theFinalEntryStream = val$theFinalEntryStream;
                                    this.val$theFinalCompressedStream = val$theFinalCompressedStream;
                                    this.val$theFinalTmpFile = val$theFinalTmpFile;
                                    super(x0);
                                }

                                public void populateActions() {
                                    this.addAction(new Sequence.Action(this){
                                        private final /* synthetic */ 1 this$1;
                                        {
                                            this.this$1 = this$1;
                                        }

                                        public void exec() throws IOException {
                                            if (1.access$000(this.this$1) != null) {
                                                1.access$000(this.this$1).close();
                                            }
                                        }
                                    });
                                    this.addAction(new Sequence.Action(this){
                                        private final /* synthetic */ 1 this$1;
                                        {
                                            this.this$1 = this$1;
                                        }

                                        public void exec() throws IOException {
                                            if (1.access$100(this.this$1) != null) {
                                                1.access$100(this.this$1).close();
                                            }
                                        }
                                    });
                                    this.addAction(new Sequence.Action(this){
                                        private final /* synthetic */ 1 this$1;
                                        {
                                            this.this$1 = this$1;
                                        }

                                        public void exec() throws ResourceException {
                                            if (1.access$200(this.this$1) != null) {
                                                ResourceFileUtils.deleteDirectory(1.access$200(this.this$1));
                                            }
                                        }
                                    });
                                }

                                static /* synthetic */ InputStream access$000(1 x0) {
                                    return x0.val$theFinalEntryStream;
                                }

                                static /* synthetic */ InputStream access$100(1 x0) {
                                    return x0.val$theFinalCompressedStream;
                                }

                                static /* synthetic */ File access$200(1 x0) {
                                    return x0.val$theFinalTmpFile;
                                }
                            }.exec();
                            throw throwable;
                        }
                        new /* invalid duplicate definition of identical inner class */.exec();
                        {
                            break block14;
                        }
                    }
                    if (theEarliestBackRef.isGreaterThan(theBackRef)) {
                        theEarliestBackRef = theBackRef;
                    }
                    SizeAndDigest theSAndD = this.mCompressedSizeTable.get(inSpec, theBackRef, theEntry.getRelPathWFwdSlashes(), inVers);
                    theCompressedSize = theSAndD.mCompressedSize;
                    theMD5Digest = theSAndD.mMD5Digest;
                    if (!theBackRef.equals(theSAndD.mVers)) {
                        if (theBackRef.isGreaterThan(theSAndD.mVers)) {
                            throw new Exception("Fwd-mapped version " + theSAndD.mVers + " is not higher for " + " resource= " + inSpec + " version= " + inVers + " entry=" + theEntry.getRelPathWFwdSlashes());
                        }
                        theBackRef = theSAndD.mVers;
                    }
                }
            }
            theRsrcPacker.packEntryCluster(theFormattedRelPath, theUncompressedSize, theCompressedSize, theEntry.getTime(), theEntry.getType(), theEntry.getPerms(), theEntry.getLinkTarget(), theMD5Digest, true, theBackRef);
        }
        theRsrcPacker.finish();
        this.mCompressedSizeTable.flushEarlierVersions(inSpec, theEarliestBackRef);
    }

    private MultiRsrcInfoQuery filter(final PathLogicIdx inPathLogic, boolean inCustom) {
        MultiRsrcInfoQuery mriq = MultiRsrcInfoQuery.all();
        mriq.addFilter(new ObjectFilter(){

            public void addFilterCondition(QueryContext ctx) {
                ResourceTable rt = (ResourceTable)ctx.getFirstTable();
                InExpr pathLogicIdx = ResourceTable.in((ColumnNode)rt.cPathLogicIdx(), ResourceTable.rList(new String[]{inPathLogic.toString()}));
                ctx.addAndWhereCondition(pathLogicIdx);
            }
        });
        mriq.setObjectOrder(RsrcInfoOrder.BY_VERSION_ASC);
        mriq.setPageSize(100);
        mriq.setCustomFilter(inCustom ? Boolean.TRUE : Boolean.FALSE);
        return mriq;
    }

    public int getNumTransformed() {
        return this.mNumFormatted;
    }

    public int getNumErrors() {
        return this.mNumErrs;
    }

    private TreeMap makeKeySortedTreeMap() {
        return new TreeMap(new Comparator(){

            public int compare(Object inA, Object inB) {
                return RsrcManifest.compare((String)inA, (String)inB);
            }
        });
    }

    class ResourceManifestWrapper
    implements ManifestInterface {
        private ResourceManifest mResourceManifest;

        ResourceManifestWrapper(ResourceManifest inManifest) {
            this.mResourceManifest = inManifest;
        }

        public ResourceEntryIterator getEntryIterator() throws ResourceException {
            return this.mResourceManifest.getEntryIterator();
        }

        public String getCheckinOSName() {
            return this.mResourceManifest.getCheckinOSName();
        }

        public InputStream getInputStream(ResourceEntry inEntry) throws ResourceException {
            return this.mResourceManifest.getInputStream(inEntry);
        }
    }

    public static interface ManifestInterface {
        public ResourceEntryIterator getEntryIterator() throws ResourceException;

        public String getCheckinOSName();

        public InputStream getInputStream(ResourceEntry var1) throws ResourceException;
    }

    static class CompressedSizeTable {
        private HashMap mSpecKeyHash = new HashMap();

        CompressedSizeTable() {
        }

        public void store(ResourceSpec inSpec, VersionNumber inVers, String inEntryRelPath, long inCompressedSize, byte[] inMD5Digest) throws Exception {
            VersionNumber theHighestPrevVersion;
            TreeMap<VersionNumber, HashMap<String, SizeAndDigest>> theVersionsOfASpec = (TreeMap<VersionNumber, HashMap<String, SizeAndDigest>>)this.mSpecKeyHash.get(inSpec);
            if (theVersionsOfASpec == null) {
                theVersionsOfASpec = new TreeMap<VersionNumber, HashMap<String, SizeAndDigest>>();
                this.mSpecKeyHash.put(inSpec, theVersionsOfASpec);
            }
            if (theVersionsOfASpec.size() > 0 && (theHighestPrevVersion = (VersionNumber)theVersionsOfASpec.lastKey()).isGreaterThan(inVers)) {
                throw new Exception("Non-sequential processing of versions detected " + inSpec + " " + inVers + " " + theHighestPrevVersion);
            }
            HashMap<String, SizeAndDigest> theEntriesOfAVersion = (HashMap<String, SizeAndDigest>)theVersionsOfASpec.get(inVers);
            if (theEntriesOfAVersion == null) {
                theEntriesOfAVersion = new HashMap<String, SizeAndDigest>();
                theVersionsOfASpec.put(inVers, theEntriesOfAVersion);
            }
            theEntriesOfAVersion.put(inEntryRelPath, new SizeAndDigest(inCompressedSize, inMD5Digest, inVers));
        }

        public SizeAndDigest get(ResourceSpec inSpec, VersionNumber inVers, String inEntryRelPath, VersionNumber inStopVersion) throws Exception {
            SizeAndDigest theInfo;
            TreeMap theVersionsOfASpec = (TreeMap)this.mSpecKeyHash.get(inSpec);
            if (theVersionsOfASpec == null) {
                throw new Exception("Unable to find size and digest for " + inSpec + " " + inVers + " " + inEntryRelPath);
            }
            HashMap theEntriesOfAVersion = (HashMap)theVersionsOfASpec.get(inVers);
            if (theEntriesOfAVersion == null) {
                SortedMap theSortedMap = theVersionsOfASpec.subMap(inVers, inStopVersion);
                if (theSortedMap.size() == 0) {
                    throw new Exception("Unable to find fwd-moved version for " + inSpec + " " + inVers + " " + inEntryRelPath);
                }
                VersionNumber theNextHighestVersion = theSortedMap.firstKey();
                theEntriesOfAVersion = (HashMap)theVersionsOfASpec.get(theNextHighestVersion);
                theVersionsOfASpec.put(inVers, theEntriesOfAVersion);
            }
            if ((theInfo = (SizeAndDigest)theEntriesOfAVersion.get(inEntryRelPath)) == null) {
                throw new Exception("Unable to find info entry for " + inSpec + " " + inVers + " " + inEntryRelPath);
            }
            return theInfo;
        }

        public void flushEarlierVersions(ResourceSpec inSpec, VersionNumber inExclMaxVers) {
            TreeMap theVersionsOfASpec = (TreeMap)this.mSpecKeyHash.get(inSpec);
            if (theVersionsOfASpec == null) {
                return;
            }
            SortedMap theHeadMap = theVersionsOfASpec.headMap(inExclMaxVers);
            VersionNumber[] theVersionsToRmv = theHeadMap.keySet().toArray(sZeroVersions);
            for (int i = 0; i < theVersionsToRmv.length; ++i) {
                VersionNumber theVersToRmv = theVersionsToRmv[i];
                theVersionsOfASpec.remove(theVersToRmv);
            }
        }
    }

    static class SizeAndDigest {
        final long mCompressedSize;
        final byte[] mMD5Digest;
        final VersionNumber mVers;

        SizeAndDigest(long inCompressedSize, byte[] inMD5Digest, VersionNumber inVers) {
            this.mCompressedSize = inCompressedSize;
            this.mMD5Digest = inMD5Digest;
            this.mVers = inVers;
        }
    }
}

