/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m50to51;

import com.raplix.rolloutexpress.hierarchies.compexport.SourceInfo;
import com.raplix.rolloutexpress.migrate.Migratable;
import com.raplix.rolloutexpress.migrate.TableMigrator;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.WhereClause;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import java.sql.ResultSet;
import java.sql.SQLException;

public class PluginSIMigrator
extends TableMigrator {
    private static ComponentImplTable TABLE = ComponentImplTable.DEFAULT;
    private static final String CONFIG_TEMPLATE_VAR = "configTemplate";
    private static final String TRUE = new Boolean(true).toString();
    private static final String FALSE = new Boolean(false).toString();

    protected Table getTable() {
        return TABLE;
    }

    protected SelectList getSelectList() {
        return PluginSIMigrator.sList(PluginSIMigrator.TABLE.ID, (ScalarExp)PluginSIMigrator.TABLE.LocalResourceID);
    }

    protected ColumnNode getOrderColumn() {
        return PluginSIMigrator.TABLE.ID;
    }

    protected WhereClause getWhereClause() {
        return PluginSIMigrator.where(PluginSIMigrator.not(PluginSIMigrator.isNull(PluginSIMigrator.TABLE.PluginID)));
    }

    protected Migratable processRow(ResultSet rs) throws PersistenceManagerException, SQLException {
        final ObjectID id = PluginSIMigrator.TABLE.ID.retrieveValue(rs);
        final ResourceID localResourceID = (ResourceID)PluginSIMigrator.TABLE.LocalResourceID.retrieveValue(rs);
        return new Migratable(){

            public void migrate() throws PersistenceManagerException {
                PluginSIMigrator.this.migrate(id, localResourceID);
            }

            public String toString() {
                return "ID:" + id;
            }
        };
    }

    private void migrate(ObjectID id, ResourceID resID) throws PersistenceManagerException {
        try {
            SourceInfo si = new SourceInfo(null, null, null, null);
            if (resID != null) {
                RsrcInfo theRsrc = resID.getByIDQuery().select();
                boolean isConfig = theRsrc.getConfigurable();
                if (theRsrc.getFileTypeName().equals(theRsrc.getTypeName())) {
                    if (isConfig) {
                        si.addParameter(CONFIG_TEMPLATE_VAR, TRUE, "configuration template");
                    } else {
                        si.addParameter(CONFIG_TEMPLATE_VAR, FALSE, "not a configuration template");
                    }
                }
            }
            PluginSIMigrator.execute(PluginSIMigrator.update(TABLE, PluginSIMigrator.uList(PluginSIMigrator.set(PluginSIMigrator.TABLE.SourceInfoRawString, si.getPersistString())), PluginSIMigrator.where(PluginSIMigrator.equals(PluginSIMigrator.TABLE.ID, id))));
        }
        catch (RPCException e) {
            throw new PersistenceManagerException(e);
        }
    }
}

