/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m50to51;

import com.raplix.rolloutexpress.migrate.node.ChmodFileStep;
import com.raplix.rolloutexpress.migrate.node.CopyFileStep;
import com.raplix.rolloutexpress.migrate.node.ExecCommandUpgradeStep;
import com.raplix.rolloutexpress.migrate.node.IncludePlatformStepConstraint;
import com.raplix.rolloutexpress.migrate.node.LDStepConstraint;
import com.raplix.rolloutexpress.migrate.node.MkdirStep;
import com.raplix.rolloutexpress.migrate.node.MoveFileStep;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeApp;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeContext;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeStep;
import com.raplix.rolloutexpress.migrate.node.Perl5TransformFileStep;
import com.raplix.rolloutexpress.migrate.node.PropertiesFileTransformStep;
import com.raplix.rolloutexpress.migrate.node.RAStepConstraint;
import com.raplix.rolloutexpress.migrate.node.SourceVersionLessThanConstraint;
import com.raplix.rolloutexpress.migrate.node.StepConstraint;
import com.raplix.rolloutexpress.migrate.node.StepConstraintBuilder;
import com.raplix.rolloutexpress.migrate.node.UpgradeTransformStep;
import com.raplix.util.file.Perl5Transform;
import com.raplix.util.platform.common.PlatformUtil;
import com.raplix.util.platform.posix.Stat;
import com.raplix.util.string.PasswordEscape;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NodeUpgrade
extends NodeUpgradeApp {
    private static final UpgradeTransformStep.FileResolver UPGRADE_TMP_RESOLVER = UpgradeTransformStep.FileResolver.UpgradeTemp;
    private static final UpgradeTransformStep.FileResolver APP_HOME_RESOLVER = UpgradeTransformStep.FileResolver.ApplicationHome;
    private static final UpgradeTransformStep.FileResolver BACKUP_RESOLVER = UpgradeTransformStep.FileResolver.UpgradeBackupBase;
    private static final UpgradeTransformStep.FileResolver PLATFORM_TMP_RESOLVER = UpgradeTransformStep.FileResolver.PlatformUpgradeTemp;
    private static final StepConstraint UNIX_CONSTRAINT = new IncludePlatformStepConstraint().addUnix();
    private static final StepConstraint UNIX_LD_CONSTRAINT = new StepConstraintBuilder().add(LDStepConstraint.INSTANCE).add(new IncludePlatformStepConstraint().addUnix());
    private static final StepConstraint UNIX_RA_CONSTRAINT = new StepConstraintBuilder().add(RAStepConstraint.INSTANCE).add(new IncludePlatformStepConstraint().addUnix());
    private static final StepConstraint WIN32_CONSTRAINT = new IncludePlatformStepConstraint().addWin32();
    private static final StepConstraint WIN32_LD_CONSTRAINT = new StepConstraintBuilder().add(LDStepConstraint.INSTANCE).add(new IncludePlatformStepConstraint().addWin32());
    private static final StepConstraint WIN32_RA_CONSTRAINT = new StepConstraintBuilder().add(RAStepConstraint.INSTANCE).add(new IncludePlatformStepConstraint().addWin32());
    private static final StepConstraint WIN32_CRKEYS_RA_CONSTRAINT = new StepConstraintBuilder().add(new IncludePlatformStepConstraint().addWin32()).add(RAStepConstraint.INSTANCE).add(new OldCRKeysConstraint());
    private static final StepConstraint WIN32_CRKEYS_LD_CONSTRAINT = new StepConstraintBuilder().add(new IncludePlatformStepConstraint().addWin32()).add(LDStepConstraint.INSTANCE).add(new OldCRKeysConstraint());
    private static final StepConstraint SOURCE_VERSION_501 = new SourceVersionLessThanConstraint("5.0.1");
    private static final String SEP = File.separator;
    private static final String RESTART_FILE = "bin" + SEP + "restart.cmd";
    private static final String SHOWBUILD_FILE = "bin" + SEP + "ShowBuild.cmd";
    private static final String CONFIG_FILE = "config" + SEP + "config.properties";
    private static final String CRKEYS_FILE = "bin" + SEP + "crkeys";
    private static final String CRAGENT_FILE = "bin" + SEP + "cr_agent";
    private static final String CRLD_FILE = "bin" + SEP + "cr_ld";
    private static final String JRE_DIR = "jvm" + SEP + "jre";
    private static final String SOAP_FILE = ".." + SEP + "common" + SEP + "lib" + SEP + "soap.jar";
    private static final String SOAP_OUTPUT_DIR = "lib" + SEP + "platform" + SEP + "common" + SEP + "upgrade" + SEP + "5.0.1";
    private static final String EXECUSER_FILE = "bin" + SEP + "execuser";
    private static final String EXECBKG_FILE = "bin" + SEP + "execbkg";

    public static void main(String[] args) {
        NodeUpgrade upgradeApp = new NodeUpgrade();
        try {
            upgradeApp.run();
        }
        catch (Exception e) {
            upgradeApp.logError(e);
            upgradeApp.exitFailed();
        }
    }

    public NodeUpgradeStep[] getUpgradeSteps() {
        ArrayList stepList = new ArrayList();
        stepList.addAll(this.getBackupSteps());
        stepList.addAll(this.getUnixUtilSteps());
        stepList.addAll(this.getSoapJarSteps());
        stepList.addAll(this.getUnixCRKeysSteps());
        stepList.addAll(this.getWindowsCRKeysSteps());
        stepList.addAll(this.getCRAgentSteps());
        stepList.addAll(this.getCRDistributorSteps());
        stepList.addAll(this.getNameAndVersionUpdateSteps());
        stepList.addAll(this.getEncodedPasswordSteps());
        stepList.addAll(this.getExecCommandUpgradeSteps());
        return stepList.toArray(new NodeUpgradeStep[0]);
    }

    private List getBackupSteps() {
        ArrayList<CopyFileStep> stepList = new ArrayList<CopyFileStep>();
        stepList.add(new CopyFileStep(WIN32_CONSTRAINT, RESTART_FILE, RESTART_FILE, APP_HOME_RESOLVER, BACKUP_RESOLVER, true));
        stepList.add(new CopyFileStep(WIN32_CONSTRAINT, SHOWBUILD_FILE, SHOWBUILD_FILE, APP_HOME_RESOLVER, BACKUP_RESOLVER, true));
        stepList.add(new CopyFileStep(UNIX_CONSTRAINT, CRKEYS_FILE, CRKEYS_FILE, APP_HOME_RESOLVER, BACKUP_RESOLVER, true));
        stepList.add(new CopyFileStep(UNIX_CONSTRAINT, EXECUSER_FILE, EXECUSER_FILE, APP_HOME_RESOLVER, BACKUP_RESOLVER, true));
        stepList.add(new CopyFileStep(UNIX_CONSTRAINT, EXECBKG_FILE, EXECBKG_FILE, APP_HOME_RESOLVER, BACKUP_RESOLVER, true));
        stepList.add(new CopyFileStep(UNIX_RA_CONSTRAINT, CRAGENT_FILE, CRAGENT_FILE, APP_HOME_RESOLVER, BACKUP_RESOLVER, true));
        stepList.add(new CopyFileStep(UNIX_LD_CONSTRAINT, CRLD_FILE, CRLD_FILE, APP_HOME_RESOLVER, BACKUP_RESOLVER, true));
        stepList.add(new CopyFileStep(null, CONFIG_FILE, CONFIG_FILE, APP_HOME_RESOLVER, BACKUP_RESOLVER, true));
        stepList.add(new CopyFileStep(WIN32_CRKEYS_RA_CONSTRAINT, CRKEYS_FILE + ".cmd", CRKEYS_FILE + ".cmd", APP_HOME_RESOLVER, BACKUP_RESOLVER, true));
        stepList.add(new CopyFileStep(WIN32_CRKEYS_LD_CONSTRAINT, CRKEYS_FILE + ".cmd", CRKEYS_FILE + ".cmd", APP_HOME_RESOLVER, BACKUP_RESOLVER, true));
        return stepList;
    }

    private List getSoapJarSteps() {
        ArrayList<NodeUpgradeStep> stepList = new ArrayList<NodeUpgradeStep>();
        stepList.add(new MkdirStep(SOURCE_VERSION_501, SOAP_OUTPUT_DIR));
        stepList.add(new CopyFileStep(SOURCE_VERSION_501, SOAP_FILE, SOAP_OUTPUT_DIR + SEP + "soap.jar", APP_HOME_RESOLVER, APP_HOME_RESOLVER, true));
        stepList.add(new MoveFileStep(SOURCE_VERSION_501, "soap-rpc.jar", SOAP_OUTPUT_DIR + SEP + "soap-rpc.jar"));
        return stepList;
    }

    private List getWindowsCRKeysSteps() {
        return Arrays.asList(new CRKeysExecCommand(WIN32_CRKEYS_RA_CONSTRAINT, -1L, true), new CRKeysExecCommand(WIN32_CRKEYS_LD_CONSTRAINT, -1L, false));
    }

    private List getUnixCRKeysSteps() {
        ArrayList<Perl5TransformFileStep> stepList = new ArrayList<Perl5TransformFileStep>();
        String home = this.getApplicationHomeDir().getParent();
        String appHome = this.getApplicationHomeDir().getPath();
        String jreHome = new File(appHome, JRE_DIR).getPath();
        String crUser = System.getProperty("user.name");
        Perl5Transform.Sub homeSub = new Perl5Transform.Sub("^CR_HOME=.*", "CR_HOME=" + home);
        Perl5Transform.Sub appHomeSub = new Perl5Transform.Sub("^JRE_HOME=.*", "JRE_HOME=" + jreHome);
        Perl5Transform.Sub jreHomeSub = new Perl5Transform.Sub("^CR_APP_HOME=.*", "CR_APP_HOME=" + appHome);
        Perl5Transform.Sub crUserSub = new Perl5Transform.Sub("^CR_USER=.*", "CR_USER=" + crUser);
        stepList.add(new Perl5TransformFileStep(UNIX_CONSTRAINT, new Perl5Transform.Sub[]{homeSub, appHomeSub, jreHomeSub, crUserSub}, "crkeys", CRKEYS_FILE, UPGRADE_TMP_RESOLVER, APP_HOME_RESOLVER));
        return stepList;
    }

    private List getCRAgentSteps() {
        ArrayList<Perl5TransformFileStep> stepList = new ArrayList<Perl5TransformFileStep>();
        String home = this.getApplicationHomeDir().getParent();
        String appHome = this.getApplicationHomeDir().getPath();
        String jreHome = new File(appHome, JRE_DIR).getPath();
        Perl5Transform.Sub homeSub = new Perl5Transform.Sub("^CR_HOME=.*", "CR_HOME=" + home);
        Perl5Transform.Sub appHomeSub = new Perl5Transform.Sub("^JRE_HOME=.*", "JRE_HOME=" + jreHome);
        Perl5Transform.Sub jreHomeSub = new Perl5Transform.Sub("^CR_AGENT_HOME=.*", "CR_AGENT_HOME=" + appHome);
        stepList.add(new Perl5TransformFileStep(UNIX_RA_CONSTRAINT, new Perl5Transform.Sub[]{homeSub, appHomeSub, jreHomeSub}, "cr_agent", CRAGENT_FILE, UPGRADE_TMP_RESOLVER, APP_HOME_RESOLVER));
        return stepList;
    }

    private List getCRDistributorSteps() {
        ArrayList<Perl5TransformFileStep> stepList = new ArrayList<Perl5TransformFileStep>();
        String home = this.getApplicationHomeDir().getParent();
        String appHome = this.getApplicationHomeDir().getPath();
        String jreHome = new File(appHome, JRE_DIR).getPath();
        String crUser = System.getProperty("user.name");
        Perl5Transform.Sub homeSub = new Perl5Transform.Sub("^CR_HOME=.*", "CR_HOME=" + home);
        Perl5Transform.Sub appHomeSub = new Perl5Transform.Sub("^JRE_HOME=.*", "JRE_HOME=" + jreHome);
        Perl5Transform.Sub jreHomeSub = new Perl5Transform.Sub("^CR_LD_HOME=.*", "CR_LD_HOME=" + appHome);
        Perl5Transform.Sub crUserSub = new Perl5Transform.Sub("^CRUSER=.*", "CRUSER=" + crUser);
        stepList.add(new Perl5TransformFileStep(UNIX_LD_CONSTRAINT, new Perl5Transform.Sub[]{homeSub, appHomeSub, jreHomeSub, crUserSub}, "cr_ld", CRLD_FILE, UPGRADE_TMP_RESOLVER, APP_HOME_RESOLVER));
        return stepList;
    }

    private List getUnixUtilSteps() {
        ArrayList<NodeUpgradeStep> stepList = new ArrayList<NodeUpgradeStep>();
        stepList.add(new CopyFileStep(UNIX_CONSTRAINT, "execuser", EXECUSER_FILE, PLATFORM_TMP_RESOLVER, APP_HOME_RESOLVER, true));
        stepList.add(new CopyFileStep(UNIX_CONSTRAINT, "execbkg", EXECBKG_FILE, PLATFORM_TMP_RESOLVER, APP_HOME_RESOLVER, true));
        if (PlatformUtil.isUnix()) {
            long mode = Stat.RWXU | Stat.RGRP | Stat.XGRP | Stat.ROTH | Stat.XOTH;
            stepList.add(new ChmodFileStep(EXECUSER_FILE, mode, true));
            stepList.add(new ChmodFileStep(EXECBKG_FILE, mode, true));
        }
        return stepList;
    }

    private List getEncodedPasswordSteps() {
        ArrayList<PropertiesFileTransformStep> stepList = new ArrayList<PropertiesFileTransformStep>();
        stepList.add(new PropertiesFileTransformStep(null, "net.ssl.key.store.pass", new EncodedPasswordTransform(), CONFIG_FILE, CONFIG_FILE, BACKUP_RESOLVER, APP_HOME_RESOLVER));
        return stepList;
    }

    private List getExecCommandUpgradeSteps() {
        return Arrays.asList(new VBScriptExecCommandStep(WIN32_RA_CONSTRAINT, -1L, "-ra"), new VBScriptExecCommandStep(WIN32_LD_CONSTRAINT, -1L, "-ld"));
    }

    private List getNameAndVersionUpdateSteps() {
        ArrayList<Perl5TransformFileStep> stepList = new ArrayList<Perl5TransformFileStep>();
        Perl5Transform.Sub n1SPSSub = new Perl5Transform.Sub("echo N1 Grid Service Provisioning System", "echo N1 Service Provisioning System");
        Perl5Transform.Sub n1restartSub = new Perl5Transform.Sub("N1 Grid Service Provisioning System 5[.]{0,1}0", "N1 Service Provisioning System 5.1");
        stepList.add(new Perl5TransformFileStep(WIN32_CONSTRAINT, new Perl5Transform.Sub[]{n1SPSSub}, SHOWBUILD_FILE, SHOWBUILD_FILE, BACKUP_RESOLVER, APP_HOME_RESOLVER));
        stepList.add(new Perl5TransformFileStep(WIN32_CONSTRAINT, new Perl5Transform.Sub[]{n1restartSub}, RESTART_FILE, RESTART_FILE, BACKUP_RESOLVER, APP_HOME_RESOLVER));
        return stepList;
    }

    private static int countLines(File file) throws Exception {
        LineNumberReader in = new LineNumberReader(new FileReader(file));
        while (in.readLine() != null) {
        }
        in.close();
        return in.getLineNumber();
    }

    private static class OldCRKeysConstraint
    implements StepConstraint {
        private OldCRKeysConstraint() {
        }

        public boolean shouldRunStep(NodeUpgradeContext ctx) {
            File crkeys = new File(new File(ctx.getApplicationHomeDir(), "bin"), "crkeys.cmd");
            try {
                return 14 == NodeUpgrade.countLines(crkeys);
            }
            catch (Exception e) {
                ctx.logError(e);
                return false;
            }
        }
    }

    private static class VBScriptExecCommandStep
    extends ExecCommandUpgradeStep {
        private String mTarget;

        public VBScriptExecCommandStep(StepConstraint constraint, long timeout, String target) {
            super(constraint, timeout);
            this.mTarget = target;
        }

        protected String[] getCmdArray(NodeUpgradeContext ctx) {
            return new String[]{"cscript", UPGRADE_TMP_RESOLVER.resolveFile(ctx, "migrate.vbs").getPath(), this.mTarget};
        }
    }

    private static class CRKeysExecCommand
    extends ExecCommandUpgradeStep {
        private boolean mIsRA;

        public CRKeysExecCommand(StepConstraint constraint, long timeout, boolean isRA) {
            super(constraint, timeout);
            this.mIsRA = isRA;
        }

        protected String[] getCmdArray(NodeUpgradeContext ctx) {
            String crHome = ctx.getApplicationHomeDir().getParent();
            if (crHome.lastIndexOf(File.separatorChar) != crHome.length() - 1) {
                crHome = crHome + File.separator;
            }
            String appName = this.mIsRA ? "agent" : "ld";
            String serviceName = this.mIsRA ? "cragent" : "crdistributor";
            return new String[]{"cscript", UPGRADE_TMP_RESOLVER.resolveFile(ctx, "CreateCRKeys.vbs").getPath(), appName, crHome, serviceName};
        }
    }

    private static class EncodedPasswordTransform
    implements PropertiesFileTransformStep.Transform {
        private EncodedPasswordTransform() {
        }

        public String transform(String value) throws IOException {
            return PasswordEscape.encodePassword(value);
        }
    }
}

