/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m50to51;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.executor.target.TargetImplTable;
import com.raplix.rolloutexpress.migrate.Migratable;
import com.raplix.rolloutexpress.migrate.TableMigrator;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.TableList;
import com.raplix.rolloutexpress.persist.query.builder.WhereClause;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostImplTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MachineInfo;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstalledComponentTable;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstalledResourceTable;
import com.raplix.util.logger.Logger;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class InstRsrcMigrator
extends TableMigrator {
    private static final PersistentInstalledResourceTable INST_RSRC_T = new PersistentInstalledResourceTable("irT");
    private static final PersistentInstalledComponentTable INST_COMP_T = new PersistentInstalledComponentTable("icT");
    private static final TargetImplTable TARGET_T = new TargetImplTable("tT");
    private static final HostImplTable HOST_T = new HostImplTable("hT");
    private MachineInfo mDefaultMachineInfo;
    private HashMap mMachineInfoMap = new HashMap();

    protected Table getTable() {
        return INST_RSRC_T;
    }

    protected TableList getTableList() {
        TableList result = InstRsrcMigrator.tList(this.getTable(), INST_COMP_T, TARGET_T);
        result.add(HOST_T);
        return result;
    }

    protected SelectList getSelectList() {
        return InstRsrcMigrator.sList(InstRsrcMigrator.INST_RSRC_T.ID, InstRsrcMigrator.INST_RSRC_T.InstallPath, InstRsrcMigrator.HOST_T.ID);
    }

    protected ColumnNode getOrderColumn() {
        return InstRsrcMigrator.INST_RSRC_T.ID;
    }

    protected WhereClause getWhereClause() {
        return InstRsrcMigrator.where(InstRsrcMigrator.and(InstRsrcMigrator.equals((ColumnNode)InstRsrcMigrator.INST_RSRC_T.InstalledComponentID, InstRsrcMigrator.INST_COMP_T.ID), InstRsrcMigrator.and(InstRsrcMigrator.equals((ColumnNode)InstRsrcMigrator.INST_COMP_T.TargetID, InstRsrcMigrator.TARGET_T.ID), InstRsrcMigrator.equals((ColumnNode)InstRsrcMigrator.TARGET_T.PhysicalHostID, InstRsrcMigrator.HOST_T.ID))));
    }

    protected Migratable processRow(ResultSet rs) throws PersistenceManagerException, SQLException {
        final ObjectID instRsrcID = InstRsrcMigrator.INST_RSRC_T.ID.retrieveValue(rs);
        final String installPath = InstRsrcMigrator.INST_RSRC_T.InstallPath.retrieveValue(rs);
        final HostID hostID = (HostID)InstRsrcMigrator.HOST_T.ID.retrieveValue(rs);
        return new Migratable(){

            public void migrate() throws PersistenceManagerException, IOException {
                InstRsrcMigrator.this.migrate(instRsrcID, installPath, hostID);
            }

            public String toString() {
                return "ID:" + instRsrcID;
            }
        };
    }

    private void migrate(ObjectID instRsrcID, String installPath, HostID hostID) throws PersistenceManagerException, IOException {
        try {
            installPath = this.transformPath(installPath, hostID);
        }
        catch (RPCException e) {
            throw new PersistenceManagerException(e);
        }
        PersistentInstalledResourceTable irT = PersistentInstalledResourceTable.DEFAULT;
        InstRsrcMigrator.execute(InstRsrcMigrator.update(irT, InstRsrcMigrator.uList(InstRsrcMigrator.set(irT.InstallPath, installPath)), InstRsrcMigrator.where(InstRsrcMigrator.equals(irT.ID, instRsrcID))));
    }

    private String transformPath(String installPath, HostID hostID) throws PersistenceManagerException, RPCException {
        int size;
        MachineInfo mi = this.getMachineInfo(hostID);
        char fileSeparator = mi.getRAFileSeparator().charAt(0);
        boolean isWindows = mi.getRAPlatform().isWin32();
        StringBuffer result = new StringBuffer();
        boolean lastWasSeparator = false;
        int len = installPath.length();
        for (int i = 0; i < len; ++i) {
            char ch = installPath.charAt(i);
            if (ch == fileSeparator || ch == '/') {
                if (lastWasSeparator && (!isWindows || result.length() != 1)) continue;
                result.append('/');
                lastWasSeparator = true;
                continue;
            }
            result.append(ch);
            lastWasSeparator = false;
        }
        if (lastWasSeparator && (size = result.length()) > 1) {
            if (isWindows && size == 2) {
                if (result.charAt(0) != '/') {
                    result.setLength(size - 1);
                }
            } else {
                result.setLength(size - 1);
            }
        }
        return result.toString();
    }

    private MachineInfo getDefaultMachineInfo() {
        if (this.mDefaultMachineInfo == null) {
            this.mDefaultMachineInfo = MachineInfo.createFromSystemProps(Application.getApp());
        }
        return this.mDefaultMachineInfo;
    }

    private MachineInfo getMachineInfo(HostID hostID) throws PersistenceManagerException, RPCException {
        MachineInfo result = (MachineInfo)this.mMachineInfoMap.get(hostID);
        if (result == null) {
            SummaryHost host = hostID.getByIDQuery().selectSummaryView();
            result = host.getMachineInfo();
            if (result == null || result.getOSName() == null) {
                result = this.getDefaultMachineInfo();
                if (Logger.isWarnEnabled(this)) {
                    Logger.warn("Unable to determine machine info for host '" + host.getName() + "' while migrating installed" + " resources.  The machine type of the master" + " server will be assumed (" + result.getOSName() + ").", this);
                }
            }
            this.mMachineInfoMap.put(hostID, result);
        }
        return result;
    }
}

