/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m41to50;

import com.raplix.rolloutexpress.migrate.TransformMigrator;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.WhereClause;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SingleFolderQuery;
import com.raplix.util.file.Transform;

public class WindowsComponentMigrator
extends TransformMigrator {
    private static ComponentImplTable TABLE = ComponentImplTable.DEFAULT;
    private String mCompName;
    private FolderID mCompPath;

    public WindowsComponentMigrator(Transform transform, String componentName) {
        super(TABLE, new Transform[]{transform}, WindowsComponentMigrator.TABLE.XMLContent);
        this.mCompName = componentName;
    }

    public int migrate() throws PersistenceManagerException {
        try {
            this.mCompPath = SingleFolderQuery.byPath("/system/win32/").selectSummaryView().getID();
        }
        catch (RPCException e) {
            throw new PersistenceManagerException(e);
        }
        return super.migrate();
    }

    protected Table getTable() {
        return TABLE;
    }

    protected WhereClause getWhereClause() {
        return WindowsComponentMigrator.where(WindowsComponentMigrator.and(WindowsComponentMigrator.equals(WindowsComponentMigrator.TABLE.Name, this.mCompName), WindowsComponentMigrator.equals(WindowsComponentMigrator.TABLE.PathID, this.mCompPath)));
    }
}

