/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m41to50;

import com.raplix.rolloutexpress.migrate.Migratable;
import com.raplix.rolloutexpress.migrate.TableMigrator;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.WhereClause;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SingleFolderQuery;
import com.raplix.rolloutexpress.systemmodel.installdb.DependencyImplTable;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstalledComponentTable;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class WLManagedServer2ClusterMigrator
extends TableMigrator {
    private static DependencyImplTable TABLE = DependencyImplTable.DEFAULT;
    private FolderID mFolderID;

    protected Table getTable() {
        return TABLE;
    }

    protected SelectList getSelectList() {
        return WLManagedServer2ClusterMigrator.sList(WLManagedServer2ClusterMigrator.TABLE.ID, (ScalarExp)WLManagedServer2ClusterMigrator.TABLE.InstalledComponentTargeterAsString);
    }

    protected ColumnNode getOrderColumn() {
        return WLManagedServer2ClusterMigrator.TABLE.ID;
    }

    protected WhereClause getWhereClause() {
        PersistentInstalledComponentTable pict = PersistentInstalledComponentTable.DEFAULT;
        ComponentImplTable cit = ComponentImplTable.DEFAULT;
        return WLManagedServer2ClusterMigrator.where(WLManagedServer2ClusterMigrator.and(WLManagedServer2ClusterMigrator.equals(WLManagedServer2ClusterMigrator.TABLE.Name, "server2cluster"), WLManagedServer2ClusterMigrator.in((ColumnNode)WLManagedServer2ClusterMigrator.TABLE.DependeeInstalledComponentID, pict.select(WLManagedServer2ClusterMigrator.sList(pict.ID), WLManagedServer2ClusterMigrator.where(WLManagedServer2ClusterMigrator.in((ColumnNode)pict.ComponentID, cit.select(WLManagedServer2ClusterMigrator.sList(cit.ID), WLManagedServer2ClusterMigrator.where(WLManagedServer2ClusterMigrator.and(WLManagedServer2ClusterMigrator.equals(cit.Name, "WL Cluster"), WLManagedServer2ClusterMigrator.equals(cit.PathID, this.mFolderID))))))))));
    }

    protected Migratable processRow(ResultSet rs) throws PersistenceManagerException, SQLException {
        final ObjectID id = WLManagedServer2ClusterMigrator.TABLE.ID.retrieveValue(rs);
        String extendsType = "com.sun.weblogic#Target";
        String targeter = WLManagedServer2ClusterMigrator.TABLE.InstalledComponentTargeterAsString.retrieveValue(rs);
        String temp = "<targetableComponent ";
        int index = targeter.indexOf("host=");
        if (index != -1) {
            char quote = targeter.charAt(index + 5);
            int quote2Index = targeter.indexOf(quote, index + 6);
            String hostName = targeter.substring(index + 6, quote2Index);
            temp = temp + "host='" + hostName + "' />";
        } else {
            temp = temp + "/>";
        }
        final String replaceWith = temp;
        return new Migratable(){

            public void migrate() throws PersistenceManagerException, IOException {
                WLManagedServer2ClusterMigrator.this.migrate(id, replaceWith, "com.sun.weblogic#Target");
            }

            public String toString() {
                return "ID:" + id;
            }
        };
    }

    private void migrate(ObjectID id, String targeter, String extendsType) throws PersistenceManagerException, IOException {
        WLManagedServer2ClusterMigrator.execute(WLManagedServer2ClusterMigrator.update(TABLE, WLManagedServer2ClusterMigrator.uList(WLManagedServer2ClusterMigrator.set(WLManagedServer2ClusterMigrator.TABLE.InstalledComponentTargeterAsString, targeter), WLManagedServer2ClusterMigrator.set(WLManagedServer2ClusterMigrator.TABLE.DependeeDeclaredComponentExtendsTypeName, extendsType)), WLManagedServer2ClusterMigrator.where(WLManagedServer2ClusterMigrator.equals(WLManagedServer2ClusterMigrator.TABLE.ID, id))));
    }

    public int migrate() throws PersistenceManagerException {
        try {
            this.mFolderID = SingleFolderQuery.byPath("/com/sun/weblogic").select().getID();
            return super.migrate();
        }
        catch (RPCException rpce) {
            throw new PersistenceManagerException(rpce);
        }
    }
}

