/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m41to50;

import com.raplix.rolloutexpress.migrate.Migratable;
import com.raplix.rolloutexpress.migrate.TableMigrator;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.WhereClause;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SingleFolderQuery;
import com.raplix.rolloutexpress.systemmodel.installdb.DependencyImplTable;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstalledComponentTable;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class WLManagedServer2ASMigrator
extends TableMigrator {
    private static DependencyImplTable TABLE = DependencyImplTable.DEFAULT;
    private FolderID mFolderID;

    protected Table getTable() {
        return TABLE;
    }

    protected SelectList getSelectList() {
        return WLManagedServer2ASMigrator.sList(WLManagedServer2ASMigrator.TABLE.ID, (ScalarExp)WLManagedServer2ASMigrator.TABLE.InstalledComponentTargeterAsString);
    }

    protected ColumnNode getOrderColumn() {
        return WLManagedServer2ASMigrator.TABLE.ID;
    }

    protected WhereClause getWhereClause() {
        PersistentInstalledComponentTable pict = PersistentInstalledComponentTable.DEFAULT;
        ComponentImplTable cit = ComponentImplTable.DEFAULT;
        return WLManagedServer2ASMigrator.where(WLManagedServer2ASMigrator.and(WLManagedServer2ASMigrator.equals(WLManagedServer2ASMigrator.TABLE.Name, "server2adminServer"), WLManagedServer2ASMigrator.in((ColumnNode)WLManagedServer2ASMigrator.TABLE.DependeeInstalledComponentID, pict.select(WLManagedServer2ASMigrator.sList(pict.ID), WLManagedServer2ASMigrator.where(WLManagedServer2ASMigrator.in((ColumnNode)pict.ComponentID, cit.select(WLManagedServer2ASMigrator.sList(cit.ID), WLManagedServer2ASMigrator.where(WLManagedServer2ASMigrator.and(WLManagedServer2ASMigrator.or(WLManagedServer2ASMigrator.equals(cit.Name, "WL Admin Server 6.1"), WLManagedServer2ASMigrator.equals(cit.Name, "WL Admin Server 7.0")), WLManagedServer2ASMigrator.equals(cit.PathID, this.mFolderID))))))))));
    }

    protected Migratable processRow(ResultSet rs) throws PersistenceManagerException, SQLException {
        final ObjectID id = WLManagedServer2ASMigrator.TABLE.ID.retrieveValue(rs);
        String extendsType = "com.sun.weblogic#AdminServer";
        String targeter = WLManagedServer2ASMigrator.TABLE.InstalledComponentTargeterAsString.retrieveValue(rs);
        String temp = "<targetableComponent ";
        int index = targeter.indexOf("host=");
        if (index != -1) {
            char quote = targeter.charAt(index + 5);
            int quote2Index = targeter.indexOf(quote, index + 6);
            String hostName = targeter.substring(index + 6, quote2Index);
            temp = temp + "host='" + hostName + "' />";
        } else {
            temp = temp + "/>";
        }
        final String replaceWith = temp;
        return new Migratable(){

            public void migrate() throws PersistenceManagerException, IOException {
                WLManagedServer2ASMigrator.this.migrate(id, replaceWith, "com.sun.weblogic#AdminServer");
            }

            public String toString() {
                return "ID:" + id;
            }
        };
    }

    private void migrate(ObjectID id, String targeter, String extendsType) throws PersistenceManagerException, IOException {
        WLManagedServer2ASMigrator.execute(WLManagedServer2ASMigrator.update(TABLE, WLManagedServer2ASMigrator.uList(WLManagedServer2ASMigrator.set(WLManagedServer2ASMigrator.TABLE.InstalledComponentTargeterAsString, targeter), WLManagedServer2ASMigrator.set(WLManagedServer2ASMigrator.TABLE.DependeeDeclaredComponentExtendsTypeName, extendsType)), WLManagedServer2ASMigrator.where(WLManagedServer2ASMigrator.equals(WLManagedServer2ASMigrator.TABLE.ID, id))));
    }

    public int migrate() throws PersistenceManagerException {
        try {
            this.mFolderID = SingleFolderQuery.byPath("/com/sun/weblogic").select().getID();
            return super.migrate();
        }
        catch (RPCException rpce) {
            throw new PersistenceManagerException(rpce);
        }
    }
}

