/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m41to50;

import com.raplix.rolloutexpress.config.GeneratedVariableSettings;
import com.raplix.rolloutexpress.config.GeneratedVariableSettingsID;
import com.raplix.rolloutexpress.config.PersistentVariableSettingsTable;
import com.raplix.rolloutexpress.config.VariableSettingsHolder;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.executor.target.MultiTargetQuery;
import com.raplix.rolloutexpress.executor.target.SummaryTarget;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.executor.target.TargetImplTable;
import com.raplix.rolloutexpress.migrate.Migratable;
import com.raplix.rolloutexpress.migrate.TableMigrator;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.attribute.StringAttributeMap;
import com.raplix.rolloutexpress.persist.query.ObjectFilter;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.AndExp;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.WhereClause;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentDBException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettings;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SingleFolderQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostImplTable;
import com.raplix.rolloutexpress.systemmodel.installdb.Dependency;
import com.raplix.rolloutexpress.systemmodel.installdb.DependencyID;
import com.raplix.rolloutexpress.systemmodel.installdb.DependencyImplTable;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBException;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.MultiDependencyQuery;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstalledComponentTable;
import com.raplix.util.logger.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;

public class WLInstCompMigrator
extends TableMigrator {
    private static PersistentInstalledComponentTable TABLE = PersistentInstalledComponentTable.DEFAULT;
    private static final char KEY_SEP = ':';
    private static final String ROOT_EXTENDS_TYPE_NAME = "$root$";
    private FolderID mWLFolderID;
    private static final String ADMIN_SERVER_7_COMP_NAME = "WL Admin Server 7.0";
    private static final String ADMIN_SERVER_6_COMP_NAME = "WL Admin Server 6.1";
    private static final String MANAGED_SERVER_COMP_NAME = "WL Managed Server";
    private static final String CLUSTER_COMP_NAME = "WL Cluster";
    private static final String[] WL_COMP_NAMES = new String[]{"WL Admin Server 6.1", "WL Admin Server 7.0", "WL Managed Server", "WL Cluster"};
    private HashMap mCompIDToCompVarsSet = new HashMap();

    protected Table getTable() {
        return TABLE;
    }

    protected SelectList getSelectList() {
        return WLInstCompMigrator.sList(WLInstCompMigrator.TABLE.ID);
    }

    protected ColumnNode getOrderColumn() {
        return WLInstCompMigrator.TABLE.ID;
    }

    public int migrate() throws PersistenceManagerException {
        try {
            this.mWLFolderID = SingleFolderQuery.byPath("/system/weblogic/").selectSummaryView().getID();
        }
        catch (RPCException e) {
            throw new PersistenceManagerException(e);
        }
        return super.migrate();
    }

    protected WhereClause getWhereClause() {
        ComponentImplTable ct = ComponentImplTable.DEFAULT;
        return WLInstCompMigrator.where(WLInstCompMigrator.in((ColumnNode)WLInstCompMigrator.TABLE.ComponentID, ct.select(WLInstCompMigrator.sList(ct.ID), WLInstCompMigrator.where(WLInstCompMigrator.and(WLInstCompMigrator.equals(ct.PathID, this.mWLFolderID), WLInstCompMigrator.in((ColumnNode)ct.Name, WLInstCompMigrator.rList(WL_COMP_NAMES)))))));
    }

    protected Migratable processRow(ResultSet rs) throws PersistenceManagerException, SQLException {
        final ObjectID id = WLInstCompMigrator.TABLE.ID.retrieveValue(rs);
        return new Migratable(){

            public void migrate() throws PersistenceManagerException {
                WLInstCompMigrator.this.migrate(id);
            }

            public String toString() {
                return "ID:" + id;
            }
        };
    }

    private void migrate(ObjectID id) throws PersistenceManagerException {
        try {
            PersistentInstalledComponent ic = new PersistentInstalledComponent();
            ic.setObjectID(id);
            ic.retrieve();
            Target t = ic.getTargetID().getByIDQuery().select();
            ic.setTargetID(this.migrateTarget(t));
            ic.setInstallPath(this.migrateInstallPath(t.getCurrentHost()));
            ic.save();
            this.migrateTargeterHost(t.getCurrentHostID(), id);
            this.migrateInstallVars(ic, ic.getVariableSettingsID(), ic.getComponentID(), t.getCurrentHost());
            this.createTargetDependency(ic, t.getCurrentHost());
        }
        catch (RPCException e) {
            throw new PersistenceManagerException(e);
        }
        catch (InstallDBException e) {
            throw new PersistenceManagerException(e);
        }
    }

    private TargetID migrateTarget(Target t) throws PersistenceManagerException, RPCException {
        final HostID current = t.getCurrentHost().getParentHostID();
        boolean migrateInitial = t.getInitialHostID().equals(t.getCurrentHostID());
        final HostID initial = migrateInitial ? current : t.getInitialHostID();
        final HostID physical = t.getPhysicalHostID();
        MultiTargetQuery q = MultiTargetQuery.all();
        q.setObjectOrder(null);
        q.addFilter(new ObjectFilter(){

            protected void addFilterCondition(QueryContext ctx) {
                TargetImplTable t = (TargetImplTable)ctx.getFirstTable();
                AndExp idsMatch = QueryBuilder.and(QueryBuilder.and(TargetImplTable.equals(t.InitialHostID, initial), TargetImplTable.equals(t.CurrentHostID, current)), TargetImplTable.equals(t.PhysicalHostID, physical));
                ctx.addAndWhereCondition(idsMatch);
            }
        });
        SummaryTarget[] result = q.selectSummaryView();
        if (result.length != 1) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Unable to find appropriate target for weblogic infrastructure migration", this);
            }
            throw new IllegalStateException("no suitable target");
        }
        return result[0].getID();
    }

    private String migrateInstallPath(Host curHost) {
        return curHost.getName();
    }

    private void migrateTargeterHost(HostID hID, ObjectID icID) throws PersistenceManagerException {
        HostImplTable ht = HostImplTable.DEFAULT;
        WLInstCompMigrator.execute(ht.update(WLInstCompMigrator.uList(WLInstCompMigrator.set(ht.InstalledComponentID, icID)), WLInstCompMigrator.where(WLInstCompMigrator.equals(ht.ID, hID))));
    }

    private void migrateInstallVars(PersistentInstalledComponent ic, GeneratedVariableSettingsID varsID, ComponentID compID, Host curHost) throws PersistenceManagerException, RPCException {
        Component comp = compID.getByIDQuery().select();
        GeneratedVariableSettings vars = varsID.getByIDQuery().select();
        if (comp.getName().equals(CLUSTER_COMP_NAME)) {
            this.migrateClusterVars(ic, comp, vars, curHost);
        } else if (comp.getName().equals(MANAGED_SERVER_COMP_NAME)) {
            this.migrateManagedServerVars(ic, comp, vars, curHost);
        } else {
            this.migrateAdminServerVars(ic, comp, vars, curHost);
        }
    }

    private void migrateClusterVars(PersistentInstalledComponent ic, Component comp, GeneratedVariableSettings vars, Host curHost) throws PersistenceManagerException, RPCException {
        VariableSettingsHolder newVars = new VariableSettingsHolder(vars);
        this.addTargetVars(newVars, comp, curHost, "cluster", this.getVar(vars, comp, "clusterName"));
        this.removeVar(newVars, comp, "clusterName");
        this.resetVars(vars, newVars);
        this.createCompVarSet(ic, comp, newVars, "targetName", new String[]{"targetName"}, new String[]{""});
    }

    private void migrateManagedServerVars(PersistentInstalledComponent ic, Component comp, GeneratedVariableSettings vars, Host curHost) throws PersistenceManagerException, RPCException {
        VariableSettingsHolder newVars = new VariableSettingsHolder(vars);
        this.addTargetVars(newVars, comp, curHost, "server", this.getVar(vars, comp, "serverName"));
        this.removeVar(newVars, comp, "serverName");
        this.resetVars(vars, newVars);
        this.createCompVarSet(ic, comp, newVars, "targetName", new String[]{"adminServerHostName", "targetName", "clusterHostName", "startupScript"}, new String[]{"", "", "", ""});
    }

    private void addTargetVars(VariableSettingsHolder newVars, Component comp, Host curHost, String targetTypeVal, String targetNameVal) throws PersistenceManagerException {
        this.addVar(newVars, comp, "targetType", targetTypeVal);
        this.addVar(newVars, comp, "targetName", targetNameVal);
        this.addVar(newVars, comp, "targetRefName", curHost.getName());
        this.addVar(newVars, comp, "sys.targetRefName", curHost.getName());
        this.addVar(newVars, comp, "installPath", this.migrateInstallPath(curHost));
    }

    private void migrateAdminServerVars(PersistentInstalledComponent ic, Component comp, GeneratedVariableSettings vars, Host curHost) throws PersistenceManagerException, RPCException {
        VariableSettingsHolder newVars = new VariableSettingsHolder(vars);
        this.addVar(newVars, comp, "domainName", curHost.getVarValue("domainName"));
        this.addVar(newVars, comp, "targetRefName", curHost.getName());
        this.addVar(newVars, comp, "sys.targetRefName", curHost.getName());
        this.addVar(newVars, comp, "installPath", this.migrateInstallPath(curHost));
        this.resetVars(vars, newVars);
        this.createCompVarSet(ic, comp, newVars, "domainName", new String[]{"adminHost", "adminPort", "secureConnect", "wlHomeDir", "domainName"}, new String[]{"", "7001", "false", "", ""});
    }

    private void addVar(VariableSettingsHolder vars, Component comp, String varName, String varValue) {
        if (comp == null) {
            return;
        }
        this.addLocalVar(vars, comp, varName, varValue);
        this.addVar(vars, comp.getExtendsType().getComponent(), varName, varValue);
    }

    private void removeVar(VariableSettingsHolder vars, Component comp, String varName) {
        if (comp == null) {
            return;
        }
        this.removeLocalVar(vars, comp, varName);
        this.removeVar(vars, comp.getExtendsType().getComponent(), varName);
    }

    private void addLocalVar(VariableSettingsHolder vars, Component comp, String varName, String varValue) {
        vars.setVarValue(this.getKeyPrefix(comp) + varName, varValue);
    }

    private void removeLocalVar(VariableSettingsHolder vars, Component comp, String varName) {
        vars.removeVarValue(this.getKeyPrefix(comp) + varName);
    }

    private String getVar(VariableSettingsSource vars, Component comp, String varName) {
        return vars.getVarValue(this.getKeyPrefix(comp) + varName);
    }

    private String getVar(PersistentInstalledComponent ic, String varName) throws PersistenceManagerException, RPCException {
        GeneratedVariableSettings vars = ic.getVariableSettingsID().getByIDQuery().select();
        Component comp = ic.getComponentID().getByIDQuery().select();
        return vars.getVarValue(this.getKeyPrefix(comp) + varName);
    }

    private String getKeyPrefix(Component comp) {
        String extendsTypeName = comp.getExtendsTypeName();
        if (extendsTypeName == null) {
            extendsTypeName = ROOT_EXTENDS_TYPE_NAME;
        }
        return extendsTypeName + ':';
    }

    private void resetVars(GeneratedVariableSettings vars, VariableSettingsHolder newVars) throws PersistenceManagerException {
        String encodedVarStr = StringAttributeMap.arrayToSQLString(newVars.getVarSettings());
        PersistentVariableSettingsTable t = PersistentVariableSettingsTable.DEFAULT;
        WLInstCompMigrator.execute(t.update(WLInstCompMigrator.uList(WLInstCompMigrator.set(t.VarSettings, encodedVarStr)), WLInstCompMigrator.where(WLInstCompMigrator.equals(t.ID, vars.getID()))));
    }

    private void createCompVarSet(PersistentInstalledComponent pic, Component comp, VariableSettingsSource vars, String setNameVar, String[] varNames, String[] varDefaults) throws PersistenceManagerException, RPCException {
        InstalledComponent ic = ((InstalledComponentID)pic.getObjectID()).getByIDQuery().select();
        if (!ic.isInstalled()) {
            return;
        }
        VariableSettingsHolder newVars = new VariableSettingsHolder();
        for (int i = 0; i < varNames.length; ++i) {
            String val = this.getVar(vars, comp, varNames[i]);
            if (val.equals(varDefaults[i])) continue;
            newVars.setVarValue(varNames[i], val);
        }
        if (newVars.size() == 0) {
            return;
        }
        HashSet<VariableSettingsHolder> varsSet = (HashSet<VariableSettingsHolder>)this.mCompIDToCompVarsSet.get(comp.getID());
        if (varsSet == null) {
            varsSet = new HashSet<VariableSettingsHolder>();
            this.mCompIDToCompVarsSet.put(comp.getID(), varsSet);
        }
        if (!varsSet.add(newVars)) {
            return;
        }
        ComponentVariableSettings compVars = new ComponentVariableSettings(comp.getID());
        compVars.setName(this.getSetName(comp, this.getVar(vars, comp, setNameVar)));
        varNames = newVars.getVarNames();
        for (int i = 0; i < varNames.length; ++i) {
            compVars.setOverrideVarValue(varNames[i], newVars.getVarValue(varNames[i]));
        }
        compVars.save();
    }

    private String getSetName(Component comp, String basename) throws PersistenceManagerException, RPCException {
        int maxLen = 28;
        if (basename.length() > maxLen) {
            basename = basename.substring(0, maxLen);
        }
        try {
            ComponentVariableSettings.validateName(basename);
        }
        catch (ComponentDBException e) {
            basename = "migration";
        }
        String curName = basename;
        int i = 2;
        while (comp.getID().getVariableSettingsQuery(curName).selectExists()) {
            curName = basename + "_" + i;
            ++i;
        }
        return curName;
    }

    /*
     * WARNING - void declaration
     */
    private void createTargetDependency(PersistentInstalledComponent ic, Host curHost) throws PersistenceManagerException, RPCException {
        void var4_4;
        String templateDependencyName;
        SummaryComponent comp = ic.getComponentID().getByIDQuery().selectSummaryView();
        if (comp.getName().equals(CLUSTER_COMP_NAME)) {
            templateDependencyName = "cluster2adminServer";
        } else if (comp.getName().equals(MANAGED_SERVER_COMP_NAME)) {
            templateDependencyName = "server2adminServer";
        } else {
            return;
        }
        InstalledComponentID icID = (InstalledComponentID)ic.getObjectID();
        MultiDependencyQuery q = MultiDependencyQuery.byDependenciesCreatedBy(icID);
        q.setNameFilter((String)var4_4);
        Dependency[] deps = q.select();
        if (deps.length == 0) {
            return;
        }
        Dependency orig = deps[0];
        DependencyImplTable t = DependencyImplTable.DEFAULT;
        String adminServerHostName = this.getVar(ic, "adminServerHostName");
        String targeterStr = "<targetableComponent host='" + adminServerHostName + "'/>";
        WLInstCompMigrator.execute(t.insert(WLInstCompMigrator.cList(t.ID, t.UpdateCount, t.DependantInstalledComponentID).add(WLInstCompMigrator.cList(t.InstalledComponentTargeterAsString, t.DependeeDeclaredComponentExtendsTypeName, t.Name)).add(WLInstCompMigrator.cList(t.DependeeInstalledComponentID, (ColumnNode)t.DependantDeclaredComponentExtendsTypeName)), WLInstCompMigrator.vList(WLInstCompMigrator.v(DependencyID.generateID()), WLInstCompMigrator.v(1), WLInstCompMigrator.v(icID)).add(WLInstCompMigrator.vList(WLInstCompMigrator.v(targeterStr), WLInstCompMigrator.v("com.sun.weblogic#AdminServer"), WLInstCompMigrator.v("target2adminServer"))).add(WLInstCompMigrator.vList(WLInstCompMigrator.v(orig.getDependeeInstalledComponentID()), WLInstCompMigrator.v((String)null)))));
    }
}

