/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m41to50;

import com.raplix.rolloutexpress.migrate.TransformMigrator;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.WhereClause;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SingleFolderQuery;
import com.raplix.util.file.Transform;

public class WLComponentMigrator
extends TransformMigrator {
    private static ComponentImplTable TABLE = ComponentImplTable.DEFAULT;
    private String mCompName;
    private String mCompVersionStr;
    private int mCompVersion;
    private FolderID mCompPath;

    public WLComponentMigrator(Transform transform, String componentName, String version) {
        super(TABLE, new Transform[]{transform}, WLComponentMigrator.TABLE.XMLContent);
        this.mCompName = componentName;
        this.mCompVersionStr = version;
    }

    public int migrate() throws PersistenceManagerException {
        try {
            this.mCompPath = SingleFolderQuery.byPath("/system/weblogic/").selectSummaryView().getID();
            this.mCompVersion = new VersionNumber(this.mCompVersionStr).getSingleVersionNumber();
        }
        catch (RPCException e) {
            throw new PersistenceManagerException(e);
        }
        return super.migrate();
    }

    protected Table getTable() {
        return TABLE;
    }

    protected WhereClause getWhereClause() {
        return WLComponentMigrator.where(WLComponentMigrator.and(WLComponentMigrator.equals(WLComponentMigrator.TABLE.Name, this.mCompName), WLComponentMigrator.and(WLComponentMigrator.equals(WLComponentMigrator.TABLE.PathID, this.mCompPath), WLComponentMigrator.equals(WLComponentMigrator.TABLE.Version, this.mCompVersion))));
    }
}

