/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m41to50;

import com.raplix.rolloutexpress.migrate.Migratable;
import com.raplix.rolloutexpress.migrate.TableMigrator;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.attribute.StringAttributeMap;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.WhereClause;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettingsImplTable;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SingleFolderQuery;
import java.sql.ResultSet;
import java.sql.SQLException;

public class WLCompVarSetMigrator
extends TableMigrator {
    private static ComponentVariableSettingsImplTable TABLE = ComponentVariableSettingsImplTable.DEFAULT;
    private String mCompName;
    private int mCompVersion;
    private FolderID mCompPath;
    private String mOldVarName;

    public WLCompVarSetMigrator(String componentName, String oldVarName) {
        this.mCompName = componentName;
        this.mOldVarName = oldVarName + "=";
    }

    public int migrate() throws PersistenceManagerException {
        try {
            this.mCompPath = SingleFolderQuery.byPath("/system/weblogic/").selectSummaryView().getID();
            this.mCompVersion = new VersionNumber("1.0").getSingleVersionNumber();
        }
        catch (RPCException e) {
            throw new PersistenceManagerException(e);
        }
        return super.migrate();
    }

    protected Table getTable() {
        return TABLE;
    }

    protected SelectList getSelectList() {
        return WLCompVarSetMigrator.sList(WLCompVarSetMigrator.TABLE.ID, (ScalarExp)WLCompVarSetMigrator.TABLE.OverrideSettings);
    }

    protected ColumnNode getOrderColumn() {
        return WLCompVarSetMigrator.TABLE.ID;
    }

    protected WhereClause getWhereClause() {
        ComponentImplTable ct = ComponentImplTable.DEFAULT;
        return WLCompVarSetMigrator.where(WLCompVarSetMigrator.in((ColumnNode)WLCompVarSetMigrator.TABLE.ComponentID, ct.select(WLCompVarSetMigrator.sList(ct.ID), WLCompVarSetMigrator.where(WLCompVarSetMigrator.and(WLCompVarSetMigrator.and(WLCompVarSetMigrator.equals(ct.Name, this.mCompName), WLCompVarSetMigrator.equals(ct.PathID, this.mCompPath)), WLCompVarSetMigrator.equals(ct.Version, this.mCompVersion))))));
    }

    protected Migratable processRow(ResultSet rs) throws PersistenceManagerException, SQLException {
        final ObjectID id = WLCompVarSetMigrator.TABLE.ID.retrieveValue(rs);
        final String overrides = WLCompVarSetMigrator.TABLE.OverrideSettings.retrieveValue(rs);
        return new Migratable(){

            public void migrate() throws PersistenceManagerException {
                WLCompVarSetMigrator.this.migrate(id, overrides);
            }

            public String toString() {
                return "ID:" + id;
            }
        };
    }

    private void migrate(ObjectID id, String overrides) throws PersistenceManagerException {
        Database db = PersistenceManager.getInstance().getDefaultDatabase();
        Object[] vals = StringAttributeMap.arrayFromSQLString(db, overrides);
        for (int i = 0; i < vals.length; ++i) {
            if (!((String)vals[i]).startsWith(this.mOldVarName)) continue;
            vals[i] = "targetName=" + ((String)vals[i]).substring(this.mOldVarName.length());
        }
        overrides = StringAttributeMap.arrayToSQLString(vals);
        WLCompVarSetMigrator.execute(WLCompVarSetMigrator.update(TABLE, WLCompVarSetMigrator.uList(WLCompVarSetMigrator.set(WLCompVarSetMigrator.TABLE.OverrideSettings, overrides)), WLCompVarSetMigrator.where(WLCompVarSetMigrator.equals(WLCompVarSetMigrator.TABLE.ID, id))));
    }
}

