/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m41to50;

import com.raplix.rolloutexpress.migrate.Migratable;
import com.raplix.rolloutexpress.migrate.TableMigrator;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.WhereClause;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SingleFolderQuery;
import com.raplix.rolloutexpress.systemmodel.installdb.DependencyImplTable;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstalledComponentTable;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class WLClusterMigrator
extends TableMigrator {
    private static DependencyImplTable TABLE = DependencyImplTable.DEFAULT;
    private FolderID mFolderID;

    protected Table getTable() {
        return TABLE;
    }

    protected SelectList getSelectList() {
        return WLClusterMigrator.sList(WLClusterMigrator.TABLE.ID, (ScalarExp)WLClusterMigrator.TABLE.InstalledComponentTargeterAsString);
    }

    protected ColumnNode getOrderColumn() {
        return WLClusterMigrator.TABLE.ID;
    }

    protected WhereClause getWhereClause() {
        PersistentInstalledComponentTable pict = PersistentInstalledComponentTable.DEFAULT;
        ComponentImplTable cit = ComponentImplTable.DEFAULT;
        return WLClusterMigrator.where(WLClusterMigrator.and(WLClusterMigrator.equals(WLClusterMigrator.TABLE.Name, "cluster2adminServer"), WLClusterMigrator.in((ColumnNode)WLClusterMigrator.TABLE.DependeeInstalledComponentID, pict.select(WLClusterMigrator.sList(pict.ID), WLClusterMigrator.where(WLClusterMigrator.in((ColumnNode)pict.ComponentID, cit.select(WLClusterMigrator.sList(cit.ID), WLClusterMigrator.where(WLClusterMigrator.and(WLClusterMigrator.or(WLClusterMigrator.equals(cit.Name, "WL Admin Server 6.1"), WLClusterMigrator.equals(cit.Name, "WL Admin Server 7.0")), WLClusterMigrator.equals(cit.PathID, this.mFolderID))))))))));
    }

    protected Migratable processRow(ResultSet rs) throws PersistenceManagerException, SQLException {
        final ObjectID id = WLClusterMigrator.TABLE.ID.retrieveValue(rs);
        String extendsType = "com.sun.weblogic#AdminServer";
        return new Migratable(){

            public void migrate() throws PersistenceManagerException, IOException {
                WLClusterMigrator.this.migrate(id, "<targetableComponent/>", "com.sun.weblogic#AdminServer");
            }

            public String toString() {
                return "ID:" + id;
            }
        };
    }

    private void migrate(ObjectID id, String targeter, String extendsType) throws PersistenceManagerException, IOException {
        WLClusterMigrator.execute(WLClusterMigrator.update(TABLE, WLClusterMigrator.uList(WLClusterMigrator.set(WLClusterMigrator.TABLE.InstalledComponentTargeterAsString, targeter), WLClusterMigrator.set(WLClusterMigrator.TABLE.DependeeDeclaredComponentExtendsTypeName, extendsType)), WLClusterMigrator.where(WLClusterMigrator.equals(WLClusterMigrator.TABLE.ID, id))));
    }

    public int migrate() throws PersistenceManagerException {
        try {
            this.mFolderID = SingleFolderQuery.byPath("/com/sun/weblogic").select().getID();
            return super.migrate();
        }
        catch (RPCException rpce) {
            throw new PersistenceManagerException(rpce);
        }
    }
}

