/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m41to50;

import com.raplix.rolloutexpress.migrate.Migratable;
import com.raplix.rolloutexpress.migrate.TableMigrator;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.WhereClause;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SingleFolderQuery;
import com.raplix.rolloutexpress.systemmodel.installdb.DependencyImplTable;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstalledComponentTable;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class WLBaseCTMigrator
extends TableMigrator {
    private static DependencyImplTable TABLE = DependencyImplTable.DEFAULT;
    private FolderID mFolderID;

    protected Table getTable() {
        return TABLE;
    }

    protected SelectList getSelectList() {
        return WLBaseCTMigrator.sList(WLBaseCTMigrator.TABLE.ID, (ScalarExp)WLBaseCTMigrator.TABLE.InstalledComponentTargeterAsString);
    }

    protected ColumnNode getOrderColumn() {
        return WLBaseCTMigrator.TABLE.ID;
    }

    protected WhereClause getWhereClause() {
        PersistentInstalledComponentTable pict = PersistentInstalledComponentTable.DEFAULT;
        ComponentImplTable cit = ComponentImplTable.DEFAULT;
        return WLBaseCTMigrator.where(WLBaseCTMigrator.and(WLBaseCTMigrator.equals(WLBaseCTMigrator.TABLE.Name, "wlobj2target"), WLBaseCTMigrator.in((ColumnNode)WLBaseCTMigrator.TABLE.DependeeInstalledComponentID, pict.select(WLBaseCTMigrator.sList(pict.ID), WLBaseCTMigrator.where(WLBaseCTMigrator.in((ColumnNode)pict.ComponentID, cit.select(WLBaseCTMigrator.sList(cit.ID), WLBaseCTMigrator.where(WLBaseCTMigrator.and(WLBaseCTMigrator.or(WLBaseCTMigrator.equals(cit.Name, "WL Cluster"), WLBaseCTMigrator.equals(cit.Name, "WL Managed Server")), WLBaseCTMigrator.equals(cit.PathID, this.mFolderID))))))))));
    }

    protected Migratable processRow(ResultSet rs) throws PersistenceManagerException, SQLException {
        final ObjectID id = WLBaseCTMigrator.TABLE.ID.retrieveValue(rs);
        String extendsType = "com.sun.weblogic#Target";
        return new Migratable(){

            public void migrate() throws PersistenceManagerException, IOException {
                WLBaseCTMigrator.this.migrate(id, "<targetableComponent/>", "com.sun.weblogic#Target");
            }

            public String toString() {
                return "ID:" + id;
            }
        };
    }

    private void migrate(ObjectID id, String targeter, String extendsType) throws PersistenceManagerException, IOException {
        WLBaseCTMigrator.execute(WLBaseCTMigrator.update(TABLE, WLBaseCTMigrator.uList(WLBaseCTMigrator.set(WLBaseCTMigrator.TABLE.InstalledComponentTargeterAsString, targeter), WLBaseCTMigrator.set(WLBaseCTMigrator.TABLE.DependeeDeclaredComponentExtendsTypeName, extendsType)), WLBaseCTMigrator.where(WLBaseCTMigrator.equals(WLBaseCTMigrator.TABLE.ID, id))));
    }

    public int migrate() throws PersistenceManagerException {
        try {
            this.mFolderID = SingleFolderQuery.byPath("/com/sun/weblogic").select().getID();
            return super.migrate();
        }
        catch (RPCException rpce) {
            throw new PersistenceManagerException(rpce);
        }
    }
}

