/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m41to50;

import com.raplix.rolloutexpress.config.ConfigTemplate;
import com.raplix.rolloutexpress.config.NameMap;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.attribute.StringAttributeMap;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;

public class RenameUtil {
    private static Stack sNameMapStack = new Stack();
    private static boolean sIsGenerated;
    public static NameMap COMP_NAME_MAP;
    public static NameMap PLAN_NAME_MAP;
    private static HashMap sHostSetMap;
    private static ArrayList mParams;

    private static void setNameMap(NameMap nameMap, boolean isGenerated) {
        sNameMapStack.clear();
        RenameUtil.pushNameMap(nameMap);
        sIsGenerated = isGenerated;
    }

    private static void pushNameMap(NameMap nameMap) {
        sNameMapStack.push(nameMap);
    }

    private static NameMap popNameMap() {
        return (NameMap)sNameMapStack.pop();
    }

    public static void setNameMap(String elementName) {
        if ("component".equals(elementName)) {
            RenameUtil.setNameMap(COMP_NAME_MAP, false);
        } else if ("executionPlan".equals(elementName)) {
            RenameUtil.setNameMap(PLAN_NAME_MAP, false);
        } else if ("miniPlan".equals(elementName)) {
            RenameUtil.setNameMap(PLAN_NAME_MAP, false);
        } else if ("dependency".equals(elementName)) {
            RenameUtil.setNameMap(COMP_NAME_MAP, true);
        } else {
            throw new IllegalArgumentException(elementName);
        }
    }

    private static NameMap getNameMap() {
        return (NameMap)sNameMapStack.peek();
    }

    private static NameMap createNameMap(boolean includeSimple) {
        NameMap map = new NameMap();
        RenameUtil.addCompVar(map, "name", "sys.name", includeSimple);
        RenameUtil.addCompVar(map, "description", "sys.description", includeSimple);
        RenameUtil.addCompVar(map, "label", "sys.label", includeSimple);
        RenameUtil.addCompVar(map, "softwareVendor", "sys.softwareVendor", includeSimple);
        RenameUtil.addCompVar(map, "author", "sys.author", includeSimple);
        RenameUtil.addCompVar(map, "path", "sys.path", includeSimple);
        RenameUtil.addCompVar(map, "rsrcInstallPath", "sys.rsrcInstallPath", includeSimple);
        map.addHostVarMap("name", "sys.hostName");
        map.addHostVarMap("description", "sys.description");
        map.addHostVarMap("hostTypeName", "sys.hostType");
        map.addHostVarMap("raIP", "sys.isAddress");
        map.addHostVarMap("raPort", "sys.portNumber");
        map.addHostVarMap("raHomeDir", "sys.raHomeDir");
        map.addHostVarMap("raDataDir", "sys.raDataDir");
        map.addHostVarMap("raConfigDir", "sys.raConfigDir");
        map.addHostVarMap("raTmpDir", "sys.raTmpDir");
        map.addCompTypeMap("CR Simple Base", "system#CR Simple Base");
        map.addCompTypeMap("file", "system#file");
        map.addCompTypeMap("directory", "system#directory");
        map.addCompTypeMap("system service", "system#system service");
        map.addCompTypeMap("symbolic link", "system#symbolic link");
        map.addCompTypeMap("container", "system#container");
        map.addCompTypeMap("rpm file", "com.sun.linux#rpm file");
        map.addCompTypeMap("COM+ application", "com.sun.windows#COM+ application");
        map.addCompTypeMap("COM object", "com.sun.windows#COM object");
        map.addCompTypeMap("registry key", "com.sun.windows#registry key");
        map.addCompTypeMap("data source name", "com.sun.windows#data source name");
        map.addCompTypeMap("metabase base ct", "com.sun.windows#metabase base ct");
        map.addCompTypeMap("IIS web site or virtual directory settings", "com.sun.windows#IIS web site or virtual directory settings");
        map.addCompTypeMap("IIS global settings", "com.sun.windows#IIS global settings");
        map.addCompTypeMap("global ISAPI filter settings", "com.sun.windows#global ISAPI filter settings");
        map.addCompTypeMap("website ISAPI filter settings", "com.sun.windows#website ISAPI filter settings");
        map.addCompTypeMap("IIS application", "com.sun.windows#IIS application");
        map.addCompTypeMap("windows scripting host script", "com.sun.windows#scripting host script");
        map.addCompTypeMap("windows batch file", "com.sun.windows#batch file");
        map.addCompTypeMap("windows registry file", "com.sun.windows#registry file");
        map.addCompTypeMap("windows installer file", "com.sun.windows#installer file");
        map.addCompTypeMap("wlAdminServer", "com.sun.weblogic#AdminServer");
        map.addCompTypeMap("WebLogic Archive", "com.sun.weblogic#Archive");
        map.addCompTypeMap("WebLogic Base", "com.sun.weblogic#Base");
        map.addCompTypeMap("WebLogic Base Reg", "com.sun.weblogic#Base Reg");
        map.addCompTypeMap("WebLogic Config", "com.sun.weblogic#Config");
        map.addCompTypeMap("WebLogic EAR file", "com.sun.weblogic#EAR file");
        map.addCompTypeMap("WebLogic EJB", "com.sun.weblogic#EJB");
        map.addCompTypeMap("WebLogic EJB container", "com.sun.weblogic#EJB container");
        map.addCompTypeMap("WebLogic EJB settings", "com.sun.weblogic#EJB settings");
        map.addCompTypeMap("WebLogic JAR file", "com.sun.weblogic#JAR file");
        map.addCompTypeMap("WebLogic List", "com.sun.weblogic#List");
        map.addCompTypeMap("wlTarget", "com.sun.weblogic#Target");
        map.addCompTypeMap("WebLogic WAR file", "com.sun.weblogic#WAR file");
        map.addCompTypeMap("contained WebLogic EJB", "com.sun.weblogic#contained EJB");
        map.addCompTypeMap("contained WebLogic EJB container", "com.sun.weblogic#contained EJB container");
        map.addCompTypeMap("contained WebLogic web application", "com.sun.weblogic#contained web application");
        map.addCompTypeMap("contained WebLogic web application container", "com.sun.weblogic#contained web application container");
        map.addCompTypeMap("WebLogic enterprise application", "com.sun.weblogic#enterprise application");
        map.addCompTypeMap("WebLogic enterprise application container", "com.sun.weblogic#enterprise application container");
        map.addCompTypeMap("WebLogic enterprise application settings", "com.sun.weblogic#enterprise application settings");
        map.addCompTypeMap("WebLogic web application", "com.sun.weblogic#web application");
        map.addCompTypeMap("WebLogic web application container", "com.sun.weblogic#web application container");
        map.addCompTypeMap("WebLogic web application settings", "com.sun.weblogic#web application settings");
        map.addSystemServiceMap("core services", "system#core services");
        map.addSystemServiceMap("windows services", "com.sun.windows#services");
        map.addSystemServiceMap("COM+ application services", "com.sun.windows#COM+ application services");
        map.addSystemServiceMap("metabase services", "com.sun.windows#metabase services");
        map.addSystemServiceMap("registry key services", "com.sun.windows#registry key services");
        map.addSystemServiceMap("data source name services", "com.sun.windows#data source name services");
        map.addSystemServiceMap("weblogic ss", "com.sun.weblogic#ss");
        return map;
    }

    private static void addCompVar(NameMap map, String oldName, String newName, boolean includeSimple) {
        if (includeSimple) {
            map.addSimpleCompVarMap(oldName, newName);
        }
        map.addCompVarMap(oldName, newName);
    }

    public static String mapConfigVar(String var) {
        if (sIsGenerated) {
            return var;
        }
        return ConfigTemplate.mapNames(RenameUtil.getNameMap(), var);
    }

    public static String mapTypeName(String name) {
        return RenameUtil.getNameMap().mapCompType(name);
    }

    public static String mapCompVarName(String name) {
        return RenameUtil.getNameMap().mapSimpleCompVar(name);
    }

    public static String mapServiceName(String name) {
        return RenameUtil.getNameMap().mapSystemService(name);
    }

    private static HashMap createHostSetMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        RenameUtil.addHostSet(result, "any");
        RenameUtil.addHostSet(result, "Red Hat Linux 7.2");
        RenameUtil.addHostSet(result, "Red Hat Linux 7.3");
        RenameUtil.addHostSet(result, "Red Hat Linux 8.0");
        RenameUtil.addHostSet(result, "Red Hat Linux Adv Server 2.1");
        RenameUtil.addHostSet(result, "Red Hat Linux - any version");
        RenameUtil.addHostSet(result, "Windows 2000 Server");
        RenameUtil.addHostSet(result, "Solaris 6");
        RenameUtil.addHostSet(result, "Solaris 7");
        RenameUtil.addHostSet(result, "Solaris 8");
        RenameUtil.addHostSet(result, "Solaris 9");
        RenameUtil.addHostSet(result, "Solaris - any version");
        RenameUtil.addHostSet(result, "AIX 4.3.3");
        RenameUtil.addHostSet(result, "AIX 5.1");
        RenameUtil.addHostSet(result, "AIX 5.2");
        RenameUtil.addHostSet(result, "AIX - any version");
        result.put("Weblogic Admin Server", "com.sun.weblogic#Admin Server");
        result.put("Weblogic Managed Server", "com.sun.weblogic#Managed Server");
        result.put("Weblogic Cluster", "com.sun.weblogic#Cluster");
        result.put("Weblogic Deployment Target", "com.sun.weblogic#Deployment Target");
        return result;
    }

    private static void addHostSet(HashMap map, String name) {
        map.put(name, "system" + Plugin.NAME_SEPARATOR + name);
    }

    public static String mapHostSet(String name) {
        String result = (String)sHostSetMap.get(name);
        return result == null ? name : result;
    }

    public static void pushBlock() {
        RenameUtil.pushNameMap((NameMap)RenameUtil.getNameMap().clone());
    }

    public static void popBlock() {
        RenameUtil.popNameMap();
    }

    public static void addLocalVar(String varName) {
        RenameUtil.getNameMap().removeSimpleCompVar(varName);
    }

    public static void pushParamList() {
        mParams = new ArrayList();
    }

    public static void popParamList() {
        NameMap map = RenameUtil.getNameMap();
        Iterator params = mParams.iterator();
        while (params.hasNext()) {
            map.removeSimpleCompVar((String)params.next());
        }
        mParams = null;
    }

    public static void addParam(String varName) {
        mParams.add(varName);
    }

    static String mapConfigArray(String arrStr) {
        Database db = PersistenceManager.getInstance().getDefaultDatabase();
        Object[] vals = StringAttributeMap.arrayFromSQLString(db, arrStr);
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = RenameUtil.mapConfigVar((String)vals[i]);
        }
        return StringAttributeMap.arrayToSQLString(vals);
    }

    public static String getCompID(String path, String name, String version) throws PersistenceManagerException, RPCException {
        ComponentRef cr = new ComponentRef(path, name, version);
        cr = cr.resolvePath(FolderID.ROOT_FOLDER_ID);
        return SingleComponentQuery.byRef(cr).selectSummaryView().getID().toString();
    }

    static {
        COMP_NAME_MAP = RenameUtil.createNameMap(true);
        PLAN_NAME_MAP = RenameUtil.createNameMap(false);
        sHostSetMap = RenameUtil.createHostSetMap();
    }
}

