/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m41to50;

import com.raplix.rolloutexpress.migrate.Migratable;
import com.raplix.rolloutexpress.migrate.TableMigrator;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.util.NameRefSet;
import com.raplix.rolloutexpress.persist.util.NameRefTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentReferrer;
import com.raplix.util.logger.Logger;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class ReferencesMigrator
extends TableMigrator {
    Table mTable;
    NameRefTable mRefTable;

    public ReferencesMigrator(Table objTable, NameRefTable refTable) throws IOException {
        this.mTable = objTable;
        this.mRefTable = refTable;
        try {
            ReferencesMigrator.execute(this.mRefTable.delete());
        }
        catch (PersistenceManagerException e) {
            throw new IOException();
        }
    }

    protected Table getTable() {
        return this.mTable;
    }

    protected SelectList getSelectList() {
        return ReferencesMigrator.sList(this.mTable.ID);
    }

    protected ColumnNode getOrderColumn() {
        return this.mTable.ID;
    }

    protected Migratable processRow(ResultSet rs) throws PersistenceManagerException, SQLException {
        final ObjectID ID2 = this.mTable.ID.retrieveValue(rs);
        return new Migratable(){

            public void migrate() throws PersistenceManagerException {
                try {
                    ReferencesMigrator.this.migrate(ID2);
                }
                catch (RPCException e) {
                    throw new PersistenceManagerException(e);
                }
            }
        };
    }

    protected void migrate(ObjectID id) throws PersistenceManagerException, RPCException {
        Object obj = this.getReferrer(id);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Migrating :" + id, this);
        }
        NameRefSet set = new NameRefSet();
        this.addObjReferences(obj, set);
        this.mRefTable.addReferences(id, set);
    }

    abstract Object getReferrer(ObjectID var1) throws PersistenceManagerException, RPCException;

    protected void addObjReferences(Object obj, NameRefSet refSet) throws PersistenceManagerException {
        ComponentReferrer compRef = (ComponentReferrer)obj;
        compRef.addComponentRefsMS(refSet);
    }
}

