/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m41to50;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.migrate.EntityMigrator;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.resource.ResourceTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SingleFolderQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeImplTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.VarOverrideTable;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanImplTable;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDescriptor;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginEventListener;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginNotificationException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.rolloutexpress.ui.web.custom.PluginEventsHandler;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class PluginMigrator
implements EntityMigrator {
    private File mPluginPatchUpgradePath;
    private UserID mAdminUserID;

    PluginMigrator(String pluginPatchUpgradePath, Application app) throws IOException {
        this.mPluginPatchUpgradePath = new File(pluginPatchUpgradePath);
        PluginEventsHandler pluginListener = new PluginEventsHandler(app);
        PluginDBSubsystem pdb = PluginDBSubsystem.getInstance();
        pdb.registerPluginEventListener(new AddUserListener(pluginListener));
        try {
            this.mAdminUserID = pdb.getApplication().getUserDBSubsystem().getLocalUserDBAdmin().getUserManager().getAdminUserID();
        }
        catch (UnsupportedSubsystemException e) {
            throw new IOException("userdb subsystem unavailable");
        }
    }

    public int migrate() throws PersistenceManagerException {
        try {
            PluginDBSubsystem pdb = PluginDBSubsystem.getInstance();
            if (Logger.isInfoEnabled(this)) {
                Logger.info("migrating system plugin", this);
            }
            pdb.createRepoForPlugin(this.getDescriptor("system_1.0.jar"));
            this.importPlugin("system_1.0to1.1.jar");
            if (Logger.isInfoEnabled(this)) {
                Logger.info("migrating linux plugin", this);
            }
            FolderID oldLinux = SingleFolderQuery.byPath("/system/linux/").selectSummaryView().getID();
            FolderID newSun = SingleFolderQuery.byPath("/com/sun/").selectSummaryView().getID();
            oldLinux.move(newSun, null);
            pdb.createRepoForPlugin(this.getDescriptor("com.sun.linux_1.0.jar"));
            this.importPlugin("com.sun.linux_1.0to1.1.jar");
            if (Logger.isInfoEnabled(this)) {
                Logger.info("migrating windows plugin", this);
            }
            FolderID oldWin = SingleFolderQuery.byPath("/system/win32/").selectSummaryView().getID();
            oldWin.move(newSun, "windows");
            pdb.createRepoForPlugin(this.getDescriptor("com.sun.windows_1.0.jar"));
            this.importPlugin("com.sun.windows_1.0to1.1.jar");
            if (Logger.isInfoEnabled(this)) {
                Logger.info("migrating weblogic plugin", this);
            }
            this.resetWeblogicHostOverrides();
            FolderID oldWL = SingleFolderQuery.byPath("/system/weblogic/").selectSummaryView().getID();
            oldWL.move(newSun, null);
            pdb.createRepoForPlugin(this.getDescriptor("com.sun.weblogic_1.0.jar"));
            this.importPlugin("com.sun.weblogic_1.0to1.1.jar");
            this.resetWeblogicStubComponents(oldWL);
            return 0;
        }
        catch (Exception e) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Error migrating plugins", e, this);
            }
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PluginDescriptor getDescriptor(String archiveName) throws IOException, PersistenceManagerException {
        File jar = new File(this.mPluginPatchUpgradePath, archiveName);
        FileInputStream fin = new FileInputStream(jar);
        try {
            PluginDescriptor pluginDescriptor = new PluginDescriptor(fin, true);
            return pluginDescriptor;
        }
        finally {
            fin.close();
        }
    }

    PluginID importPlugin(String archiveName) throws IOException, PersistenceManagerException, RPCException {
        PluginID result = Plugin.importPlugin(this.getDescriptor(archiveName)).join();
        if (result == null) {
            throw new IOException("plugin import interrupted while importing " + archiveName);
        }
        return result;
    }

    private void resetWeblogicHostOverrides() throws PersistenceManagerException {
        VarOverrideTable vot = VarOverrideTable.DEFAULT;
        HostTypeImplTable htt = HostTypeImplTable.DEFAULT;
        String[] wlTypeNames = new String[]{"com.sun.weblogic#Admin Server", "com.sun.weblogic#Server", "com.sun.weblogic#Cluster"};
        String[] goodVars = new String[]{"adminUser", "adminPassword"};
        Select wlTypeIDs = htt.select(HostTypeImplTable.sList(htt.ID), HostTypeImplTable.where(HostTypeImplTable.in((ColumnNode)htt.Name, HostTypeImplTable.rList(wlTypeNames))));
        VarOverrideTable.execute(vot.delete(VarOverrideTable.where(VarOverrideTable.and(VarOverrideTable.in((ColumnNode)vot.HostTypeID, wlTypeIDs), VarOverrideTable.not(VarOverrideTable.in((ColumnNode)vot.VarName, HostTypeImplTable.rList(goodVars)))))));
    }

    private void resetWeblogicStubComponents(FolderID wlFolderID) throws PersistenceManagerException, RPCException {
        ComponentImplTable ct = ComponentImplTable.DEFAULT;
        ResourceTable rt = ResourceTable.DEFAULT;
        Select wlEmptyRsrcID = rt.select(ResourceTable.sList(rt.ID), ResourceTable.where(ResourceTable.equals(rt.Name, "/com/sun/weblogic/empty")));
        String[] stubNames = new String[]{"EJB Config Stub", "Entapp Config Stub", "Webapp Config Stub", "WebLogic JAR Stub", "WebLogic WAR Stub"};
        ComponentImplTable.execute(ct.update(ComponentImplTable.uList(ComponentImplTable.set((ColumnNode)ct.LocalResourceID, ComponentImplTable.scalar(wlEmptyRsrcID))), ComponentImplTable.where(ComponentImplTable.and(ComponentImplTable.equals(ct.PathID, wlFolderID), ComponentImplTable.in((ColumnNode)ct.Name, ComponentImplTable.rList(stubNames))))));
    }

    private void updateUsers(PluginID plugin) throws PluginNotificationException {
        try {
            ComponentImplTable ct = ComponentImplTable.DEFAULT;
            ComponentImplTable.execute(ct.update(ComponentImplTable.uList(ComponentImplTable.set(ct.UserID, this.mAdminUserID)), ComponentImplTable.where(ComponentImplTable.and(ComponentImplTable.equals(ct.PluginID, plugin), ComponentImplTable.isNull(ct.UserID)))));
            ExecutionPlanImplTable pt = ExecutionPlanImplTable.DEFAULT;
            ExecutionPlanImplTable.execute(pt.update(ExecutionPlanImplTable.uList(ExecutionPlanImplTable.set(pt.UserID, this.mAdminUserID)), ExecutionPlanImplTable.where(ExecutionPlanImplTable.and(ExecutionPlanImplTable.equals(pt.PluginID, plugin), ExecutionPlanImplTable.isNull(pt.UserID)))));
            ResourceTable rt = ResourceTable.DEFAULT;
            ResourceTable.execute(rt.update(ResourceTable.uList(ResourceTable.set(rt.UserID, this.mAdminUserID)), ResourceTable.where(ResourceTable.and(ResourceTable.equals(rt.PluginID, plugin), ResourceTable.isNull(rt.UserID)))));
        }
        catch (PersistenceManagerException e) {
            throw new PluginNotificationException(e);
        }
    }

    private class AddUserListener
    implements PluginEventListener {
        private PluginEventListener mDelegate;

        public AddUserListener(PluginEventListener delegate) {
            this.mDelegate = delegate;
        }

        public void pluginAdded(PluginID pluginID) throws PluginNotificationException {
            PluginMigrator.this.updateUsers(pluginID);
            this.mDelegate.pluginAdded(pluginID);
        }

        public void transform(PluginID plugin, InputStream in, OutputStream out) throws PluginNotificationException {
            this.mDelegate.transform(plugin, in, out);
        }

        public void pluginDeleted(PluginID pluginID) throws PluginNotificationException {
            this.mDelegate.pluginDeleted(pluginID);
        }

        public void pluginEdited(PluginID pluginID) throws PluginNotificationException {
            this.mDelegate.pluginEdited(pluginID);
        }
    }
}

