/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m41to50;

import com.raplix.rolloutexpress.migrate.node.ChmodFileStep;
import com.raplix.rolloutexpress.migrate.node.CopyFileStep;
import com.raplix.rolloutexpress.migrate.node.CreateFileStep;
import com.raplix.rolloutexpress.migrate.node.ExecCommandUpgradeStep;
import com.raplix.rolloutexpress.migrate.node.IncludePlatformStepConstraint;
import com.raplix.rolloutexpress.migrate.node.MkdirStep;
import com.raplix.rolloutexpress.migrate.node.MoveFileStep;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeApp;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeContext;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeStep;
import com.raplix.rolloutexpress.migrate.node.Perl5TransformFileStep;
import com.raplix.rolloutexpress.migrate.node.PlatformStepConstraint;
import com.raplix.rolloutexpress.migrate.node.StepConstraint;
import com.raplix.rolloutexpress.migrate.node.UpgradeTransformStep;
import com.raplix.util.file.Perl5Transform;
import com.raplix.util.platform.common.PlatformUtil;
import com.raplix.util.platform.posix.Stat;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NodeUpgrade
extends NodeUpgradeApp {
    private static final String SPS_JVM_HOME = "jvm" + File.separator + "jre" + File.separator + "bin";
    private static final String REDIRECT_FILE = SPS_JVM_HOME + File.separator + ".redirect";
    private static final String RESTART_FILE = "bin" + File.separator + "restart.cmd";
    private static final String SHOWBUILD_FILE = "bin" + File.separator + "ShowBuild.cmd";
    private static final String PROXY_FILE = SPS_JVM_HOME + File.separator + ".proxy";
    private static final String JRE_HOME = "../../../jvm/jre1.4.2_03/bin";
    private static final String JRE_HOME_WIN = "..\\\\..\\\\..\\\\jvm\\\\jre1.4.2_03\\\\bin";
    private static final String JRE_HOME_AIX = "../../../jvm/jre1.4.1/bin";
    private static final UpgradeTransformStep.FileResolver APP_HOME_RESOLVER = UpgradeTransformStep.FileResolver.ApplicationHome;
    private static final UpgradeTransformStep.FileResolver UPGRADE_TMP_RESOLVER = UpgradeTransformStep.FileResolver.UpgradeTemp;
    private static final UpgradeTransformStep.FileResolver BACKUP_RESOLVER = UpgradeTransformStep.FileResolver.UpgradeBackupBase;
    private static final PlatformStepConstraint WIN32_CONSTRAINT = new IncludePlatformStepConstraint().addWin32();
    private static final PlatformStepConstraint UNIX_CONSTRAINT = new IncludePlatformStepConstraint().addUnix();
    private static final PlatformStepConstraint LD_CONSTRAINT = new LDStepConstraint().addWin32().addUnix();
    private static final PlatformStepConstraint RA_CONSTRAINT = new RAStepConstraint().addWin32().addUnix();
    private static final PlatformStepConstraint WIN32_LD_CONSTRAINT = new LDStepConstraint().addWin32();
    private static final PlatformStepConstraint WIN32_RA_CONSTRAINT = new RAStepConstraint().addWin32();

    public static void main(String[] args) {
        NodeUpgrade upgradeApp = new NodeUpgrade();
        try {
            upgradeApp.run();
        }
        catch (Exception e) {
            upgradeApp.logError(e);
            upgradeApp.exitFailed();
        }
    }

    public NodeUpgradeStep[] getUpgradeSteps() {
        ArrayList stepList = new ArrayList();
        stepList.addAll(this.getBackupSteps());
        stepList.addAll(this.getLicenseSteps());
        stepList.addAll(this.getProxyJVMSteps());
        stepList.addAll(this.getNameAndVersionUpdateSteps());
        stepList.addAll(this.getExecCommandUpgradeSteps());
        stepList.addAll(this.getLibrariesFileSteps());
        stepList.addAll(this.getNativeWindowsLibsSteps());
        return stepList.toArray(new NodeUpgradeStep[0]);
    }

    private List getLicenseSteps() {
        ArrayList<NodeUpgradeStep> stepList = new ArrayList<NodeUpgradeStep>();
        String readme = "README";
        String destLicense = readme + File.separator + "LICENSE";
        String agentSrcLicense = "agent" + File.separator + readme + File.separator + "LICENSE";
        String ldSrcLicense = "ld" + File.separator + readme + File.separator + "LICENSE";
        stepList.add(new MkdirStep(null, readme));
        stepList.add(new MoveFileStep(RA_CONSTRAINT, agentSrcLicense, destLicense, UPGRADE_TMP_RESOLVER, APP_HOME_RESOLVER));
        stepList.add(new MoveFileStep(LD_CONSTRAINT, ldSrcLicense, destLicense, UPGRADE_TMP_RESOLVER, APP_HOME_RESOLVER));
        return stepList;
    }

    private List getBackupSteps() {
        ArrayList<UpgradeTransformStep> stepList = new ArrayList<UpgradeTransformStep>();
        stepList.add(new CopyFileStep(null, REDIRECT_FILE, REDIRECT_FILE, APP_HOME_RESOLVER, BACKUP_RESOLVER, true));
        stepList.add(new CopyFileStep(WIN32_CONSTRAINT, SHOWBUILD_FILE, SHOWBUILD_FILE, APP_HOME_RESOLVER, BACKUP_RESOLVER, true));
        stepList.add(new CopyFileStep(WIN32_CONSTRAINT, RESTART_FILE, RESTART_FILE, APP_HOME_RESOLVER, BACKUP_RESOLVER, true));
        stepList.add(new MoveFileStep(UNIX_CONSTRAINT, PROXY_FILE, PROXY_FILE, APP_HOME_RESOLVER, BACKUP_RESOLVER));
        return stepList;
    }

    private List getNativeWindowsLibsSteps() {
        ArrayList<CopyFileStep> stepList = new ArrayList<CopyFileStep>();
        stepList.add(new CopyFileStep(WIN32_CONSTRAINT, "izm\\izmcomjni.jar", "lib\\platform\\win32\\izmcomjni.jar", UPGRADE_TMP_RESOLVER, APP_HOME_RESOLVER, true));
        stepList.add(new CopyFileStep(WIN32_CONSTRAINT, "izm\\izmjnicom.dll", "lib\\platform\\win32\\izmjnicom.dll", UPGRADE_TMP_RESOLVER, APP_HOME_RESOLVER, true));
        stepList.add(new CopyFileStep(WIN32_CONSTRAINT, "izm\\winutils.jar", "lib\\platform\\win32\\winutils.jar", UPGRADE_TMP_RESOLVER, APP_HOME_RESOLVER, true));
        stepList.add(new CopyFileStep(WIN32_CONSTRAINT, "izm\\21100220.LIC", "lib\\platform\\win32\\21100220.LIC", UPGRADE_TMP_RESOLVER, APP_HOME_RESOLVER, true));
        return stepList;
    }

    private List getExecCommandUpgradeSteps() {
        return Arrays.asList(new VBScriptExecCommandStep(WIN32_RA_CONSTRAINT, -1L, "-ra"), new VBScriptExecCommandStep(WIN32_LD_CONSTRAINT, -1L, "-ld"));
    }

    private List getNameAndVersionUpdateSteps() {
        ArrayList<Perl5TransformFileStep> stepList = new ArrayList<Perl5TransformFileStep>();
        Perl5Transform.Sub n1SPSSub = new Perl5Transform.Sub("echo N1 Service Provisioning System", "echo N1 Grid Service Provisioning System");
        Perl5Transform.Sub n1RASub = new Perl5Transform.Sub("N1 Service Provisioning System 4[.]{0,1}1", "N1 Grid Service Provisioning System 5.0");
        stepList.add(new Perl5TransformFileStep(WIN32_CONSTRAINT, new Perl5Transform.Sub[]{n1SPSSub}, SHOWBUILD_FILE, SHOWBUILD_FILE, BACKUP_RESOLVER, APP_HOME_RESOLVER));
        stepList.add(new Perl5TransformFileStep(WIN32_CONSTRAINT, new Perl5Transform.Sub[]{n1RASub}, RESTART_FILE, RESTART_FILE, BACKUP_RESOLVER, APP_HOME_RESOLVER));
        return stepList;
    }

    private List getProxyJVMSteps() {
        ArrayList<Perl5TransformFileStep> stepList = new ArrayList<Perl5TransformFileStep>();
        Perl5Transform.Sub redirectSub = PlatformUtil.isAix() ? new Perl5Transform.Sub("^.*bin.*$", JRE_HOME_AIX) : (PlatformUtil.isWin32() ? new Perl5Transform.Sub("^.*bin.*$", JRE_HOME_WIN) : new Perl5Transform.Sub("^.*bin.*$", JRE_HOME));
        stepList.add(new Perl5TransformFileStep(null, new Perl5Transform.Sub[]{redirectSub}, REDIRECT_FILE, REDIRECT_FILE, BACKUP_RESOLVER, APP_HOME_RESOLVER));
        return stepList;
    }

    private List getLibrariesFileSteps() {
        ArrayList<NodeUpgradeStep> stepList = new ArrayList<NodeUpgradeStep>();
        String libFile = SPS_JVM_HOME + File.separator + ".libraries";
        stepList.add(new CreateFileStep((StepConstraint)UNIX_CONSTRAINT, libFile, new UpgradeLibHome(), CreateFileStep.ConcatType.OVERWRITE, APP_HOME_RESOLVER));
        stepList.add(new CreateFileStep((StepConstraint)UNIX_CONSTRAINT, libFile, new CommonLibHome(), CreateFileStep.ConcatType.APPEND, APP_HOME_RESOLVER));
        String proxySrc = "libraries_file" + File.separator + ".proxy";
        String proxyDest = SPS_JVM_HOME + File.separator + ".proxy";
        stepList.add(new MoveFileStep(UNIX_CONSTRAINT, proxySrc, proxyDest, UPGRADE_TMP_RESOLVER, APP_HOME_RESOLVER));
        if (PlatformUtil.isUnix()) {
            long mode = Stat.RWXU | Stat.RGRP | Stat.XGRP | Stat.ROTH | Stat.XOTH;
            stepList.add(new ChmodFileStep(proxyDest, mode, true));
        }
        return stepList;
    }

    private class UpgradeLibHome
    implements CreateFileStep.TextGenerator {
        private UpgradeLibHome() {
        }

        public String generateText(NodeUpgradeContext ctx) {
            String path = "lib/upgrade/5.0/";
            path = PlatformUtil.isAix() ? path + "aix" : (PlatformUtil.isLinux() ? path + "linux" : path + "solaris");
            path = path + ":";
            return APP_HOME_RESOLVER.resolveFile(ctx, path).getAbsolutePath();
        }
    }

    private class CommonLibHome
    implements CreateFileStep.TextGenerator {
        private CommonLibHome() {
        }

        public String generateText(NodeUpgradeContext ctx) {
            String path = "../common/lib/";
            path = PlatformUtil.isAix() ? path + "aix" : (PlatformUtil.isLinux() ? path + "linux" : path + "solaris");
            return APP_HOME_RESOLVER.resolveFile(ctx, path).getAbsolutePath();
        }
    }

    private static class LDStepConstraint
    extends IncludePlatformStepConstraint {
        private LDStepConstraint() {
        }

        public boolean shouldRunStep(NodeUpgradeContext ctx) {
            return this.currentPlatform() && ctx.isAppLD();
        }
    }

    private static class RAStepConstraint
    extends IncludePlatformStepConstraint {
        private RAStepConstraint() {
        }

        public boolean shouldRunStep(NodeUpgradeContext ctx) {
            return this.currentPlatform() && ctx.isAppRA();
        }
    }

    private static class VBScriptExecCommandStep
    extends ExecCommandUpgradeStep {
        private String mTarget;

        public VBScriptExecCommandStep(StepConstraint constraint, long timeout, String target) {
            super(constraint, timeout);
            this.mTarget = target;
        }

        protected String[] getCmdArray(NodeUpgradeContext ctx) {
            return new String[]{"cscript", UPGRADE_TMP_RESOLVER.resolveFile(ctx, "migrate.vbs").getPath(), this.mTarget};
        }
    }
}

