/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m41to50;

import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.hierarchies.compexport.SourceInfo;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.util.ObjectUtil;
import com.raplix.util.string.CSVUtil;
import com.raplix.util.string.StringUtil;
import java.util.Hashtable;
import java.util.Vector;

public class MigrateSourceInfo
implements VariableSettingsSource,
RPCSerializable {
    private HostID mHost;
    private String mLocation;
    private Hashtable mData;
    private Vector mParameterNames;

    public MigrateSourceInfo(HostID host, String location) {
        this.mHost = host;
        if (location == null) {
            location = "";
        }
        this.mLocation = location;
        this.mData = new Hashtable();
        this.mParameterNames = new Vector();
    }

    private MigrateSourceInfo() {
    }

    public HostID getHost() {
        return this.mHost;
    }

    public String getLocation() {
        return this.mLocation;
    }

    public String getPersistString() {
        String[] names = this.getVarNames();
        String[] dataCSV = new String[names.length + 1];
        int i = 0;
        dataCSV[i++] = this.getLocation();
        int j = 0;
        while (j < names.length) {
            dataCSV[i] = ((DataTuple)this.mData.get(names[j])).getCSVList();
            ++j;
            ++i;
        }
        return CSVUtil.composePSV(dataCSV);
    }

    public static MigrateSourceInfo reconstitute(HostID host, String persistString) {
        String location;
        String[] data;
        if (StringUtil.isEmpty(persistString)) {
            data = new String[]{};
            location = null;
        } else {
            data = CSVUtil.splitPSV(persistString);
            location = data[0];
        }
        MigrateSourceInfo si = new MigrateSourceInfo(host, location);
        for (int i = 1; i < data.length; ++i) {
            si.addTuple(new DataTuple(data[i]));
        }
        return si;
    }

    public void addParameter(String name, String val, String desc) {
        this.addTuple(new DataTuple(name, val, desc));
    }

    private void addTuple(DataTuple tuple) {
        DataTuple existingTuple = (DataTuple)this.mData.get(tuple.getName());
        if (existingTuple == null) {
            this.mParameterNames.add(tuple.getName());
        }
        this.mData.put(tuple.getName(), tuple);
    }

    public void removeParameter(String name) {
        this.mData.remove(name);
        this.mParameterNames.remove(name);
    }

    public boolean containsVarValue(String varName) {
        return this.mData.containsKey(varName);
    }

    public String[] getVarNames() {
        return this.mParameterNames.toArray(new String[0]);
    }

    public String getVarValue(String varName) {
        DataTuple tuple = (DataTuple)this.mData.get(varName);
        if (tuple == null) {
            return null;
        }
        return tuple.getValue();
    }

    public String getVarDescription(String varName) {
        DataTuple tuple = (DataTuple)this.mData.get(varName);
        if (tuple == null) {
            return null;
        }
        return tuple.getDescription();
    }

    public String[] getVarDescriptions() {
        String[] names = this.getVarNames();
        String[] descriptions = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            descriptions[i] = this.getVarDescription(names[i]);
        }
        return descriptions;
    }

    public boolean equals(Object si) {
        if (this == si) {
            return true;
        }
        if (si == null || !(si instanceof MigrateSourceInfo)) {
            return false;
        }
        if (!ObjectUtil.equals(this.getHost(), ((MigrateSourceInfo)si).getHost())) {
            return false;
        }
        return this.getPersistString().equals(((MigrateSourceInfo)si).getPersistString());
    }

    public int hashCode() {
        return this.getHost().hashCode() + this.getPersistString().hashCode();
    }

    public String toString() {
        return "Host:" + this.getHost() + " PersistString:" + this.getPersistString();
    }

    public MigrateSourceInfo getDataClone() {
        return MigrateSourceInfo.reconstitute(this.getHost(), this.getPersistString());
    }

    public static MigrateSourceInfo translate(SourceInfo newInfo) {
        if (newInfo == null) {
            return null;
        }
        MigrateSourceInfo oldInfo = new MigrateSourceInfo(newInfo.getHost(), newInfo.getResourceLocation());
        String[] names = newInfo.getVarNames();
        for (int i = 0; i < names.length; ++i) {
            oldInfo.addParameter(names[i], newInfo.getVarValue(names[i]), newInfo.getVarDescription(names[i]));
        }
        return oldInfo;
    }

    public static SourceInfo translate(MigrateSourceInfo oldInfo) {
        if (oldInfo == null) {
            return null;
        }
        SourceInfo newInfo = new SourceInfo(oldInfo.getHost(), null, oldInfo.getLocation(), oldInfo.getLocation());
        String[] names = oldInfo.getVarNames();
        for (int i = 0; i < names.length; ++i) {
            newInfo.addParameter(names[i], oldInfo.getVarValue(names[i]), oldInfo.getVarDescription(names[i]));
        }
        return newInfo;
    }

    private static class DataTuple
    implements RPCSerializable {
        private String mName;
        private String mVal;
        private String mDesc;

        public DataTuple(String name, String val, String desc) {
            if (StringUtil.isEmpty(name)) {
                throw new NullPointerException();
            }
            this.mName = name;
            this.mVal = val;
            if (this.mVal == null) {
                this.mVal = "";
            }
            this.mDesc = desc;
            if (this.mDesc == null) {
                this.mDesc = "";
            }
        }

        public DataTuple(String csvList) {
            String[] listVals = CSVUtil.splitCSV(csvList);
            if (StringUtil.isEmpty(listVals[0])) {
                throw new NullPointerException();
            }
            this.mName = listVals[0];
            this.mVal = listVals[1];
            this.mDesc = listVals[2];
        }

        public String getName() {
            return this.mName;
        }

        public String getValue() {
            return this.mVal;
        }

        public String getDescription() {
            return this.mDesc;
        }

        public String getCSVList() {
            return CSVUtil.composeCSV(new String[]{this.getName(), this.getValue(), this.getDescription()});
        }
    }
}

