/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m41to50;

import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.RaplixShutdownException;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceSettingsTable;
import com.raplix.rolloutexpress.migrate.EntityMigrator;
import com.raplix.rolloutexpress.migrate.Migrator;
import com.raplix.rolloutexpress.migrate.TransformMigrator;
import com.raplix.rolloutexpress.migrate.m41to50.CompToCompRefMigrator;
import com.raplix.rolloutexpress.migrate.m41to50.CompVarSetMigrator;
import com.raplix.rolloutexpress.migrate.m41to50.CompVarToComRefMigrator;
import com.raplix.rolloutexpress.migrate.m41to50.ComponentMigrator;
import com.raplix.rolloutexpress.migrate.m41to50.ConfigTemplateMigrator;
import com.raplix.rolloutexpress.migrate.m41to50.DependencyToCompRefMigrator;
import com.raplix.rolloutexpress.migrate.m41to50.DifferenceSettingsToCompRefMigrator;
import com.raplix.rolloutexpress.migrate.m41to50.FolderMigrator;
import com.raplix.rolloutexpress.migrate.m41to50.FolderPermissionMigrator;
import com.raplix.rolloutexpress.migrate.m41to50.GenVarSetMigrator;
import com.raplix.rolloutexpress.migrate.m41to50.PlanToCompRefMigrator;
import com.raplix.rolloutexpress.migrate.m41to50.PlanToPlanRefMigrator;
import com.raplix.rolloutexpress.migrate.m41to50.PluginMigrator;
import com.raplix.rolloutexpress.migrate.m41to50.WLBaseCTMigrator;
import com.raplix.rolloutexpress.migrate.m41to50.WLBaseRegCTMigrator;
import com.raplix.rolloutexpress.migrate.m41to50.WLClusterMigrator;
import com.raplix.rolloutexpress.migrate.m41to50.WLCompVarSetMigrator;
import com.raplix.rolloutexpress.migrate.m41to50.WLComponentMigrator;
import com.raplix.rolloutexpress.migrate.m41to50.WLInstCompMigrator;
import com.raplix.rolloutexpress.migrate.m41to50.WLManagedServer2ASMigrator;
import com.raplix.rolloutexpress.migrate.m41to50.WLManagedServer2ClusterMigrator;
import com.raplix.rolloutexpress.migrate.m41to50.WindowsComponentMigrator;
import com.raplix.rolloutexpress.systemmodel.installdb.DependencyImplTable;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanImplTable;
import com.raplix.util.file.Transform;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.io.IOException;

public class MigrateData
extends Migrator {
    public static final String PLAN_COMP_FILE_ARG = "-pcfile";
    public static final String PLUGIN_PATCH_DIR_ARG = "-ppdir";
    private static final String MINI_PLAN_WRAPPER_OPEN = "<miniPlan xmlns=\"http://www.sun.com/schema/SPS\">";
    private static final String MINI_PLAN_WRAPPER_CLOSE = "</miniPlan>";
    private static final String DEPENDENCY_WRAPPER_OPEN = "<dependency xmlns=\"http://www.sun.com/schema/SPS\">";
    private static final String DEPENDENCY_WRAPPER_CLOSE = "</dependency>";
    private String mXSLPlanCompFile = null;
    private String mPluginPatchPath = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) {
        block14: {
            MigrateData migrator;
            int nErrors;
            block12: {
                block13: {
                    nErrors = 0;
                    migrator = null;
                    migrator = new MigrateData(args);
                    migrator.start();
                    nErrors = migrator.doMigration();
                    Object var5_3 = null;
                    if (migrator == null) break block12;
                    try {
                        migrator.shutdown();
                    }
                    catch (RaplixShutdownException rse) {
                        if (!Logger.isErrorEnabled(MigrateData.class)) break block13;
                        Logger.error("Error shutting down: ", rse, MigrateData.class);
                    }
                }
                migrator.exitProcess(nErrors);
                break block14;
            }
            System.exit(nErrors);
            {
                break block14;
                catch (Throwable e) {
                    ++nErrors;
                    if (Logger.isErrorEnabled(MigrateData.class)) {
                        Logger.error("Unexpected Error: ", e, MigrateData.class);
                    }
                    Object var5_4 = null;
                    if (migrator != null) {
                        block15: {
                            try {
                                migrator.shutdown();
                            }
                            catch (RaplixShutdownException rse) {
                                if (!Logger.isErrorEnabled(MigrateData.class)) break block15;
                                Logger.error("Error shutting down: ", rse, MigrateData.class);
                            }
                        }
                        migrator.exitProcess(nErrors);
                        break block14;
                    }
                    System.exit(nErrors);
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (migrator != null) {
                    block16: {
                        try {
                            migrator.shutdown();
                        }
                        catch (RaplixShutdownException rse) {
                            if (!Logger.isErrorEnabled(MigrateData.class)) break block16;
                            Logger.error("Error shutting down: ", rse, MigrateData.class);
                        }
                    }
                    migrator.exitProcess(nErrors);
                } else {
                    System.exit(nErrors);
                }
                throw throwable;
            }
        }
    }

    protected EntityMigrator[] getMigrators() throws IOException {
        Transform[] planTransforms = new Transform[]{this.getXSLTTransformerFromFile(this.mXSLPlanCompFile)};
        Transform[] compTransforms = new Transform[]{planTransforms[0]};
        return new EntityMigrator[]{new FolderMigrator(), new FolderPermissionMigrator(this.mUserDB), new ComponentMigrator(compTransforms), new TransformMigrator(ExecutionPlanImplTable.DEFAULT, planTransforms, ExecutionPlanImplTable.DEFAULT.BodyXML), new TransformMigrator(DifferenceSettingsTable.DEFAULT, planTransforms, DifferenceSettingsTable.DEFAULT.SrcPrepare, MINI_PLAN_WRAPPER_OPEN, MINI_PLAN_WRAPPER_CLOSE), new TransformMigrator(DifferenceSettingsTable.DEFAULT, planTransforms, DifferenceSettingsTable.DEFAULT.SrcCleanup, MINI_PLAN_WRAPPER_OPEN, MINI_PLAN_WRAPPER_CLOSE), new TransformMigrator(DifferenceSettingsTable.DEFAULT, planTransforms, DifferenceSettingsTable.DEFAULT.DstPrepare, MINI_PLAN_WRAPPER_OPEN, MINI_PLAN_WRAPPER_CLOSE), new TransformMigrator(DifferenceSettingsTable.DEFAULT, planTransforms, DifferenceSettingsTable.DEFAULT.DstCleanup, MINI_PLAN_WRAPPER_OPEN, MINI_PLAN_WRAPPER_CLOSE), new TransformMigrator(DependencyImplTable.DEFAULT, compTransforms, DependencyImplTable.DEFAULT.InstalledComponentTargeterAsString, DEPENDENCY_WRAPPER_OPEN, DEPENDENCY_WRAPPER_CLOSE), new CompVarSetMigrator(), new GenVarSetMigrator(), new CompToCompRefMigrator(), new DependencyToCompRefMigrator(), new DifferenceSettingsToCompRefMigrator(), new PlanToCompRefMigrator(), new PlanToPlanRefMigrator(), new CompVarToComRefMigrator(), new ConfigTemplateMigrator(), new WLComponentMigrator(this.getWLTransform("wlAdminServer.xsl"), "WL Admin Server", "1.0"), new WLComponentMigrator(this.getWLTransform("wlAdminServer7.xsl"), "WL Admin Server 7.0", "1.1"), new WLComponentMigrator(this.getWLTransform("wlTarget.xsl"), "WL Target", "1.0"), new WLComponentMigrator(this.getWLTransform("wlManagedServer.xsl"), "WL Managed Server", "1.0"), new WLComponentMigrator(this.getWLTransform("wlCluster.xsl"), "WL Cluster", "1.0"), new WLComponentMigrator(this.getWLTransform("wlServices.xsl"), "Weblogic SS", "1.0"), new WLComponentMigrator(this.getWLTransform("wlServices.xsl"), "Weblogic SS", "1.1"), new WindowsComponentMigrator(this.getWLTransform("windowsServices.xsl"), "DSN SS"), new WindowsComponentMigrator(this.getWLTransform("windowsServices.xsl"), "Metabase SS"), new WindowsComponentMigrator(this.getWLTransform("windowsServices.xsl"), "Registry Key SS"), new WLCompVarSetMigrator("WL Managed Server", "serverName"), new WLCompVarSetMigrator("WL Cluster", "clusterName"), new WLInstCompMigrator(), new PluginMigrator(this.mPluginPatchPath, this), new WLBaseRegCTMigrator(), new WLClusterMigrator(), new WLBaseCTMigrator(), new WLManagedServer2ASMigrator(), new WLManagedServer2ClusterMigrator()};
    }

    private Transform getWLTransform(String transformName) throws IOException {
        return this.getXSLTTransformerFromFile(this.mPluginPatchPath + File.separator + transformName);
    }

    MigrateData(String[] args) throws ConfigurationException {
        super(args);
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith(PLAN_COMP_FILE_ARG)) {
                this.mXSLPlanCompFile = args[++i];
            }
            if (!args[i].equals(PLUGIN_PATCH_DIR_ARG)) continue;
            this.mPluginPatchPath = args[++i];
        }
        if (this.mXSLPlanCompFile == null) {
            throw new IllegalArgumentException("Please supply the path to the XSL transform file (planComp_4.1_5.0.xsl) as -pcfile <fileName>");
        }
        if (this.mPluginPatchPath == null) {
            throw new IllegalArgumentException("Please supply the path to the directory in which plugin patch upgrade files are found as -ppdir <path>");
        }
    }
}

