/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m41to50;

import com.raplix.rolloutexpress.config.PersistentVariableSettingsTable;
import com.raplix.rolloutexpress.migrate.Migratable;
import com.raplix.rolloutexpress.migrate.TableMigrator;
import com.raplix.rolloutexpress.migrate.m41to50.RenameUtil;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.attribute.StringAttributeMap;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.IDValueProcessor;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompTypeRefToCompTypeRefLinkTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefImplTable;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstalledComponentTable;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class GenVarSetMigrator
extends TableMigrator {
    private static PersistentVariableSettingsTable TABLE = PersistentVariableSettingsTable.DEFAULT;
    private Map mInstalledValueMap;

    protected Table getTable() {
        return TABLE;
    }

    protected SelectList getSelectList() {
        return GenVarSetMigrator.sList(GenVarSetMigrator.TABLE.ID, (ScalarExp)GenVarSetMigrator.TABLE.VarSettings);
    }

    protected ColumnNode getOrderColumn() {
        return GenVarSetMigrator.TABLE.ID;
    }

    protected Migratable processRow(ResultSet rs) throws PersistenceManagerException, SQLException {
        final ObjectID id = GenVarSetMigrator.TABLE.ID.retrieveValue(rs);
        final String vars = GenVarSetMigrator.TABLE.VarSettings.retrieveValue(rs);
        return new Migratable(){

            public void migrate() throws PersistenceManagerException, IOException {
                GenVarSetMigrator.this.migrate(id, vars);
            }

            public String toString() {
                return "ID:" + id;
            }
        };
    }

    private void migrate(ObjectID id, String varsStr) throws PersistenceManagerException, IOException {
        RenameUtil.setNameMap("component");
        Database db = PersistenceManager.getInstance().getDefaultDatabase();
        Object[] vars = StringAttributeMap.arrayFromSQLString(db, varsStr);
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = this.mapEntry(id, (String)vars[i]);
        }
        varsStr = StringAttributeMap.arrayToSQLString(vars);
        GenVarSetMigrator.execute(GenVarSetMigrator.update(TABLE, GenVarSetMigrator.uList(GenVarSetMigrator.set(GenVarSetMigrator.TABLE.VarSettings, varsStr)), GenVarSetMigrator.where(GenVarSetMigrator.equals(GenVarSetMigrator.TABLE.ID, id))));
    }

    private String mapEntry(ObjectID id, String entry) throws PersistenceManagerException {
        int ndx = entry.indexOf(61);
        String keyAndName = entry.substring(0, ndx);
        String val = entry.substring(ndx + 1);
        ndx = keyAndName.indexOf(58);
        if (ndx == -1) {
            return keyAndName + '=' + RenameUtil.mapConfigVar(val);
        }
        String key = keyAndName.substring(0, ndx);
        String name = keyAndName.substring(ndx + 1);
        key = RenameUtil.mapTypeName(key);
        name = RenameUtil.mapCompVarName(name);
        return key + ':' + name + '=' + this.mapInstalledValue(id, val);
    }

    private String mapInstalledValue(ObjectID id, String value) throws PersistenceManagerException {
        Map valueMap = (Map)this.getInstalledValueMap().get(id);
        if (valueMap == null) {
            return value;
        }
        String newValue = (String)valueMap.get(value);
        if (newValue != null) {
            return newValue;
        }
        return value;
    }

    private Map getInstalledValueMap() throws PersistenceManagerException {
        if (this.mInstalledValueMap == null) {
            this.mInstalledValueMap = new HashMap();
            this.populateMapWL(this.mInstalledValueMap, "web application", "webapp.WebApp");
            this.populateMapWL(this.mInstalledValueMap, "EJB", "ejb.EJB");
            this.populateMapWL(this.mInstalledValueMap, "enterprise application", "entapp.EntApp");
            this.populateMapWin(this.mInstalledValueMap);
        }
        return this.mInstalledValueMap;
    }

    private void populateMapWL(Map map, String typeNameBase, String packagePrefix) throws PersistenceManagerException {
        String weblogicPluginName = "com.sun.weblogic#";
        this.populateMap(map, weblogicPluginName + typeNameBase, this.getTargeterMap(packagePrefix));
        this.populateMap(map, weblogicPluginName + typeNameBase + " container", this.getRegMap(packagePrefix));
        this.populateMap(map, weblogicPluginName + typeNameBase + " settings", this.getConfigMap(packagePrefix));
    }

    private Map getTargeterMap(String prefix) {
        HashMap result = new HashMap();
        this.mapExecJavaWL(result, prefix + "TargetServerFactory");
        this.mapExecJavaWL(result, prefix + "UntargetServerFactory");
        this.mapExecJavaWL(result, prefix + "TargetClusterFactory");
        this.mapExecJavaWL(result, prefix + "UntargetClusterFactory");
        this.mapExecJavaWL(result, prefix + "ExportTargetsFactory");
        return result;
    }

    private Map getRegMap(String prefix) {
        HashMap result = new HashMap();
        this.mapExecJavaWL(result, prefix + "RegisterFactory");
        this.mapExecJavaWL(result, prefix + "ApplyConfigFactory");
        this.mapExecJavaWL(result, prefix + "UnregisterFactory");
        return result;
    }

    private Map getConfigMap(String prefix) {
        HashMap result = new HashMap();
        this.mapExecJavaWL(result, prefix + "ExportConfigFactory");
        return result;
    }

    private void mapExecJavaWL(Map map, String className) {
        map.put("com.raplix.rolloutexpress.plugins.weblogic.execjava." + className, "com.sun.n1.sig.plugin.weblogic.execjava." + className);
    }

    private void populateMapWin(Map map) throws PersistenceManagerException {
        HashMap winMap = new HashMap();
        this.mapExecJavaWin(winMap, "WebSiteFilterExportFactory");
        this.mapExecJavaWin(winMap, "WebSiteExportFactory");
        this.mapExecJavaWin(winMap, "GlobalFilterExportFactory");
        this.mapExecJavaWin(winMap, "GlobalSettingsExportFactory");
        this.populateMap(map, "com.sun.windows#metabase base ct", winMap);
    }

    private void mapExecJavaWin(Map map, String className) {
        map.put("com.raplix.rolloutexpress.plugins.win32.execjava.metabase." + className, "com.sun.n1.sig.plugin.windows.execjava.metabase." + className);
    }

    private void populateMap(Map map, String typeName, Object value) throws PersistenceManagerException {
        ComponentTypeRefImplTable ictr = new ComponentTypeRefImplTable("ictr");
        Select typeID = ictr.select(GenVarSetMigrator.sList(ictr.ID), GenVarSetMigrator.where(GenVarSetMigrator.equals(ictr.Name, typeName)));
        Select derivedTypeIDs = CompTypeRefToCompTypeRefLinkTable.DEFAULT.selectChildIDs(typeID);
        ComponentTypeRefImplTable ctr = new ComponentTypeRefImplTable("ctr");
        Select derivedTypeNames = ctr.select(GenVarSetMigrator.sList(ctr.Name), GenVarSetMigrator.where(GenVarSetMigrator.or(GenVarSetMigrator.equals(ctr.Name, typeName), GenVarSetMigrator.in((ColumnNode)ctr.ID, derivedTypeIDs))));
        ComponentImplTable ct = ComponentImplTable.DEFAULT;
        Select compsOfType = ct.select(GenVarSetMigrator.sList(ct.ID), GenVarSetMigrator.where(GenVarSetMigrator.in((ColumnNode)ct.ExtendsTypeName, derivedTypeNames)));
        PersistentInstalledComponentTable ict = PersistentInstalledComponentTable.DEFAULT;
        Select instVarsOfType = ict.select(GenVarSetMigrator.sList(ict.VariableSettingsID), GenVarSetMigrator.where(GenVarSetMigrator.in((ColumnNode)ict.ComponentID, compsOfType)));
        IDValueProcessor idProcessor = new IDValueProcessor(ict.VariableSettingsID);
        GenVarSetMigrator.execute(instVarsOfType, idProcessor);
        Iterator ids = idProcessor.getRetrievedValues().iterator();
        while (ids.hasNext()) {
            map.put(ids.next(), value);
        }
    }
}

