/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m41to50;

import com.raplix.rolloutexpress.migrate.Migratable;
import com.raplix.rolloutexpress.migrate.TableMigrator;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ResultSetProcessor;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.ScalarList;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.folderdb.Folder;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderImplTable;
import com.raplix.rolloutexpress.systemmodel.folderdb.SingleFolderQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderAccessData;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermissionItem;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupIDSet;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupManager;
import com.raplix.rolloutexpress.systemmodel.userdb.Permission;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionID;
import com.raplix.rolloutexpress.systemmodel.userdb.PersistentGrantedPermissionTable;
import com.raplix.rolloutexpress.systemmodel.userdb.PersistentPermissionDataTable;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBSubsystem;
import com.raplix.util.logger.Logger;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class FolderPermissionMigrator
extends TableMigrator {
    private static final FolderImplTable mTable = FolderImplTable.DEFAULT;
    GroupID[] mGroupsWithWritePerm;
    HashMap mHostsetExecPerm;
    HashMap mGroupsExecPerm;
    UserDBSubsystem mUserDB;
    private FolderID mAutogenFolderID;

    public FolderPermissionMigrator(UserDBSubsystem userDb) throws IOException {
        this.mUserDB = userDb;
        try {
            this.mGroupsWithWritePerm = this.getGroupsWithWritePerm();
            this.mHostsetExecPerm = new HashMap();
            this.mGroupsExecPerm = this.getGroupsWithExecPerm();
        }
        catch (Exception e) {
            throw new IOException("Unexpected Error: " + e.getMessage());
        }
    }

    protected Table getTable() {
        return mTable;
    }

    protected SelectList getSelectList() {
        return FolderPermissionMigrator.sList(FolderPermissionMigrator.mTable.ID);
    }

    protected ColumnNode getOrderColumn() {
        return FolderPermissionMigrator.mTable.ID;
    }

    protected Migratable processRow(ResultSet rs) throws PersistenceManagerException, SQLException {
        final ObjectID ID2 = FolderPermissionMigrator.mTable.ID.retrieveValue(rs);
        return new Migratable(){

            public void migrate() throws PersistenceManagerException {
                try {
                    FolderPermissionMigrator.this.migrate(ID2);
                }
                catch (RPCException e) {
                    throw new PersistenceManagerException(e);
                }
            }
        };
    }

    private void migrate(ObjectID id) throws PersistenceManagerException, RPCException {
        FolderID fID = (FolderID)id;
        Folder folder = null;
        folder = fID.getByIDQuery().select();
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Migrating permissions for folder : " + folder.getFullPathString(), this);
        }
        this.grantWritePermission(folder);
        this.grantExecPermission(folder);
        if (id.equals(this.getAutogenFolderID())) {
            GroupManager groupManager;
            FolderAccessData accessData = folder.getFolderAccessData();
            FolderPermissionItem permItem = accessData.getACL((groupManager = this.mUserDB.getLocalUserDBAdmin().getGroupManager()).getRegisteredGroupID());
            if (permItem == null) {
                permItem = new FolderPermissionItem(groupManager.getRegisteredGroupID());
            }
            permItem.setAutoRun(true);
            accessData.addACL(permItem);
            folder.setFolderAccessData(accessData);
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Saving Folder: " + folder.getFullPathString(), this);
        }
        folder.save();
    }

    private FolderID getAutogenFolderID() throws RPCException, PersistenceManagerException {
        if (this.mAutogenFolderID == null) {
            String autogenFolderPath = "/system/autogen/";
            this.mAutogenFolderID = SingleFolderQuery.byPath(autogenFolderPath).selectSummaryView().getID();
        }
        return this.mAutogenFolderID;
    }

    private void grantWritePermission(Folder folder) {
        if (this.mGroupsWithWritePerm == null || this.mGroupsWithWritePerm.length == 0) {
            return;
        }
        FolderAccessData accessData = folder.getFolderAccessData();
        for (int i = 0; i < this.mGroupsWithWritePerm.length; ++i) {
            FolderPermissionItem permItem = accessData.getACL(this.mGroupsWithWritePerm[i]);
            if (permItem == null) {
                permItem = new FolderPermissionItem(this.mGroupsWithWritePerm[i]);
            }
            permItem.setWrite(true);
            accessData.addACL(permItem);
            folder.setFolderAccessData(accessData);
            if (!Logger.isDebugEnabled(this)) continue;
            Logger.debug("Granted write permission to group id : " + this.mGroupsWithWritePerm[i] + " folder : " + folder.getFullPathString(), this);
        }
    }

    private void grantExecPermission(Folder folder) {
        PermissionID[] permIds = this.mGroupsExecPerm.keySet().toArray(new PermissionID[0]);
        if (permIds == null || permIds.length == 0) {
            return;
        }
        for (int pIndex = 0; pIndex < permIds.length; ++pIndex) {
            GroupIDSet grantedGroups = (GroupIDSet)this.mGroupsExecPerm.get(permIds[pIndex]);
            GroupID[] groups = null;
            if (grantedGroups == null) continue;
            groups = grantedGroups.toIDArray();
            FolderAccessData accessData = folder.getFolderAccessData();
            for (int gIndex = 0; gIndex < groups.length; ++gIndex) {
                FolderPermissionItem permItem = accessData.getACL(groups[gIndex]);
                if (permItem == null) {
                    permItem = new FolderPermissionItem(groups[gIndex]);
                    permItem.setAutoRun(true);
                } else {
                    permItem.setAutoRun(true);
                }
                String hostset = this.mHostsetExecPerm.get(permIds[pIndex]).toString();
                HostSetID hostsetID = null;
                if (hostset.startsWith("hostset:")) {
                    int index = hostset.indexOf(58);
                    String hostSetString = hostset.substring(index + 1);
                    hostsetID = new HostSetID(hostSetString);
                    permItem.setExecute(hostsetID);
                } else if (hostset.equals("allhosts")) {
                    permItem.setExecuteAllHosts(true);
                }
                accessData.addACL(permItem);
                folder.setFolderAccessData(accessData);
            }
        }
    }

    private HashMap getGroupsWithExecPerm() throws PersistenceManagerException, UserDBException, RPCException {
        ArrayList<PermissionID> pids = new ArrayList<PermissionID>();
        Permission[] perms = null;
        perms = this.mUserDB.getLocalUserDBAdmin().getPermissionManager().getPermissionsByCriteria(null, "com.raplix.rolloutexpress.executor.PlanExecutionPermission", null);
        if (perms != null) {
            for (int i = 0; i < perms.length; ++i) {
                pids.add(perms[i].getPermissionID());
                this.mHostsetExecPerm.put(perms[i].getPermissionID(), perms[i].getName());
            }
        }
        ObjectID[] pidArray = pids.toArray(new PermissionID[0]);
        HashMap result = this.getGrantedGroups((PermissionID[])pidArray);
        PersistentGrantedPermissionTable table = PersistentGrantedPermissionTable.DEFAULT;
        PersistentPermissionDataTable pTable = PersistentPermissionDataTable.DEFAULT;
        if (pidArray.length > 0) {
            ScalarList rList = FolderPermissionMigrator.rList(pidArray);
            FolderPermissionMigrator.execute(table.delete(PersistentGrantedPermissionTable.where(FolderPermissionMigrator.in((ColumnNode)table.Permission, rList))));
            FolderPermissionMigrator.execute(pTable.delete(PersistentPermissionDataTable.where(FolderPermissionMigrator.in((ColumnNode)pTable.ID, rList))));
        }
        return result;
    }

    private GroupID[] getGroupsWithWritePerm() throws PersistenceManagerException {
        PermissionID[] pIDs = new PermissionID[]{new PermissionID("010010001024-0000000000000-00010-0000000003"), new PermissionID("010010001024-0000000000000-00012-0000000003")};
        HashMap result = this.getGrantedGroups(pIDs);
        GroupIDSet[] groupSet = result.values().toArray(new GroupIDSet[0]);
        GroupIDSet groupIDs = new GroupIDSet();
        for (int i = 0; i < groupSet.length; ++i) {
            groupIDs.addAll((Collection)groupSet[i]);
        }
        PersistentGrantedPermissionTable table = PersistentGrantedPermissionTable.DEFAULT;
        PersistentPermissionDataTable pTable = PersistentPermissionDataTable.DEFAULT;
        ObjectID[] rwPIDs = new PermissionID[]{pIDs[0], pIDs[1], new PermissionID("010010001024-0000000000000-00009-0000000003"), new PermissionID("010010001024-0000000000000-00011-0000000003")};
        ScalarList rList = FolderPermissionMigrator.rList(rwPIDs);
        FolderPermissionMigrator.execute(table.delete(PersistentGrantedPermissionTable.where(FolderPermissionMigrator.in((ColumnNode)table.Permission, rList))));
        FolderPermissionMigrator.execute(pTable.delete(PersistentPermissionDataTable.where(FolderPermissionMigrator.in((ColumnNode)pTable.ID, rList))));
        return groupIDs.toIDArray();
    }

    private HashMap getGrantedGroups(PermissionID[] permIDs) throws PersistenceManagerException {
        final HashMap returnValue = new HashMap();
        final GroupID admin = this.mUserDB.getLocalUserDBAdmin().getGroupManager().getAdminGroupID();
        final PersistentGrantedPermissionTable table = PersistentGrantedPermissionTable.DEFAULT;
        if (permIDs == null || permIDs.length == 0) {
            return returnValue;
        }
        FolderPermissionMigrator.execute(FolderPermissionMigrator.select(FolderPermissionMigrator.sList(table.Group, (ScalarExp)table.Permission), FolderPermissionMigrator.tList(table), FolderPermissionMigrator.where(FolderPermissionMigrator.in((ColumnNode)table.Permission, FolderPermissionMigrator.rList(permIDs)))), new ResultSetProcessor(){

            public void processResultSet(ResultSet inResultSet) throws PersistenceManagerException, SQLException {
                while (inResultSet.next()) {
                    PermissionID permID = (PermissionID)table.Permission.retrieveValue(inResultSet);
                    GroupID groupID = (GroupID)table.Group.retrieveValue(inResultSet);
                    GroupIDSet gIDSet = null;
                    if (groupID.equals(admin)) continue;
                    gIDSet = (GroupIDSet)returnValue.get(permID);
                    if (gIDSet == null) {
                        gIDSet = new GroupIDSet();
                        returnValue.put(permID, gIDSet);
                    }
                    gIDSet.add(groupID);
                }
            }
        });
        return returnValue;
    }
}

