/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m41to50;

import com.raplix.rolloutexpress.migrate.EntityMigrator;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.persist.util.Link;
import com.raplix.rolloutexpress.systemmodel.folderdb.Folder;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderImplTable;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderToFolderLinkTable;
import com.raplix.rolloutexpress.systemmodel.folderdb.MultiFolderQuery;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.util.logger.Logger;
import com.raplix.util.string.StringEscapedTokenizer;
import java.util.HashMap;

public class FolderMigrator
implements EntityMigrator {
    public int migrate() throws PersistenceManagerException {
        MultiFolderQuery theMFQ = MultiFolderQuery.all();
        SummaryFolder[] theQueriedFolders = null;
        try {
            theQueriedFolders = theMFQ.selectSummaryView();
        }
        catch (RPCException e) {
            throw new PersistenceManagerException(e);
        }
        return this.doErrorTabulationPhase(theQueriedFolders);
    }

    private int doErrorTabulationPhase(SummaryFolder[] inQueriedFolders) {
        HashMap<String, SummaryFolder> thePreExistingFolderHash = new HashMap<String, SummaryFolder>();
        for (int i = 0; i < inQueriedFolders.length; ++i) {
            SummaryFolder theFolder = inQueriedFolders[i];
            thePreExistingFolderHash.put(theFolder.getFullPathString(), theFolder);
        }
        HashMap<String, SummaryFolder> theSavedFolderHash = new HashMap<String, SummaryFolder>();
        int theNumErrs = 0;
        block6: for (int i = 0; i < inQueriedFolders.length; ++i) {
            SummaryFolder theFolder = inQueriedFolders[i];
            if (theFolder.getID().equals(FolderID.ROOT_FOLDER_ID)) continue;
            String theFullPath = theFolder.getFullPathString();
            if (theFullPath.startsWith("/")) {
                theFullPath = theFullPath.substring(1, theFullPath.length());
            }
            if (theFullPath.endsWith("/")) {
                theFullPath = theFullPath.substring(0, theFullPath.length() - 1);
            }
            StringEscapedTokenizer theTokenizer = new StringEscapedTokenizer(theFullPath, "/", "");
            String theCurFullPath = "/";
            FolderID theCurParentID = FolderID.ROOT_FOLDER_ID;
            while (theTokenizer.hasMoreTokens()) {
                String theCurDir = theTokenizer.nextToken();
                SummaryFolder theSavedFolder = (SummaryFolder)theSavedFolderHash.get(theCurFullPath = theCurFullPath + theCurDir + "/");
                if (theSavedFolder == null) {
                    SummaryFolder thePreExistingFolder = (SummaryFolder)thePreExistingFolderHash.get(theCurFullPath);
                    if (thePreExistingFolder == null) {
                        Folder theNewFolder = null;
                        try {
                            theNewFolder = new Folder(theCurDir, theCurParentID, null);
                            theNewFolder.save();
                        }
                        catch (RPCException e) {
                            if (Logger.isErrorEnabled(this)) {
                                Logger.error("Unable to create new folder " + theCurFullPath, e, this);
                            }
                            ++theNumErrs;
                            continue block6;
                        }
                        catch (PersistenceManagerException e) {
                            if (Logger.isErrorEnabled(this)) {
                                Logger.error("Unable to create new folder " + theCurFullPath, e, this);
                            }
                            ++theNumErrs;
                            continue block6;
                        }
                        theSavedFolder = theNewFolder;
                    } else {
                        try {
                            FolderImplTable t = FolderImplTable.DEFAULT;
                            QueryBuilder.execute(QueryBuilder.update(t, QueryBuilder.uList(QueryBuilder.set(t.ParentFolderID, theCurParentID), QueryBuilder.set(t.Name, theCurDir)), QueryBuilder.where(QueryBuilder.equals(t.FullPathString, theCurFullPath))));
                            Link[] theNewParentLinks = FolderToFolderLinkTable.DEFAULT.getByChildIDs(new ObjectID[]{theCurParentID});
                            int theNumNewParents = theNewParentLinks == null ? 0 : theNewParentLinks.length;
                            ObjectID[] theParentIDs = new FolderID[theNumNewParents + 1];
                            for (int theLinkIdx = 0; theLinkIdx < theNumNewParents; ++theLinkIdx) {
                                theParentIDs[theLinkIdx] = theNewParentLinks[theLinkIdx].getParentObjectID();
                            }
                            theParentIDs[theNumNewParents] = theCurParentID;
                            FolderToFolderLinkTable.DEFAULT.addLinks(theParentIDs, thePreExistingFolder.getID());
                        }
                        catch (PersistenceManagerException e) {
                            if (Logger.isErrorEnabled(this)) {
                                Logger.error("Unable to modify existing folder " + theCurFullPath, e, this);
                            }
                            ++theNumErrs;
                            continue block6;
                        }
                        theSavedFolder = thePreExistingFolder;
                    }
                    theSavedFolderHash.put(theCurFullPath, theSavedFolder);
                }
                theCurParentID = theSavedFolder.getID();
            }
        }
        return theNumErrs;
    }
}

