/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m41to50;

import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigParser;
import com.raplix.rolloutexpress.config.ConfigTemplate;
import com.raplix.rolloutexpress.migrate.Migratable;
import com.raplix.rolloutexpress.migrate.TableMigrator;
import com.raplix.rolloutexpress.migrate.m41to50.RenameUtil;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.OrderByList;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.WhereClause;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.resource.ResourceTable;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.packageformat.ResourceContentTransformer;
import com.raplix.rolloutexpress.resource.packageformat.ResourceEntry;
import com.raplix.util.unicode.UnicodeInputStreamReader;
import com.raplix.util.unicode.UnicodeOutputStreamWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;

class ConfigTemplateMigrator
extends TableMigrator {
    private static ResourceTable TABLE = ResourceTable.DEFAULT;
    private ResourceSubsystem mRsrcSubsys;

    ConfigTemplateMigrator() throws IOException {
        try {
            this.mRsrcSubsys = PersistenceManager.getInstance().getApplication().getResourceSubsystem();
        }
        catch (UnsupportedSubsystemException e) {
            throw new IOException("unable to resolve resource subsystem");
        }
    }

    protected Table getTable() {
        return TABLE;
    }

    protected SelectList getSelectList() {
        return ConfigTemplateMigrator.sList(ConfigTemplateMigrator.TABLE.ID);
    }

    protected ColumnNode getOrderColumn() {
        return ConfigTemplateMigrator.TABLE.ID;
    }

    protected OrderByList getOrderByList() {
        return ConfigTemplateMigrator.oList(ConfigTemplateMigrator.orderByAsc(ConfigTemplateMigrator.TABLE.Version), ConfigTemplateMigrator.orderByAsc(ConfigTemplateMigrator.TABLE.ID));
    }

    protected WhereClause getWhereClause() {
        return ConfigTemplateMigrator.where(ConfigTemplateMigrator.and(ConfigTemplateMigrator.equals(ConfigTemplateMigrator.TABLE.IsConfigurable, true), ConfigTemplateMigrator.isNull(ConfigTemplateMigrator.TABLE.CustomParentID)));
    }

    protected Migratable processRow(ResultSet rs) throws PersistenceManagerException, SQLException {
        final ObjectID id = ConfigTemplateMigrator.TABLE.ID.retrieveValue(rs);
        return new Migratable(){

            public void migrate() throws PersistenceManagerException {
                ConfigTemplateMigrator.this.migrate(id);
            }

            public String toString() {
                return "ID:" + id;
            }
        };
    }

    private void migrate(ObjectID id) throws PersistenceManagerException {
        try {
            ResourceContentTransformer transformer = new ResourceContentTransformer(this.mRsrcSubsys){

                protected boolean transformEntryStream(ResourceEntry entry, InputStream in, OutputStream out) throws ResourceException, IOException {
                    return ConfigTemplateMigrator.this.transform(entry, in, out);
                }
            };
            transformer.transform((ResourceID)id, false, true);
        }
        catch (ResourceException e) {
            throw new PersistenceManagerException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean transform(ResourceEntry entry, InputStream in, OutputStream out) throws ResourceException, IOException {
        try {
            ConfigParser parser = new ConfigParser();
            UnicodeInputStreamReader reader = new UnicodeInputStreamReader(in);
            ConfigTemplate template = parser.createTemplate(reader);
            template = template.mapNames(RenameUtil.COMP_NAME_MAP);
            BufferedWriter writer = new BufferedWriter(new UnicodeOutputStreamWriter(out, reader));
            writer.write(template.toString());
            writer.flush();
            boolean bl = true;
            return bl;
        }
        catch (ConfigGenException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            in.close();
        }
    }
}

