/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m41to50;

import com.raplix.rolloutexpress.hierarchies.compexport.SourceInfo;
import com.raplix.rolloutexpress.migrate.Migratable;
import com.raplix.rolloutexpress.migrate.TableMigrator;
import com.raplix.rolloutexpress.migrate.m41to50.MigrateSourceInfo;
import com.raplix.rolloutexpress.migrate.m41to50.RenameUtil;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import com.raplix.util.file.Transform;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ComponentMigrator
extends TableMigrator {
    private static ComponentImplTable TABLE = ComponentImplTable.DEFAULT;
    private Transform[] mTransforms;

    public ComponentMigrator(Transform[] transforms) {
        this.mTransforms = transforms;
    }

    protected Table getTable() {
        return TABLE;
    }

    protected SelectList getSelectList() {
        return ComponentMigrator.sList(ComponentMigrator.TABLE.ID, ComponentMigrator.TABLE.XMLContent, ComponentMigrator.TABLE.LocalInstallPath, ComponentMigrator.TABLE.IgnorePaths).add(ComponentMigrator.sList(ComponentMigrator.TABLE.SourceInfoRawString, (ScalarExp)ComponentMigrator.TABLE.ExtendsTypeName));
    }

    protected ColumnNode getOrderColumn() {
        return ComponentMigrator.TABLE.ID;
    }

    protected Migratable processRow(ResultSet rs) throws PersistenceManagerException, SQLException {
        final ObjectID id = ComponentMigrator.TABLE.ID.retrieveValue(rs);
        final String xml = ComponentMigrator.TABLE.XMLContent.retrieveValue(rs);
        final String installPath = ComponentMigrator.TABLE.LocalInstallPath.retrieveValue(rs);
        final String ignoresArrStr = ComponentMigrator.TABLE.IgnorePaths.retrieveValue(rs);
        final String sourceInfoStr = ComponentMigrator.TABLE.SourceInfoRawString.retrieveValue(rs);
        final String extendsTypeName = ComponentMigrator.TABLE.ExtendsTypeName.retrieveValue(rs);
        return new Migratable(){

            public void migrate() throws PersistenceManagerException, IOException {
                ComponentMigrator.this.migrate(id, xml, installPath, ignoresArrStr, sourceInfoStr, extendsTypeName);
            }

            public String toString() {
                return "ID:" + id;
            }
        };
    }

    private void migrate(ObjectID id, String xml, String installPath, String ignoresArrStr, String sourceInfoStr, String extendsTypeName) throws PersistenceManagerException, IOException {
        xml = this.transform(xml, this.mTransforms);
        RenameUtil.setNameMap("component");
        installPath = RenameUtil.mapConfigVar(installPath);
        ignoresArrStr = RenameUtil.mapConfigArray(ignoresArrStr);
        sourceInfoStr = this.transformSourceInfo(sourceInfoStr, extendsTypeName);
        ComponentMigrator.execute(ComponentMigrator.update(TABLE, ComponentMigrator.uList(ComponentMigrator.set(ComponentMigrator.TABLE.XMLContent, xml), ComponentMigrator.set(ComponentMigrator.TABLE.LocalInstallPath, installPath), ComponentMigrator.set(ComponentMigrator.TABLE.IgnorePaths, ignoresArrStr)).add(ComponentMigrator.uList(ComponentMigrator.set(ComponentMigrator.TABLE.SourceInfoRawString, sourceInfoStr))), ComponentMigrator.where(ComponentMigrator.equals(ComponentMigrator.TABLE.ID, id))));
    }

    private String transformSourceInfo(String sourceInfoStr, String extendsTypeName) {
        if (sourceInfoStr == null) {
            return null;
        }
        MigrateSourceInfo oldSI = MigrateSourceInfo.reconstitute(null, sourceInfoStr);
        SourceInfo newSI = MigrateSourceInfo.translate(oldSI);
        if (this.isWeblogicType(extendsTypeName)) {
            newSI = this.updateWeblogicSourceInfo(newSI);
        } else if (this.isWindows_SimpleCompExporter_Type(extendsTypeName)) {
            newSI = this.updateWindowsSourceInfo(newSI, "Windows Component Browser");
        } else if (this.isWindows_MetabaseCompExporter_Type(extendsTypeName)) {
            newSI = this.updateWindowsSourceInfo(newSI, "MetabaseBrowser");
        }
        return newSI.getPersistString();
    }

    private SourceInfo updateWindowsSourceInfo(SourceInfo si, String newBrowserName) {
        SourceInfo newSI = new SourceInfo(si.getHost(), newBrowserName, si.getBrowseLocation(), si.getResourceLocation());
        String[] varNames = si.getVarNames();
        for (int i = 0; i < varNames.length; ++i) {
            newSI.addParameter(varNames[i], si.getVarValue(varNames[i]), si.getVarDescription(varNames[i]));
        }
        return newSI;
    }

    private boolean isWindows_SimpleCompExporter_Type(String inExtendsTypeName) {
        return inExtendsTypeName != null && (inExtendsTypeName.equals("com.sun.windows#COM+ application") || inExtendsTypeName.equals("com.sun.windows#registry key") || inExtendsTypeName.equals("com.sun.windows#data source name"));
    }

    private boolean isWindows_MetabaseCompExporter_Type(String inExtendsTypeName) {
        return inExtendsTypeName != null && (inExtendsTypeName.equals("com.sun.windows#IIS web site or virtual directory settings") || inExtendsTypeName.equals("com.sun.windows#IIS global settings") || inExtendsTypeName.equals("com.sun.windows#global ISAPI filter settings") || inExtendsTypeName.equals("com.sun.windows#website ISAPI filter settings"));
    }

    private boolean isWeblogicType(String extendsTypeName) {
        return extendsTypeName != null && extendsTypeName.startsWith("com.sun.weblogic#");
    }

    private SourceInfo updateWeblogicSourceInfo(SourceInfo si) {
        String browser = si.getVarValue("Browser");
        if (browser != null) {
            SourceInfo newSI = new SourceInfo(si.getHost(), browser, si.getBrowseLocation(), si.getResourceLocation());
            String[] varNames = si.getVarNames();
            for (int i = 0; i < varNames.length; ++i) {
                String name = varNames[i];
                if (name.equals("Browser")) continue;
                newSI.addParameter(name, si.getVarValue(name), si.getVarDescription(name));
            }
            si = newSI;
        }
        return si;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String transform(String value, Transform[] transforms) throws IOException {
        for (int i = 0; i < this.mTransforms.length; ++i) {
            StringReader in = new StringReader(value);
            try {
                StringWriter out = new StringWriter();
                try {
                    this.mTransforms[i].apply(in, out);
                    value = out.toString();
                    continue;
                }
                finally {
                    out.close();
                }
            }
            finally {
                in.close();
            }
        }
        return value;
    }
}

