/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m41to50;

import com.raplix.rolloutexpress.migrate.Migratable;
import com.raplix.rolloutexpress.migrate.TableMigrator;
import com.raplix.rolloutexpress.migrate.m41to50.RenameUtil;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettingsImplTable;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CompVarSetMigrator
extends TableMigrator {
    private static ComponentVariableSettingsImplTable TABLE = ComponentVariableSettingsImplTable.DEFAULT;

    protected Table getTable() {
        return TABLE;
    }

    protected SelectList getSelectList() {
        return CompVarSetMigrator.sList(CompVarSetMigrator.TABLE.ID, (ScalarExp)CompVarSetMigrator.TABLE.OverrideSettings);
    }

    protected ColumnNode getOrderColumn() {
        return CompVarSetMigrator.TABLE.ID;
    }

    protected Migratable processRow(ResultSet rs) throws PersistenceManagerException, SQLException {
        final ObjectID id = CompVarSetMigrator.TABLE.ID.retrieveValue(rs);
        final String overrides = CompVarSetMigrator.TABLE.OverrideSettings.retrieveValue(rs);
        return new Migratable(){

            public void migrate() throws PersistenceManagerException, IOException {
                CompVarSetMigrator.this.migrate(id, overrides);
            }

            public String toString() {
                return "ID:" + id;
            }
        };
    }

    private void migrate(ObjectID id, String overrides) throws PersistenceManagerException, IOException {
        RenameUtil.setNameMap("component");
        overrides = RenameUtil.mapConfigArray(overrides);
        CompVarSetMigrator.execute(CompVarSetMigrator.update(TABLE, CompVarSetMigrator.uList(CompVarSetMigrator.set(CompVarSetMigrator.TABLE.OverrideSettings, overrides)), CompVarSetMigrator.where(CompVarSetMigrator.equals(CompVarSetMigrator.TABLE.ID, id))));
    }
}

