/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m40to41;

import com.raplix.rolloutexpress.migrate.node.ChmodFileStep;
import com.raplix.rolloutexpress.migrate.node.CopyFileStep;
import com.raplix.rolloutexpress.migrate.node.ExecCommandUpgradeStep;
import com.raplix.rolloutexpress.migrate.node.IncludePlatformStepConstraint;
import com.raplix.rolloutexpress.migrate.node.MkdirStep;
import com.raplix.rolloutexpress.migrate.node.MoveFileStep;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeApp;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeContext;
import com.raplix.rolloutexpress.migrate.node.NodeUpgradeStep;
import com.raplix.rolloutexpress.migrate.node.Perl5TransformFileStep;
import com.raplix.rolloutexpress.migrate.node.PlatformStepConstraint;
import com.raplix.rolloutexpress.migrate.node.RemoveFileStep;
import com.raplix.rolloutexpress.migrate.node.StepConstraint;
import com.raplix.rolloutexpress.migrate.node.UpgradeTransformStep;
import com.raplix.util.file.Perl5Transform;
import com.raplix.util.platform.common.PlatformUtil;
import com.raplix.util.platform.posix.Stat;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NodeUpgrade
extends NodeUpgradeApp {
    private static final String mCRProperties = "config" + File.separator + "centerrun.properties";
    private static final String mConfigProperties = "config" + File.separator + "config.properties";
    private static final String mUnixCRKeysFilename = "bin" + File.separator + "crkeys";
    private static final String mCR_AgentFilename = "bin" + File.separator + "cr_agent";
    private static final String mCR_LDFilename = "bin" + File.separator + "cr_ld";
    private static final String mROXPolicyFilename = "lib" + File.separator + "security" + File.separator + "rox.policy";
    private static final String mShowBuildFilename = "bin" + File.separator + "ShowBuild.cmd";
    private static final String mRestartFilename = "bin" + File.separator + "restart.cmd";
    private static final String mWin32CRKeysFilename = "bin" + File.separator + "crkeys.cmd";
    private static final String mUpdateJExecFilename = "updjexec.sh";
    private static final String mJvmDirname = "jvm";
    private static final String mJvmJreDirname = "jvm" + File.separator + "jre";
    private static final String mRedirectFilename = mJvmJreDirname + File.separator + "bin" + File.separator + ".redirect";
    private static final String mCRPropPattern = "centerrun.properties";
    private static final String mCRPropSubstitution = "config.properties";
    private static final String mCenterRunPattern = "CenterRun ";
    private static final String mCR40LDPattern = "CenterRun 4.0 Distributor";
    private static final String mCR40RAPattern = "CenterRun 4.0 Agent";
    private static final String mEmptyStringSubstitution = "";
    private static final String mN1SPSSubstitution = "N1 Service Provisioning System ";
    private static final String mN141LDSubstitution = "N1 Service Provisioning System 4.1 Distributor";
    private static final String mN141RASubstitution = "N1 Service Provisioning System 4.1 Agent";
    private static final String mRoxHomeLibPattern = "{rox_home_dir}/../common/lib/-";
    private static final String mRoxHomeAppPattern = "{rox_home_dir}/../-";
    private static final String mUnixJREPattern = "^JRE_HOME=(.*)/common/jre$";
    private static final String mUnixAgentJRESubstitution = "JRE_HOME=$1/agent/jvm/jre";
    private static final String mUnixLDJRESubstitution = "JRE_HOME=$1/ld/jvm/jre";
    private static final String mWin32JREPattern = "^set JRE_HOME=(.*)\\\\common\\\\jre$";
    private static final String mWin32AgentJRESubstitution = "set JRE_HOME=$1\\\\agent\\\\jvm\\\\jre";
    private static final String mWin32LDJRESubstitution = "set JRE_HOME=$1\\\\ld\\\\jvm\\\\jre";
    private static final String mWin32RedirectPattern = "^.*\\\\common\\\\jre\\\\bin$";
    private static final String mWin32RedirectSubstitution = "..\\\\..\\\\jre1.3.1_09\\\\bin";
    private static final UpgradeTransformStep.FileResolver mAppHomeDir = UpgradeTransformStep.FileResolver.ApplicationHome;
    private static final UpgradeTransformStep.FileResolver mUpgradeDir = UpgradeTransformStep.FileResolver.UpgradeTemp;
    private static final UpgradeTransformStep.FileResolver mBackupDir = UpgradeTransformStep.FileResolver.UpgradeBackupBase;
    private static final UpgradeTransformStep.FileResolver mPlatformTempDir = UpgradeTransformStep.FileResolver.PlatformUpgradeTemp;
    private static final PlatformStepConstraint mUnixStepConstraint = new IncludePlatformStepConstraint().addUnix();
    private static final PlatformStepConstraint mUnixRAStepConstraint = new RAStepConstraint().addUnix();
    private static final PlatformStepConstraint mUnixLDStepConstraint = new LDStepConstraint().addUnix();
    private static final PlatformStepConstraint mWin32StepConstraint = new IncludePlatformStepConstraint().addWin32();
    private static final PlatformStepConstraint mWin32RAStepConstraint = new RAStepConstraint().addWin32();
    private static final PlatformStepConstraint mWin32LDStepConstraint = new LDStepConstraint().addWin32();
    private static final PlatformStepConstraint mLDStepConstraint = new LDStepConstraint().addWin32().addUnix();

    public static void main(String[] args) {
        NodeUpgrade upgradeApp = new NodeUpgrade();
        try {
            upgradeApp.run();
        }
        catch (Exception e) {
            upgradeApp.logError(e);
            upgradeApp.exitFailed();
        }
    }

    public NodeUpgradeStep[] getUpgradeSteps() {
        ArrayList stepList = new ArrayList();
        List steps = this.getProxyJVMSteps();
        stepList.addAll(steps);
        steps = this.getBackupSteps();
        stepList.addAll(steps);
        steps = this.getPropertiesFileSteps();
        stepList.addAll(steps);
        steps = this.getPerl5TransformFileSteps();
        stepList.addAll(steps);
        steps = this.getExecCommandUpgradeSteps();
        stepList.addAll(steps);
        steps = this.getRestartTransformFileSteps();
        stepList.addAll(steps);
        steps = this.getJExecUpgradeSteps();
        stepList.addAll(steps);
        steps = this.getCleanupSteps();
        stepList.addAll(steps);
        return stepList.toArray(new NodeUpgradeStep[0]);
    }

    NodeUpgrade() throws IllegalArgumentException {
    }

    private List getProxyJVMSteps() {
        ArrayList<NodeUpgradeStep> stepList = new ArrayList<NodeUpgradeStep>();
        stepList.add(new MkdirStep(null, mJvmDirname));
        stepList.add(new MoveFileStep(null, mJvmJreDirname, mJvmJreDirname, mPlatformTempDir, mAppHomeDir));
        if (PlatformUtil.isUnix()) {
            long mode = Stat.RWXU | Stat.RGRP | Stat.XGRP | Stat.ROTH | Stat.XOTH;
            stepList.add(new ChmodFileStep(mJvmJreDirname, mode, true));
            mode = Stat.RUSR | Stat.WUSR | Stat.RGRP | Stat.ROTH;
            stepList.add(new ChmodFileStep(mRedirectFilename, mode, true));
        }
        return stepList;
    }

    private List getBackupSteps() {
        ArrayList<CopyFileStep> stepList = new ArrayList<CopyFileStep>();
        stepList.add(new CopyFileStep(null, mCRProperties, mCRProperties, mAppHomeDir, mBackupDir, true));
        stepList.add(new CopyFileStep(mUnixRAStepConstraint, mCR_AgentFilename, mCR_AgentFilename, mAppHomeDir, mBackupDir, true));
        stepList.add(new CopyFileStep(mUnixLDStepConstraint, mCR_LDFilename, mCR_LDFilename, mAppHomeDir, mBackupDir, true));
        stepList.add(new CopyFileStep(mUnixStepConstraint, mUnixCRKeysFilename, mUnixCRKeysFilename, mAppHomeDir, mBackupDir, true));
        stepList.add(new CopyFileStep(mWin32StepConstraint, mShowBuildFilename, mShowBuildFilename, mAppHomeDir, mBackupDir, true));
        stepList.add(new CopyFileStep(mWin32StepConstraint, mRestartFilename, mRestartFilename, mAppHomeDir, mBackupDir, true));
        stepList.add(new CopyFileStep(mWin32StepConstraint, mWin32CRKeysFilename, mWin32CRKeysFilename, mAppHomeDir, mBackupDir, true));
        stepList.add(new CopyFileStep(mLDStepConstraint, mROXPolicyFilename, mROXPolicyFilename, mAppHomeDir, mBackupDir, true));
        stepList.add(new CopyFileStep(mWin32StepConstraint, mRedirectFilename, mRedirectFilename, mAppHomeDir, mBackupDir, true));
        return stepList;
    }

    private List getPropertiesFileSteps() {
        return Arrays.asList(new CopyFileStep(null, mCRProperties, mConfigProperties, mAppHomeDir, mAppHomeDir));
    }

    private List getPerl5TransformFileSteps() {
        Perl5Transform.Sub propertiesSub = new Perl5Transform.Sub(mCRPropPattern, mCRPropSubstitution);
        Perl5Transform.Sub emptyStringSub = new Perl5Transform.Sub(mCenterRunPattern, mEmptyStringSubstitution);
        Perl5Transform.Sub unixAgentJRESub = new Perl5Transform.Sub(mUnixJREPattern, mUnixAgentJRESubstitution);
        Perl5Transform.Sub unixLDJRESub = new Perl5Transform.Sub(mUnixJREPattern, mUnixLDJRESubstitution);
        Perl5Transform.Sub[] policySub = new Perl5Transform.Sub[]{new Perl5Transform.Sub(mRoxHomeLibPattern, mRoxHomeAppPattern)};
        Perl5Transform.Sub n1SPSSub = new Perl5Transform.Sub(mCenterRunPattern, mN1SPSSubstitution);
        Perl5Transform.Sub win32AgentJRESub = new Perl5Transform.Sub(mWin32JREPattern, mWin32AgentJRESubstitution);
        Perl5Transform.Sub win32LDJRESub = new Perl5Transform.Sub(mWin32JREPattern, mWin32LDJRESubstitution);
        Perl5Transform.Sub win32RedirectSub = new Perl5Transform.Sub(mWin32RedirectPattern, mWin32RedirectSubstitution);
        return Arrays.asList(new Perl5TransformFileStep(mLDStepConstraint, policySub, mROXPolicyFilename, mROXPolicyFilename, mBackupDir, mAppHomeDir), new Perl5TransformFileStep(mUnixRAStepConstraint, new Perl5Transform.Sub[]{propertiesSub, unixAgentJRESub}, mUnixCRKeysFilename, mUnixCRKeysFilename, mBackupDir, mAppHomeDir), new Perl5TransformFileStep(mUnixLDStepConstraint, new Perl5Transform.Sub[]{propertiesSub, unixLDJRESub}, mUnixCRKeysFilename, mUnixCRKeysFilename, mBackupDir, mAppHomeDir), new Perl5TransformFileStep(mUnixRAStepConstraint, new Perl5Transform.Sub[]{emptyStringSub, unixAgentJRESub}, mCR_AgentFilename, mCR_AgentFilename, mBackupDir, mAppHomeDir), new Perl5TransformFileStep(mUnixLDStepConstraint, new Perl5Transform.Sub[]{emptyStringSub, unixLDJRESub}, mCR_LDFilename, mCR_LDFilename, mBackupDir, mAppHomeDir), new Perl5TransformFileStep(mWin32RAStepConstraint, new Perl5Transform.Sub[]{n1SPSSub, win32AgentJRESub}, mShowBuildFilename, mShowBuildFilename, mBackupDir, mAppHomeDir), new Perl5TransformFileStep(mWin32LDStepConstraint, new Perl5Transform.Sub[]{n1SPSSub, win32LDJRESub}, mShowBuildFilename, mShowBuildFilename, mBackupDir, mAppHomeDir), new Perl5TransformFileStep(mWin32RAStepConstraint, new Perl5Transform.Sub[]{win32AgentJRESub}, mWin32CRKeysFilename, mWin32CRKeysFilename, mBackupDir, mAppHomeDir), new Perl5TransformFileStep(mWin32LDStepConstraint, new Perl5Transform.Sub[]{win32LDJRESub}, mWin32CRKeysFilename, mWin32CRKeysFilename, mBackupDir, mAppHomeDir), new Perl5TransformFileStep(mWin32StepConstraint, new Perl5Transform.Sub[]{win32RedirectSub}, mRedirectFilename, mRedirectFilename, mBackupDir, mAppHomeDir));
    }

    private List getExecCommandUpgradeSteps() {
        return Arrays.asList(new VBScriptExecCommandStep(mWin32RAStepConstraint, -1L, "-ra"), new VBScriptExecCommandStep(mWin32LDStepConstraint, -1L, "-ld"));
    }

    private List getJExecUpgradeSteps() {
        ArrayList<NodeUpgradeStep> stepList = new ArrayList<NodeUpgradeStep>();
        if (PlatformUtil.isUnix()) {
            long mode = Stat.RWXU | Stat.RGRP | Stat.XGRP | Stat.ROTH | Stat.XOTH;
            stepList.add(new ChmodFileStep(mUnixRAStepConstraint, mUpdateJExecFilename, mode, true, mUpgradeDir));
        }
        stepList.add(new UpdateJExecCommandStep(mUnixRAStepConstraint, -1L));
        return stepList;
    }

    private List getRestartTransformFileSteps() {
        Perl5Transform.Sub[] n1RASub = new Perl5Transform.Sub[]{new Perl5Transform.Sub(mCR40RAPattern, mN141RASubstitution)};
        Perl5Transform.Sub[] n1LDSub = new Perl5Transform.Sub[]{new Perl5Transform.Sub(mCR40LDPattern, mN141LDSubstitution)};
        return Arrays.asList(new Perl5TransformFileStep(mWin32RAStepConstraint, n1RASub, mRestartFilename, mRestartFilename, mBackupDir, mAppHomeDir), new Perl5TransformFileStep(mWin32LDStepConstraint, n1LDSub, mRestartFilename, mRestartFilename, mBackupDir, mAppHomeDir));
    }

    private List getCleanupSteps() {
        ArrayList<RemoveFileStep> stepList = new ArrayList<RemoveFileStep>();
        stepList.add(new RemoveFileStep(null, mCRProperties, mAppHomeDir));
        return stepList;
    }

    private static class LDStepConstraint
    extends IncludePlatformStepConstraint {
        private LDStepConstraint() {
        }

        public boolean shouldRunStep(NodeUpgradeContext ctx) {
            return this.currentPlatform() && ctx.isAppLD();
        }
    }

    private static class RAStepConstraint
    extends IncludePlatformStepConstraint {
        private RAStepConstraint() {
        }

        public boolean shouldRunStep(NodeUpgradeContext ctx) {
            return this.currentPlatform() && ctx.isAppRA();
        }
    }

    private static class UpdateJExecCommandStep
    extends ExecCommandUpgradeStep {
        public UpdateJExecCommandStep(StepConstraint constraint, long timeout) {
            super(constraint, timeout);
        }

        protected String[] getCmdArray(NodeUpgradeContext ctx) {
            return new String[]{mUpgradeDir.resolveFile(ctx, NodeUpgrade.mUpdateJExecFilename).getPath(), mAppHomeDir.resolveFile(ctx, "bin/protect/jexec").getPath(), mPlatformTempDir.resolveFile(ctx, "jexec").getPath(), mBackupDir.resolveFile(ctx, "bin/protect/jexec").getPath()};
        }
    }

    private static class VBScriptExecCommandStep
    extends ExecCommandUpgradeStep {
        private String mTarget;

        public VBScriptExecCommandStep(StepConstraint constraint, long timeout, String target) {
            super(constraint, timeout);
            this.mTarget = target;
        }

        protected String[] getCmdArray(NodeUpgradeContext ctx) {
            return new String[]{"cscript", mUpgradeDir.resolveFile(ctx, "migrate.vbs").getPath(), this.mTarget};
        }
    }
}

