/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m40to41;

import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.RaplixShutdownException;
import com.raplix.rolloutexpress.migrate.EntityMigrator;
import com.raplix.rolloutexpress.migrate.Migrator;
import com.raplix.rolloutexpress.migrate.TransformMigrator;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanImplTable;
import com.raplix.util.file.Transform;
import com.raplix.util.logger.Logger;
import java.io.IOException;

public class MigrateData
extends Migrator {
    public static final String PLAN_COMP_FILE_ARG = "-pcfile";
    public static final String NS_FILE_ARG = "-nsfile";
    private String mXSLPlanCompFile = null;
    private String mNamespaceTransformFile = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) {
        block14: {
            MigrateData migrator;
            int nErrors;
            block12: {
                block13: {
                    nErrors = 0;
                    migrator = null;
                    migrator = new MigrateData(args);
                    migrator.start();
                    nErrors = migrator.doMigration();
                    Object var5_3 = null;
                    if (migrator == null) break block12;
                    try {
                        migrator.shutdown();
                    }
                    catch (RaplixShutdownException rse) {
                        if (!Logger.isErrorEnabled(MigrateData.class)) break block13;
                        Logger.error("Error shutting down: ", rse, MigrateData.class);
                    }
                }
                migrator.exitProcess(nErrors);
                break block14;
            }
            System.exit(nErrors);
            {
                break block14;
                catch (Throwable e) {
                    ++nErrors;
                    if (Logger.isErrorEnabled(MigrateData.class)) {
                        Logger.error("Unexpected Error: ", e, MigrateData.class);
                    }
                    Object var5_4 = null;
                    if (migrator != null) {
                        block15: {
                            try {
                                migrator.shutdown();
                            }
                            catch (RaplixShutdownException rse) {
                                if (!Logger.isErrorEnabled(MigrateData.class)) break block15;
                                Logger.error("Error shutting down: ", rse, MigrateData.class);
                            }
                        }
                        migrator.exitProcess(nErrors);
                        break block14;
                    }
                    System.exit(nErrors);
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (migrator != null) {
                    block16: {
                        try {
                            migrator.shutdown();
                        }
                        catch (RaplixShutdownException rse) {
                            if (!Logger.isErrorEnabled(MigrateData.class)) break block16;
                            Logger.error("Error shutting down: ", rse, MigrateData.class);
                        }
                    }
                    migrator.exitProcess(nErrors);
                } else {
                    System.exit(nErrors);
                }
                throw throwable;
            }
        }
    }

    protected EntityMigrator[] getMigrators() throws IOException {
        Transform[] planTransforms = new Transform[]{this.getPerl5TransformerFromFile(this.mNamespaceTransformFile), this.getXSLTTransformerFromFile(this.mXSLPlanCompFile)};
        Transform[] compTransforms = new Transform[]{planTransforms[0], planTransforms[1]};
        return new EntityMigrator[]{new TransformMigrator(ComponentImplTable.DEFAULT, compTransforms, ComponentImplTable.DEFAULT.XMLContent), new TransformMigrator(ExecutionPlanImplTable.DEFAULT, planTransforms, ExecutionPlanImplTable.DEFAULT.BodyXML)};
    }

    MigrateData(String[] args) throws ConfigurationException {
        super(args);
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith(PLAN_COMP_FILE_ARG)) {
                this.mXSLPlanCompFile = args[++i];
                continue;
            }
            if (!args[i].startsWith(NS_FILE_ARG)) continue;
            this.mNamespaceTransformFile = args[++i];
        }
        if (this.mXSLPlanCompFile == null) {
            throw new IllegalArgumentException("Please supply the path to the XSL transform file (planComp_4.0_4.1.xsl) as -pcfile <fileName>");
        }
        if (this.mNamespaceTransformFile == null) {
            throw new IllegalArgumentException("Please supply the path to the perl transform file (namespace_4.0_4.1.xsl) as -nsfile <fileName>");
        }
    }
}

