/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m30to40;

import com.raplix.rolloutexpress.migrate.TransformMigrator;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.CallSpec;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemService;
import com.raplix.rolloutexpress.systemmodel.componentdb.VarDecl;

public class SystemServiceInfo {
    private boolean mHasInstallControl;
    private boolean mHasUninstallControl;
    private boolean mCanBeConfigTemplate;
    private String mParentSnapshotName;

    public boolean hasInstallControl() {
        return this.mHasInstallControl;
    }

    public boolean hasUninstallControl() {
        return this.mHasUninstallControl;
    }

    public boolean canBeConfigTemplate() {
        return this.mCanBeConfigTemplate;
    }

    public String getParentSnapshotName() {
        return this.mParentSnapshotName;
    }

    private SystemServiceInfo(boolean hasInstallControl, boolean hasUninstallControl, boolean canBeConfigTemplate, boolean hasDefaultSnapshot) {
        this.mHasInstallControl = hasInstallControl;
        this.mHasUninstallControl = hasUninstallControl;
        this.mCanBeConfigTemplate = canBeConfigTemplate;
        this.mParentSnapshotName = hasDefaultSnapshot ? "handlerDefault" : "noHandlerDefault";
    }

    public static SystemServiceInfo getCurrentInfo() throws PersistenceManagerException, RPCException {
        ComponentID compID = (ComponentID)TransformMigrator.getCurrentObjectID();
        SummaryComponent type = compID.getByIDQuery().selectSummaryView();
        String serviceName = type.getName().substring(0, type.getName().length() - 3);
        Component service = new SystemService(serviceName).getComponent();
        boolean hasInstall = service.resolveControlBlock("install", CallSpec.PUBLIC) != null;
        boolean hasUninstall = service.resolveControlBlock("uninstall", CallSpec.PUBLIC) != null;
        VarDecl var = service.resolveVar("isConfigurable", CallSpec.PUBLIC);
        boolean canBeConfig = var != null && Boolean.valueOf(var.getDefaultValue()) != false;
        boolean hasDefaultSnapshot = service.resolveSnapshotBlock("default", CallSpec.PUBLIC) != null;
        return new SystemServiceInfo(hasInstall, hasUninstall, canBeConfig, hasDefaultSnapshot);
    }
}

