/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m30to40;

import com.raplix.rolloutexpress.config.ConfigGenSubsystem;
import com.raplix.rolloutexpress.migrate.Migratable;
import com.raplix.rolloutexpress.migrate.TableMigrator;
import com.raplix.rolloutexpress.migrate.m30to40.MigrateUtil;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.persist.query.builder.BooleanColumn;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.EnumColumn;
import com.raplix.rolloutexpress.persist.query.builder.IntColumn;
import com.raplix.rolloutexpress.persist.query.builder.OrderByList;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.persist.query.builder.ResultSetProcessor;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.StringColumn;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.WhereClause;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSpec;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.resource.ResourceTable;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.resource.SingleRsrcInfoQuery;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryID;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentSaveContext;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentType;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostSetQuery;
import com.raplix.rolloutexpress.systemmodel.plugindb.SystemPluginConstants;
import com.raplix.util.enum.EnumFactory;
import java.sql.ResultSet;
import java.sql.SQLException;

class SimpleComponentMigrator
extends TableMigrator {
    private static final ResourceTempTable TABLE = ResourceTempTable.DEFAULT;
    private ConfigGenSubsystem mConfigGenSubsystem;
    private ResourceSubsystem mResourceSubsystem;

    public SimpleComponentMigrator(ConfigGenSubsystem cgss, ResourceSubsystem rss) {
        this.mConfigGenSubsystem = cgss;
        this.mResourceSubsystem = rss;
    }

    protected Table getTable() {
        return TABLE;
    }

    protected SelectList getSelectList() {
        return SimpleComponentMigrator.sList(SimpleComponentMigrator.TABLE.RsrcID, SimpleComponentMigrator.TABLE.Name, SimpleComponentMigrator.TABLE.Type).add(SimpleComponentMigrator.sList(SimpleComponentMigrator.TABLE.Description, SimpleComponentMigrator.TABLE.PlatformID, SimpleComponentMigrator.TABLE.SourceHostID)).add(SimpleComponentMigrator.sList(SimpleComponentMigrator.TABLE.Configurable)).add(SimpleComponentMigrator.sList(SimpleComponentMigrator.TABLE.SourcePath, SimpleComponentMigrator.TABLE.Visibility, SimpleComponentMigrator.TABLE.Version));
    }

    protected ColumnNode getOrderColumn() {
        return null;
    }

    protected OrderByList getOrderByList() {
        return SimpleComponentMigrator.oList(SimpleComponentMigrator.orderByAsc(SimpleComponentMigrator.TABLE.Name), SimpleComponentMigrator.orderByAsc(SimpleComponentMigrator.TABLE.Version));
    }

    protected WhereClause getWhereClause() {
        return SimpleComponentMigrator.where(SimpleComponentMigrator.isNull(SimpleComponentMigrator.TABLE.CustomParentID));
    }

    protected Migratable processRow(ResultSet rs) throws PersistenceManagerException, SQLException {
        return new RsrcData(rs);
    }

    static String mapTypeName(String typeName) {
        if ("RPM Package".equals(typeName)) {
            return "rpm file";
        }
        return typeName;
    }

    public static CategoryIDSet selectCatIDs(Select catIDs, final ColumnNode catCol) throws PersistenceManagerException {
        final CategoryIDSet result = new CategoryIDSet();
        ResultSetProcessor proc = new ResultSetProcessor(){

            public void processResultSet(ResultSet rs) throws SQLException {
                String colName = catCol.getSQLColumnName();
                while (rs.next()) {
                    String idVal = StringColumn.getValue(rs, colName);
                    result.add(new CategoryID(idVal));
                }
            }
        };
        SimpleComponentMigrator.execute(catIDs, proc);
        return result;
    }

    private ConfigGenSubsystem getConfigGenSubsystem() {
        return this.mConfigGenSubsystem;
    }

    private ResourceSubsystem getResourceSubsystem() {
        return this.mResourceSubsystem;
    }

    private static class RsrcToCatLinkTempTable
    extends Table {
        public final transient StringColumn ChildID = new StringColumn(this, this, "ChildID"){
            private final /* synthetic */ RsrcToCatLinkTempTable this$0;
            {
                this.this$0 = this$0;
                super(x0, x1);
            }

            public String getColumnName() {
                return "C_CHILD_ID";
            }
        };
        public final transient StringColumn ParentID = new StringColumn(this, this, "ParentID"){
            private final /* synthetic */ RsrcToCatLinkTempTable this$0;
            {
                this.this$0 = this$0;
                super(x0, x1);
            }

            public String getColumnName() {
                return "C_PARENT_ID";
            }
        };
        public static final RsrcToCatLinkTempTable DEFAULT = new RsrcToCatLinkTempTable();

        public Class getJavaClass() {
            return null;
        }

        public RsrcToCatLinkTempTable(String alias) {
            super(alias);
            this.addColumn(this.ChildID);
            this.addColumn(this.ParentID);
        }

        private RsrcToCatLinkTempTable() {
            this(null);
        }

        public Table instance() {
            return DEFAULT;
        }

        public Table instance(String alias) {
            return new RsrcToCatLinkTempTable(alias);
        }

        public String getTableName() {
            return "RT_RESOURCE_TO_CAT_LINK";
        }

        public void checkReadPermission() {
        }

        public void checkWritePermission() {
        }

        public void checkDeletePermission() {
        }

        public CategoryIDSet getRsrcCats(ResourceID rsrcID) throws PersistenceManagerException {
            Select query = this.select(RsrcToCatLinkTempTable.sList(this.ParentID), RsrcToCatLinkTempTable.where(RsrcToCatLinkTempTable.equals(this.ChildID, rsrcID.toString())));
            return SimpleComponentMigrator.selectCatIDs(query, this.ParentID);
        }
    }

    private static class ResourceTempTable
    extends Table {
        public final transient StringColumn RsrcID = new StringColumn(this, this, "RsrcID"){
            private final /* synthetic */ ResourceTempTable this$0;
            {
                this.this$0 = this$0;
                super(x0, x1);
            }

            public String getColumnName() {
                return "OBJECTID";
            }
        };
        public final transient StringColumn Name = new StringColumn(this, this, "Name"){
            private final /* synthetic */ ResourceTempTable this$0;
            {
                this.this$0 = this$0;
                super(x0, x1);
            }

            public String getColumnName() {
                return "C_NAME";
            }
        };
        public final transient StringColumn Type = new StringColumn(this, this, "Type"){
            private final /* synthetic */ ResourceTempTable this$0;
            {
                this.this$0 = this$0;
                super(x0, x1);
            }

            public String getColumnName() {
                return "C_TYPE";
            }
        };
        public final transient StringColumn CustomParentID = new StringColumn(this, this, "CustomParentID"){
            private final /* synthetic */ ResourceTempTable this$0;
            {
                this.this$0 = this$0;
                super(x0, x1);
            }

            public String getColumnName() {
                return "C_CUSTOMPARENTID";
            }
        };
        public final transient StringColumn SourceHostID = new StringColumn(this, this, "SourceHostID"){
            private final /* synthetic */ ResourceTempTable this$0;
            {
                this.this$0 = this$0;
                super(x0, x1);
            }

            public String getColumnName() {
                return "C_SOURCE_HOSTID";
            }
        };
        public final transient StringColumn SourcePath = new StringColumn(this, this, "SourcePath"){
            private final /* synthetic */ ResourceTempTable this$0;
            {
                this.this$0 = this$0;
                super(x0, x1);
            }

            public String getColumnName() {
                return "C_SOURCEPATH";
            }
        };
        public final transient StringColumn Description = new StringColumn(this, this, "Description"){
            private final /* synthetic */ ResourceTempTable this$0;
            {
                this.this$0 = this$0;
                super(x0, x1);
            }

            public String getColumnName() {
                return "C_DESCRIPTION";
            }
        };
        public final transient StringColumn PlatformID = new StringColumn(this, this, "PlatformID"){
            private final /* synthetic */ ResourceTempTable this$0;
            {
                this.this$0 = this$0;
                super(x0, x1);
            }

            public String getColumnName() {
                return "C_PLATFORM";
            }
        };
        public final transient StringColumn Visibility = new StringColumn(this, this, "Visibility"){
            private final /* synthetic */ ResourceTempTable this$0;
            {
                this.this$0 = this$0;
                super(x0, x1);
            }

            public String getColumnName() {
                return "C_VISIBILITY";
            }
        };
        public final transient IntColumn Version = new IntColumn(this, this, "Version"){
            private final /* synthetic */ ResourceTempTable this$0;
            {
                this.this$0 = this$0;
                super(x0, x1);
            }

            public String getColumnName() {
                return "VERSION";
            }
        };
        public final transient BooleanColumn Configurable = new BooleanColumn(this, this, "Configurable"){
            private final /* synthetic */ ResourceTempTable this$0;
            {
                this.this$0 = this$0;
                super(x0, x1);
            }

            public String getColumnName() {
                return "C_CONFIGURABLE";
            }
        };
        public static final ResourceTempTable DEFAULT = new ResourceTempTable();

        public Class getJavaClass() {
            return null;
        }

        public ResourceTempTable(String alias) {
            super(alias);
            this.addColumn(this.Name);
            this.addColumn(this.Type);
            this.addColumn(this.CustomParentID);
            this.addColumn(this.SourceHostID);
            this.addColumn(this.SourcePath);
            this.addColumn(this.Description);
            this.addColumn(this.PlatformID);
            this.addColumn(this.Visibility);
            this.addColumn(this.Version);
            this.addColumn(this.RsrcID);
            this.addColumn(this.Configurable);
        }

        private ResourceTempTable() {
            this(null);
        }

        public Table instance() {
            return DEFAULT;
        }

        public Table instance(String alias) {
            return new ResourceTempTable(alias);
        }

        public String getTableName() {
            return "RT_RESOURCE";
        }

        public void checkReadPermission() {
        }

        public void checkWritePermission() {
        }

        public void checkDeletePermission() {
        }
    }

    private class RsrcData
    implements Migratable {
        private ResourceID mRsrcID;
        private String mRsrcName;
        private VersionNumber mVersion;
        private String mTypeName;
        private String mDescription;
        private HostSetID mPlatformID;
        private HostID mSourceHostID;
        private String mSourcePath;
        private Visibility mVisibility;
        private boolean mConfigurable;

        public RsrcData(ResultSet rs) throws PersistenceManagerException, SQLException {
            this.mRsrcID = new ResourceID(TABLE.RsrcID.retrieveValue(rs));
            this.mRsrcName = TABLE.Name.retrieveValue(rs);
            this.mVersion = new VersionNumber(TABLE.Version.retrieveValue(rs));
            this.mTypeName = TABLE.Type.retrieveValue(rs);
            this.mDescription = TABLE.Description.retrieveValue(rs);
            String platformIDStr = TABLE.PlatformID.retrieveValue(rs);
            this.mPlatformID = platformIDStr == null ? null : new HostSetID(platformIDStr);
            String sourceHostIDStr = TABLE.SourceHostID.retrieveValue(rs);
            this.mSourceHostID = sourceHostIDStr == null ? null : new HostID(sourceHostIDStr);
            this.mSourcePath = TABLE.SourcePath.retrieveValue(rs);
            this.mVisibility = (Visibility)EnumColumn.getValue(rs, (EnumFactory)Visibility.FACTORY, TABLE.Visibility.getSQLColumnName());
            this.mConfigurable = TABLE.Configurable.retrieveValue(rs);
        }

        public void migrate() throws PersistenceManagerException {
        }

        private Component createComponent() throws PersistenceManagerException, RPCException, ResourceException {
            Component comp = new Component();
            comp.setName(MigrateUtil.getCompName(this.mRsrcName));
            ComponentType type = ComponentType.create(SimpleComponentMigrator.mapTypeName(this.mTypeName));
            comp.setExtendsType(type);
            ResourceSpec rsrcSpec = new ResourceSpec(this.mRsrcName);
            RsrcInfo rsrc = SingleRsrcInfoQuery.bySpec(rsrcSpec, this.mVersion.getAsString()).select();
            comp.setLocalResource(rsrc);
            if (this.mDescription != null) {
                comp.setDescription(this.mDescription);
            }
            this.setPlatform(comp);
            return comp;
        }

        private void setPlatform(Component comp) throws PersistenceManagerException, RPCException {
            String compPlatformName;
            HostSetID rsrcPlatformID = this.mPlatformID;
            if (rsrcPlatformID == null) {
                rsrcPlatformID = SystemPluginConstants.getInstance().ALL_PLATFORMS_ID;
            }
            String rsrcPlatformName = rsrcPlatformID.getByIDQuery().selectSummaryView().getName();
            String typePlatformName = comp.getExtendsType().getComponent().getPlatform();
            HostSetID typePlatformID = SingleHostSetQuery.byName(typePlatformName).selectSummaryView().getID();
            if (typePlatformID.equals(rsrcPlatformID) || typePlatformID.isDescendant(rsrcPlatformID)) {
                compPlatformName = rsrcPlatformName;
            } else {
                System.err.println("warning: found resource platform " + rsrcPlatformName + " when expecting " + typePlatformName + " for resource " + this.mRsrcName + " version " + this.mVersion.getAsString() + ".  Using expected platform instead.");
                compPlatformName = typePlatformName;
            }
            comp.setPlatform(compPlatformName);
        }

        Component attachPreviousVersion(Component comp) throws PersistenceManagerException, RPCException {
            try {
                Component existingComp = SingleComponentQuery.byName(comp.getPath(), comp.getName(), null).select();
                existingComp.readFromXML(comp.writeToXML());
                comp = existingComp;
            }
            catch (NoResultsFoundException noResultsFoundException) {
                // empty catch block
            }
            return comp;
        }

        private void save(Component comp) throws PersistenceManagerException, RPCException {
            ComponentSaveContext ctx = new ComponentSaveContext(this){
                private final /* synthetic */ RsrcData this$1;
                {
                    this.this$1 = this$1;
                }

                public VersionNumber getVersionToSaveAs() {
                    return RsrcData.access$100(this.this$1);
                }
            };
            ctx.setLatestVersion(comp);
            comp.save(ctx);
        }

        private void updateUserAndTimestamp(Component comp) throws PersistenceManagerException {
            ComponentImplTable ct = ComponentImplTable.DEFAULT;
            ResourceTable rt = ResourceTable.DEFAULT;
            ScalarExp userID = QueryBuilder.scalar(rt.select(QueryBuilder.sList(rt.UserID), QueryBuilder.where(ResourceTable.equals(rt.ID, this.mRsrcID))));
            ScalarExp timestamp = QueryBuilder.scalar(rt.select(QueryBuilder.sList(rt.TimeStamp), QueryBuilder.where(ResourceTable.equals(rt.ID, this.mRsrcID))));
            QueryBuilder.execute(ct.update(QueryBuilder.uList(QueryBuilder.set((ColumnNode)ct.UserID, userID), QueryBuilder.set((ColumnNode)ct.TimeStamp, timestamp)), QueryBuilder.where(ResourceTable.equals(ct.ID, comp.getID()))));
        }

        static /* synthetic */ VersionNumber access$100(RsrcData x0) {
            return x0.mVersion;
        }
    }
}

