/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m30to40;

import com.raplix.rolloutexpress.migrate.Migratable;
import com.raplix.rolloutexpress.migrate.TableMigrator;
import com.raplix.rolloutexpress.migrate.m30to40.ComponentTempTable;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.IntColumn;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.StringColumn;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.WhereClause;
import com.raplix.rolloutexpress.systemmodel.componentdb.AccessMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentType;
import com.raplix.rolloutexpress.systemmodel.componentdb.Modifier;
import com.raplix.rolloutexpress.systemmodel.componentdb.SnapshotBlock;
import com.raplix.rolloutexpress.systemmodel.componentdb.VarDecl;
import com.raplix.rolloutexpress.systemmodel.plandb.CaptureSnapshotStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.SuperTargeter;
import java.sql.ResultSet;
import java.sql.SQLException;

abstract class ResourceHandlerMigrator
extends TableMigrator {
    private static final SystemServiceRefTempTable TABLE = SystemServiceRefTempTable.DEFAULT;
    private static final String HAS_INSTALL_CONTROL_VAR = "hasInstallControl";
    private static final String HAS_UNINSTALL_CONTROL_VAR = "hasUninstallControl";
    static final String DEFAULT_BLOCK_NAME = "default";

    protected Table getTable() {
        return TABLE;
    }

    protected SelectList getSelectList() {
        return ResourceHandlerMigrator.sList(ResourceHandlerMigrator.TABLE.Name);
    }

    protected ColumnNode getOrderColumn() {
        return ResourceHandlerMigrator.TABLE.Name;
    }

    protected WhereClause getWhereClause() {
        return ResourceHandlerMigrator.where(TABLE.isResourceHandler());
    }

    protected Migratable processRow(ResultSet rs) throws PersistenceManagerException, SQLException {
        return new SystemServiceData(rs);
    }

    abstract void migrate(SystemServiceData var1) throws PersistenceManagerException, RPCException;

    ComponentType getBaseRHType() throws PersistenceManagerException, RPCException {
        return ComponentType.create("resource handler");
    }

    ComponentRef toCompRef(Component comp) {
        return new ComponentRef(comp.getPath(), comp.getName(), comp.getVersionNumber().getAsString());
    }

    void addConfigurableState(Component comp, boolean isConfigurable) {
    }

    void addInstallState(Component comp, boolean hasInstallControl) {
        this.addStateVar(comp, hasInstallControl, HAS_INSTALL_CONTROL_VAR);
    }

    void addUninstallState(Component comp, boolean hasUninstallControl) {
        this.addStateVar(comp, hasUninstallControl, HAS_UNINSTALL_CONTROL_VAR);
    }

    private void addStateVar(Component comp, boolean state, String varName) {
        comp.addLocalVar(new VarDecl(AccessMode.PROTECTED, Modifier.FINAL, varName, String.valueOf(state)));
    }

    boolean addSnapshotState(Component comp, boolean hasDefaultSnapshot) {
        String parentSnapName = hasDefaultSnapshot ? "handlerDefault" : "noHandlerDefault";
        CaptureSnapshotStep superSnap = new CaptureSnapshotStep(parentSnapName, new SuperTargeter(), null);
        SnapshotBlock snap = new SnapshotBlock(null, null, DEFAULT_BLOCK_NAME, "", null, new ExecStep[]{superSnap}, null, null, null);
        comp.addLocalSnapshotBlock(snap);
        return hasDefaultSnapshot;
    }

    Select selectSystemServiceCompID(String serviceName) {
        ComponentImplTable ct = ComponentImplTable.DEFAULT;
        return ct.select(ResourceHandlerMigrator.sList(ct.ID), ResourceHandlerMigrator.where(this.isServiceComp(ct, serviceName)));
    }

    ConditionalExpression isServiceComp(ComponentImplTable ct, String serviceName) {
        return ResourceHandlerMigrator.in(ResourceHandlerMigrator.cList(ct.Name, (ColumnNode)ct.Version), TABLE.selectCompByName(serviceName));
    }

    public void copyUserAndTimestampFromService(ComponentID compID, String serviceName) throws PersistenceManagerException {
        ComponentImplTable ot = ComponentImplTable.DEFAULT;
        ComponentImplTable it = ComponentImplTable.DEFAULT;
        ScalarExp userID = ResourceHandlerMigrator.scalar(it.select(ResourceHandlerMigrator.sList(it.UserID), ResourceHandlerMigrator.where(this.isServiceComp(it, serviceName))));
        ScalarExp timestamp = ResourceHandlerMigrator.scalar(it.select(ResourceHandlerMigrator.sList(it.TimeStamp), ResourceHandlerMigrator.where(this.isServiceComp(it, serviceName))));
        ResourceHandlerMigrator.execute(ot.update(ResourceHandlerMigrator.uList(ResourceHandlerMigrator.set((ColumnNode)ot.UserID, userID), ResourceHandlerMigrator.set((ColumnNode)ot.TimeStamp, timestamp)), ResourceHandlerMigrator.where(ResourceHandlerMigrator.equals(ot.ID, compID))));
    }

    static class SystemServiceRefTempTable
    extends Table {
        public final transient StringColumn Name = new StringColumn(this, this, "Name"){
            private final /* synthetic */ SystemServiceRefTempTable this$0;
            {
                this.this$0 = this$0;
                super(x0, x1);
            }

            public String getColumnName() {
                return "C_NAME";
            }
        };
        public final transient StringColumn CompName = new StringColumn(this, this, "CompName"){
            private final /* synthetic */ SystemServiceRefTempTable this$0;
            {
                this.this$0 = this$0;
                super(x0, x1);
            }

            public String getColumnName() {
                return "C_INST_COMP_NAME";
            }
        };
        public final transient IntColumn CompVersion = new IntColumn(this, this, "CompVersion"){
            private final /* synthetic */ SystemServiceRefTempTable this$0;
            {
                this.this$0 = this$0;
                super(x0, x1);
            }

            public String getColumnName() {
                return "C_INST_COMP_VERSION";
            }
        };
        public static final SystemServiceRefTempTable DEFAULT = new SystemServiceRefTempTable();

        public Class getJavaClass() {
            return null;
        }

        public SystemServiceRefTempTable(String alias) {
            super(alias);
            this.addColumn(this.Name);
            this.addColumn(this.CompName);
            this.addColumn(this.CompVersion);
        }

        private SystemServiceRefTempTable() {
            this(null);
        }

        public Table instance() {
            return DEFAULT;
        }

        public Table instance(String alias) {
            return new SystemServiceRefTempTable(alias);
        }

        public String getTableName() {
            return "RT_SYSTEM_SERVICE_REF";
        }

        public void checkReadPermission() {
        }

        public void checkWritePermission() {
        }

        public void checkDeletePermission() {
        }

        public ConditionalExpression isResourceHandler() {
            ComponentTempTable ct = ComponentTempTable.DEFAULT;
            return SystemServiceRefTempTable.in(SystemServiceRefTempTable.cList(this.CompName, (ColumnNode)this.CompVersion), ct.selectResourceHandlerNamesAndVersions());
        }

        public Select selectCompByName(String serviceName) {
            return this.select(SystemServiceRefTempTable.sList(this.CompName, (ScalarExp)this.CompVersion), SystemServiceRefTempTable.where(SystemServiceRefTempTable.equals(this.Name, serviceName)));
        }
    }

    class SystemServiceData
    implements Migratable {
        String mServiceName;

        public SystemServiceData(ResultSet rs) throws PersistenceManagerException, SQLException {
            this.mServiceName = TABLE.Name.retrieveValue(rs);
        }

        public void migrate() throws PersistenceManagerException {
            try {
                ResourceHandlerMigrator.this.migrate(this);
            }
            catch (RPCException e) {
                throw new PersistenceManagerException(e);
            }
        }
    }
}

