/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.migrate.m30to40;

import com.raplix.rolloutexpress.migrate.m30to40.ResourceHandlerMigrator;
import com.raplix.rolloutexpress.migrate.m30to40.SimpleComponentMigrator;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ScalarExp;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentImplTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentToCategoryLinkTable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRef;

class Pass1ResourceHandlerMigrator
extends ResourceHandlerMigrator {
    public static final String DEP_NAME = "type2handler";

    void migrate(ResourceHandlerMigrator.SystemServiceData data) throws PersistenceManagerException, RPCException {
    }

    private CategoryIDSet getCatsForSystemService(String serviceName) throws PersistenceManagerException {
        Select refdComp = this.selectSystemServiceCompID(serviceName);
        ComponentToCategoryLinkTable lt = ComponentToCategoryLinkTable.DEFAULT;
        Select cats = lt.selectParentIDs(refdComp);
        return SimpleComponentMigrator.selectCatIDs(cats, lt.ParentID);
    }

    private ComponentTypeRef createRsrcHandlerCompType(Component impl, String name) throws PersistenceManagerException, RPCException {
        ComponentTypeRef compType = new ComponentTypeRef();
        compType.setSimpleName(name);
        compType.setDescription("component type for resource handler " + name);
        compType.setComponentRef(this.toCompRef(impl));
        compType.setOrder("000750-000000-000000");
        compType.setGroup("any custom type");
        compType.setIndentLevel(1);
        compType.save();
        return compType;
    }

    public void copyAttributesFromService(ComponentID compID, String serviceName) throws PersistenceManagerException {
        ComponentImplTable ot = ComponentImplTable.DEFAULT;
        ComponentImplTable it = ComponentImplTable.DEFAULT;
        ScalarExp platform = Pass1ResourceHandlerMigrator.scalar(it.select(Pass1ResourceHandlerMigrator.sList(it.Platform), Pass1ResourceHandlerMigrator.where(this.isServiceComp(it, serviceName))));
        ScalarExp desc = Pass1ResourceHandlerMigrator.scalar(it.select(Pass1ResourceHandlerMigrator.sList(it.Description), Pass1ResourceHandlerMigrator.where(this.isServiceComp(it, serviceName))));
        ScalarExp label = Pass1ResourceHandlerMigrator.scalar(it.select(Pass1ResourceHandlerMigrator.sList(it.Label), Pass1ResourceHandlerMigrator.where(this.isServiceComp(it, serviceName))));
        ScalarExp author = Pass1ResourceHandlerMigrator.scalar(it.select(Pass1ResourceHandlerMigrator.sList(it.Author), Pass1ResourceHandlerMigrator.where(this.isServiceComp(it, serviceName))));
        ScalarExp vendor = Pass1ResourceHandlerMigrator.scalar(it.select(Pass1ResourceHandlerMigrator.sList(it.SoftwareVendor), Pass1ResourceHandlerMigrator.where(this.isServiceComp(it, serviceName))));
        Pass1ResourceHandlerMigrator.execute(ot.update(Pass1ResourceHandlerMigrator.uList(Pass1ResourceHandlerMigrator.set((ColumnNode)ot.Platform, platform), Pass1ResourceHandlerMigrator.set((ColumnNode)ot.Description, desc), Pass1ResourceHandlerMigrator.set((ColumnNode)ot.Label, label)).add(Pass1ResourceHandlerMigrator.uList(Pass1ResourceHandlerMigrator.set((ColumnNode)ot.Author, author), Pass1ResourceHandlerMigrator.set((ColumnNode)ot.SoftwareVendor, vendor))), Pass1ResourceHandlerMigrator.where(Pass1ResourceHandlerMigrator.equals(ot.ID, compID))));
    }
}

